/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.parsers.cfg;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.eclipse.core.runtime.Path;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.CfgDefinitionInformation;
import org.eclipse.titan.common.parsers.cfg.CfgParseResult;
import org.eclipse.titan.common.path.PathConverter;

public class CfgParseTreePrinter {
    private static final String INCLUDED_BEGIN = "//This part was originally found in file: ";
    private static final String INCLUDED_END = "//End of file: ";
    private static final Pattern PATTERN_MACRO = Pattern.compile("\\$\\s*\\{?\\s*([A-Za-z][A-Za-z0-9_]*)\\s*\\}?");
    private static final Pattern PATTERN_TYPED_MACRO = Pattern.compile("\\$\\s*\\{\\s*([A-Za-z][A-Za-z0-9_]*)\\s*,\\s*[A-Za-z][A-Za-z0-9_]*\\s*\\}");
    final StringBuilder mSb;
    final List<Integer> mDisallowedNodes;
    final LinkedHashMap<Path, CfgParseResult> mCfgParseResults;
    final Map<String, CfgDefinitionInformation> mDefinitions;
    final Map<String, String> mEnvVariables;
    final List<Path> mFilesToResolve;

    public CfgParseTreePrinter(StringBuilder aSb, List<Integer> aDisallowedNodes, LinkedHashMap<Path, CfgParseResult> aCfgParseResults, Map<String, CfgDefinitionInformation> aDefinitions, Map<String, String> aEnvVariables, List<Path> aFilesToResolve) {
        this.mSb = aSb;
        this.mDisallowedNodes = aDisallowedNodes;
        this.mCfgParseResults = aCfgParseResults;
        this.mDefinitions = aDefinitions;
        this.mEnvVariables = aEnvVariables;
        this.mFilesToResolve = aFilesToResolve;
    }

    public CfgParseTreePrinter(StringBuilder aSb, List<Integer> aDisallowedNodes) {
        this(aSb, aDisallowedNodes, null, null, null, null);
    }

    public CfgParseTreePrinter(StringBuilder aSb) {
        this(aSb, null);
    }

    public static String toStringWithHidden(ParseTree aParseTreeRoot, List<Token> aTokens, boolean aPrintHiddenBefore) {
        StringBuilder sb = new StringBuilder();
        CfgParseTreePrinter printer = new CfgParseTreePrinter(sb);
        printer.print(aParseTreeRoot, aTokens, aPrintHiddenBefore, ResolveMode.NO_RESOLVING, null);
        return sb.toString();
    }

    public static void printResolved(LinkedHashMap<Path, CfgParseResult> aCfgParseResults, StringBuilder aSb, List<Integer> aDisallowedNodes, ResolveMode aResolveMode, Map<String, CfgDefinitionInformation> aDefinitions, Map<String, String> aEnvVariables) {
        switch (aResolveMode) {
            case IN_ROW: {
                ArrayList<Path> filesToResolve = new ArrayList<Path>(aCfgParseResults.keySet());
                CfgParseTreePrinter printer = new CfgParseTreePrinter(aSb, aDisallowedNodes, aCfgParseResults, aDefinitions, aEnvVariables, filesToResolve);
                for (Map.Entry<Path, CfgParseResult> entry : aCfgParseResults.entrySet()) {
                    printer.printResolved(entry.getKey(), (ParseTree)entry.getValue().getParseTreeRoot(), entry.getValue().getTokens(), aResolveMode);
                }
                break;
            }
            case NESTED: {
                ArrayList<Path> filesToResolve = new ArrayList<Path>(aCfgParseResults.keySet());
                Map.Entry<Path, CfgParseResult> entry = aCfgParseResults.entrySet().iterator().next();
                CfgParseTreePrinter printer = new CfgParseTreePrinter(aSb, aDisallowedNodes, aCfgParseResults, aDefinitions, aEnvVariables, filesToResolve);
                printer.printResolved(entry.getKey(), (ParseTree)entry.getValue().getParseTreeRoot(), entry.getValue().getTokens(), aResolveMode);
                break;
            }
        }
    }

    private void printResolved(Path aFile, ParseTree aParseTreeRoot, List<Token> aTokens, ResolveMode aResolveMode) {
        if (this.mFilesToResolve.contains(aFile)) {
            this.mSb.append(INCLUDED_BEGIN).append(aFile.toOSString()).append('\n');
            this.print(aParseTreeRoot, aTokens, true, aResolveMode, aFile);
            this.mSb.append(INCLUDED_END).append(aFile.toOSString()).append('\n');
            this.mFilesToResolve.remove(aFile);
        }
    }

    private void print(ParseTree aParseTree, List<Token> aTokens, boolean aPrintHiddenBefore, ResolveMode aResolveMode, Path aFile) {
        if (aParseTree == null) {
            ErrorReporter.logWarning("ConfigTreeNodeUtilities.print(): aParseTree == null");
            return;
        }
        if (aParseTree instanceof ParserRuleContext) {
            ParserRuleContext rule = (ParserRuleContext)aParseTree;
            if (this.mDisallowedNodes != null && this.mDisallowedNodes.contains(rule.start.getType())) {
                return;
            }
            if (aPrintHiddenBefore && rule.getChildCount() > 0 && rule.getChild(0) instanceof AddedParseTree) {
                this.printHiddenTokensBefore(rule, aTokens);
            }
        } else if (aParseTree instanceof TerminalNodeImpl) {
            TerminalNodeImpl tn = (TerminalNodeImpl)aParseTree;
            Token token = tn.getSymbol();
            if (this.mDisallowedNodes == null || !this.mDisallowedNodes.contains(token.getType())) {
                this.printToken(token, aTokens, aPrintHiddenBefore, aResolveMode, aFile);
            }
        } else if (aParseTree instanceof AddedParseTree) {
            AddedParseTree t = (AddedParseTree)aParseTree;
            this.mSb.append(t.getText());
        } else {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.print(): unexpected ParseTree type");
        }
        for (int i = 0; i < aParseTree.getChildCount(); ++i) {
            ParseTree child = aParseTree.getChild(i);
            if (child == aParseTree) {
                ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.print(): child == aParseTree");
                continue;
            }
            this.print(child, aTokens, aPrintHiddenBefore || i > 0, aResolveMode, aFile);
        }
    }

    private void printToken(Token aToken, List<Token> aTokens, boolean aPrintHiddenBefore, ResolveMode aResolveMode, Path aFile) {
        int tokenIndex = aToken.getTokenIndex();
        if (tokenIndex > -1 && aPrintHiddenBefore) {
            this.printHiddenTokensBefore(aToken, aTokens);
        }
        if (aResolveMode != ResolveMode.NO_RESOLVING) {
            this.resolveToken(aToken, aResolveMode, aFile);
        } else {
            String tokenText = aToken.getText();
            this.mSb.append(tokenText != null ? tokenText : "");
        }
    }

    private void printHiddenTokensBefore(Token aToken, List<Token> aTokens) {
        int tokenIndex = aToken.getTokenIndex();
        if (tokenIndex == -1) {
            return;
        }
        int startHiddenIndex = tokenIndex;
        while (CfgParseTreePrinter.isHiddenToken(startHiddenIndex - 1, aTokens)) {
            --startHiddenIndex;
        }
        for (int i = startHiddenIndex; i < tokenIndex; ++i) {
            Token t = aTokens.get(i);
            String tokenText = t.getText();
            this.mSb.append(tokenText != null ? tokenText : "");
        }
    }

    private void printHiddenTokensBefore(ParserRuleContext aRule, List<Token> aTokens) {
        Token startToken = aRule.start;
        if (startToken == null) {
            return;
        }
        this.printHiddenTokensBefore(startToken, aTokens);
    }

    public static boolean isHiddenToken(int aIndex, List<Token> aTokens) {
        if (aTokens == null) {
            ErrorReporter.INTERNAL_ERROR("ConfigTreeNodeUtilities.isHiddenToken(): aTokens == null");
            return false;
        }
        return aIndex >= 0 && aIndex < aTokens.size() && aTokens.get(aIndex).getChannel() > 0;
    }

    private void resolveToken(Token aToken, ResolveMode aResolveMode, Path aFile) {
        int tokenType = aToken.getType();
        if (CfgParseTreePrinter.isMacro(tokenType)) {
            String macroValue = this.getMacroValue(aToken);
            this.mSb.append(macroValue);
        } else if (CfgParseTreePrinter.isTypedMacro(tokenType)) {
            String macroValue = this.getTypedMacroValue(aToken);
            this.mSb.append(macroValue);
        } else if (tokenType == 52) {
            if (aResolveMode == ResolveMode.NESTED) {
                this.resolveTokenNestedInclude(aToken, aResolveMode, aFile);
            }
        } else if (tokenType == 63) {
            this.resolveTokenNestedInclude(aToken, aResolveMode, aFile);
        } else {
            String tokenText = aToken.getText();
            this.mSb.append(tokenText != null ? tokenText : "");
        }
    }

    private void resolveTokenNestedInclude(Token aToken, ResolveMode aResolveMode, Path aFile) {
        String tokenText = aToken.getText();
        String filename = tokenText.replaceAll("^\"|\"$", "");
        Path absolutePath = CfgParseTreePrinter.getAbsolutePath(aFile, filename);
        CfgParseResult cfgParseResult = this.mCfgParseResults.get(absolutePath);
        if (cfgParseResult != null) {
            this.printResolved(absolutePath, (ParseTree)cfgParseResult.getParseTreeRoot(), cfgParseResult.getTokens(), aResolveMode);
        } else {
            ErrorReporter.INTERNAL_ERROR("ParseTreePrinter.resolveTokenNestedInclude(): cfgParseResult == null");
        }
    }

    private static Path getAbsolutePath(Path aBaseFile, String aFilename) {
        String absoluteFilename = PathConverter.getAbsolutePath(aBaseFile.toOSString(), aFilename);
        if (absoluteFilename == null) {
            return null;
        }
        return new Path(absoluteFilename);
    }

    private static boolean isMacro(int aTokenType) {
        return aTokenType == 43 || aTokenType == 94 || aTokenType == 120 || aTokenType == 141 || aTokenType == 237 || aTokenType == 254 || aTokenType == 406 || aTokenType == 471;
    }

    private static boolean isTypedMacro(int aTokenType) {
        return aTokenType == 40 || aTokenType == 42 || aTokenType == 45 || aTokenType == 48 || aTokenType == 75 || aTokenType == 77 || aTokenType == 79 || aTokenType == 81 || aTokenType == 83 || aTokenType == 85 || aTokenType == 87 || aTokenType == 89 || aTokenType == 91 || aTokenType == 93 || aTokenType == 119 || aTokenType == 145 || aTokenType == 146 || aTokenType == 147 || aTokenType == 160 || aTokenType == 206 || aTokenType == 209 || aTokenType == 211 || aTokenType == 213 || aTokenType == 215 || aTokenType == 220 || aTokenType == 224 || aTokenType == 228 || aTokenType == 230 || aTokenType == 251 || aTokenType == 253 || aTokenType == 399 || aTokenType == 401 || aTokenType == 403 || aTokenType == 405;
    }

    private String getDefinitionValue(String aDefinition) {
        if (this.mDefinitions != null && this.mDefinitions.containsKey(aDefinition)) {
            return this.mDefinitions.get(aDefinition).getValue();
        }
        if (this.mEnvVariables != null && this.mEnvVariables.containsKey(aDefinition)) {
            return this.mEnvVariables.get(aDefinition);
        }
        return null;
    }

    private static String getMacroName(String aMacroString) {
        Matcher m = PATTERN_MACRO.matcher(aMacroString);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private static String getTypedMacroName(String aMacroString) {
        Matcher m = PATTERN_TYPED_MACRO.matcher(aMacroString);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private String getMacroValue(Token aMacroToken) {
        String definition = CfgParseTreePrinter.getMacroName(aMacroToken.getText());
        String value = this.getDefinitionValue(definition);
        if (value == null) {
            return "";
        }
        return value;
    }

    private String getTypedMacroValue(Token aMacroToken) {
        String definition = CfgParseTreePrinter.getTypedMacroName(aMacroToken.getText());
        String value = this.getDefinitionValue(definition);
        if (value == null) {
            return "";
        }
        return value;
    }

    public static enum ResolveMode {
        NO_RESOLVING,
        IN_ROW,
        NESTED;

    }
}

