/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ModuleImportation;

public final class ModuleImportationChain {
    public static final String CIRCULARREFERENCE = "Circular reference chain: `{0}''";
    private final List<ModuleImportation> chainLinks = new ArrayList<ModuleImportation>();
    private final Stack<Integer> marked_states = new Stack();
    private String message;
    private boolean isError;

    public ModuleImportationChain(String message, boolean isError) {
        this.message = message;
        this.isError = isError;
    }

    public boolean add(ModuleImportation chainLink) {
        int index = -1;
        for (int i = 0; i < this.chainLinks.size() && index == -1; ++i) {
            if (!this.chainLinks.get((int)i).identifier.getDisplayName().equals(chainLink.getIdentifier().getDisplayName())) continue;
            index = i;
        }
        if (index >= 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = index; i < this.chainLinks.size(); ++i) {
                int i2;
                builder.setLength(0);
                for (i2 = i; i2 < this.chainLinks.size(); ++i2) {
                    if (builder.length() != 0) {
                        builder.append(" -> ");
                    }
                    builder.append(this.chainLinks.get(i2).chainedDescription());
                }
                for (i2 = index; i2 < i; ++i2) {
                    if (builder.length() != 0) {
                        builder.append(" -> ");
                    }
                    builder.append(this.chainLinks.get(i2).chainedDescription());
                }
                if (builder.length() != 0) {
                    builder.append(" -> ");
                }
                builder.append(this.chainLinks.get(i).chainedDescription());
                Location location = this.chainLinks.get(i).getChainLocation();
                if (location == null) continue;
                if (this.isError) {
                    location.reportSingularSemanticError(MessageFormat.format(this.message, builder.toString()));
                    continue;
                }
                location.reportSingularSemanticWarning(MessageFormat.format(this.message, builder.toString()));
            }
            return false;
        }
        this.chainLinks.add(chainLink);
        return true;
    }

    public boolean contains(ModuleImportation chainLink) {
        int size = this.chainLinks.size();
        for (int i = 0; i < size; ++i) {
            if (!this.chainLinks.get((int)i).identifier.getDisplayName().equals(chainLink.getIdentifier().getDisplayName())) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.chainLinks.clear();
        this.marked_states.clear();
    }

    public void markState() {
        this.marked_states.add(this.chainLinks.size());
    }

    public void previousState() {
        if (this.marked_states.empty()) {
            return;
        }
        for (int i = this.chainLinks.size() - 1; i >= (Integer)this.marked_states.get(this.marked_states.size() - 1); --i) {
            this.chainLinks.remove(i);
        }
        this.marked_states.remove(this.marked_states.size() - 1);
    }
}

