/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ParameterisedSubReference
extends ASTNode
implements ISubReference,
ILocateableNode {
    public static final String INVALIDSUBREFERENCE = "The type `{0}'' cannot be parameterised.";
    public static final String INVALIDVALUESUBREFERENCE = "Invalid reference: internal parameterisation is not supported";
    private final Identifier identifier;
    private ParsedActualParameters parsedParameters;
    private ActualParameterList actualParameters;
    private Location location;

    public ParameterisedSubReference(Identifier identifier, ParsedActualParameters parsedParameters) {
        this.identifier = identifier;
        this.parsedParameters = parsedParameters;
        if (parsedParameters != null) {
            parsedParameters.setFullNameParent(this);
        }
    }

    @Override
    public ISubReference.Subreference_type getReferenceType() {
        return ISubReference.Subreference_type.parameterisedSubReference;
    }

    @Override
    public Identifier getId() {
        return this.identifier;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.parsedParameters != null) {
            this.parsedParameters.setMyScope(scope);
        }
    }

    public ParsedActualParameters getParsedParameters() {
        return this.parsedParameters;
    }

    public ActualParameterList getActualParameters() {
        return this.actualParameters;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public boolean checkParameters(CompilationTimeStamp timestamp, FormalParameterList formalParameterList) {
        this.actualParameters = new ActualParameterList();
        boolean isErroneous = formalParameterList.checkActualParameterList(timestamp, this.parsedParameters, this.actualParameters);
        this.actualParameters.setFullNameParent(this);
        this.actualParameters.setMyScope(this.myScope);
        return isErroneous;
    }

    public String toString() {
        return "parameterisedSubReference: " + this.identifier.getDisplayName();
    }

    @Override
    public void appendDisplayName(StringBuilder builder) {
        if (builder.length() > 0) {
            builder.append('.');
        }
        builder.append(this.identifier.getDisplayName()).append("()");
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.parsedParameters != null) {
            this.parsedParameters.updateSyntax(reparser, false);
            reparser.updateLocation(this.parsedParameters.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.parsedParameters != null) {
            this.parsedParameters.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.identifier != null && !this.identifier.accept(v)) {
            return false;
        }
        return this.parsedParameters == null || this.parsedParameters.accept(v);
    }
}

