/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMappingTarget;

public final class TypeMappingTargets
extends ASTNode {
    private final List<TypeMappingTarget> targets = new ArrayList<TypeMappingTarget>();

    public void addMappingTarget(TypeMappingTarget mappingTarget) {
        this.targets.add(mappingTarget);
    }

    public int getNofTargets() {
        return this.targets.size();
    }

    public TypeMappingTarget getTargetByIndex(int index) {
        return this.targets.get(index);
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.targets.size();
        for (int i = 0; i < size; ++i) {
            TypeMappingTarget target = this.targets.get(i);
            if (target != child) continue;
            return builder.append(".<target ").append(i + 1).append('>');
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        int size = this.targets.size();
        for (int i = 0; i < size; ++i) {
            this.targets.get(i).setMyScope(scope);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.targets == null) {
            return;
        }
        for (TypeMappingTarget tmt : this.targets) {
            tmt.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.targets != null) {
            for (TypeMappingTarget tmt : this.targets) {
                if (tmt.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

