/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.Setting;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TTCN3Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Default_ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Referenced_ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Value_ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedParameter;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedParameters;
import org.eclipse.titan.designer.AST.TTCN3.templates.NotUsed_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstances;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.SkeletonTemplateProposal;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Keywords;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class FormalParameterList
extends TTCN3Scope
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".<unknown_parameter>";
    public static final String DUPLICATEPARAMETERFIRST = "Duplicate parameter with name `{0}'' was first declared here";
    public static final String DUPLICATEPARAMETERREPEATED = "Duplicate parameter with name `{0}'' was declared here again";
    public static final String HIDINGSCOPEELEMENT = "Parameter with identifier `{0}'' is not unique in the scope hierarchy";
    public static final String HIDDENSCOPEELEMENT = "Previous definition with identifier `{0}'' in higher scope unit is here";
    public static final String HIDINGMODULEIDENTIFIER = "Parameter with name `{0}'' hides a module identifier";
    public static final String MISSINGPARAMETER = "There is no value specified for formal parameter `{0}''";
    private static final String ILLEGALACTIVATEPARAMETER = "Parameter {0} of {1} refers to {2}, which is a local definition within a statement block and may have shorter lifespan than the activated default. Only references to variables and timers defined in the component type can be passed to activated defaults";
    private static final String TOOMANYPARAMETERS = "More than {0} parameters";
    private static final String CANNOTBESTARTED = "a parameter or embedded in a parameter of a function used in a start operation. {0} `{1}'' cannot be start on a parallel test component";
    private final List<FormalParameter> parameters = new ArrayList<FormalParameter>();
    private Location location = NULL_Location.INSTANCE;
    private Definition myDefinition;
    private CompilationTimeStamp lastTimeChecked;
    private CompilationTimeStamp lastTimeUniquenessChecked;
    private Map<String, FormalParameter> parameterMap;
    private int minimumNofParameters = 0;
    private boolean isStartable;
    private static String reportTooManyParameters;
    private static int reportTooManyParametersSize;

    public FormalParameterList(List<FormalParameter> parameters) {
        for (FormalParameter parameter : parameters) {
            if (parameter == null || parameter.getIdentifier() == null) continue;
            this.parameters.add(parameter);
            parameter.setFullNameParent(this);
            parameter.setFormalParamaterList(this);
        }
    }

    @Override
    public final StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            FormalParameter parameter = this.parameters.get(i);
            if (parameter != child) continue;
            Identifier identifier = parameter.getIdentifier();
            return builder.append(".").append(identifier != null ? identifier.getDisplayName() : FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public final Location getLocation() {
        return this.location;
    }

    @Override
    public final void setLocation(Location location) {
        this.location = location;
    }

    public final Definition getMyDefinition() {
        return this.myDefinition;
    }

    public final void setMyDefinition(Definition definition) {
        this.myDefinition = definition;
    }

    public final boolean getStartability() {
        return this.isStartable;
    }

    public final int getNofParameters() {
        return this.parameters.size();
    }

    public final FormalParameter getParameterByIndex(int index) {
        return this.parameters.get(index);
    }

    public final FormalParameter getParameterById(Identifier id) {
        if (this.parameterMap == null || id == null) {
            return null;
        }
        return this.parameterMap.get(id.getName());
    }

    public final boolean hasNotusedDefaultValue() {
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!this.parameters.get(i).hasNotusedDefaultValue()) continue;
            return true;
        }
        return false;
    }

    public final boolean hasOnlyDefaultValues() {
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (null != this.parameters.get(i).getDefaultParameter()) continue;
            return false;
        }
        return true;
    }

    public final void setMyScope(Scope scope) {
        this.setParentScope(scope);
        for (FormalParameter parameter : this.parameters) {
            parameter.setMyScope(this);
        }
    }

    public void reset() {
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            FormalParameter parameter = this.parameters.get(i);
            parameter.reset();
        }
    }

    private void checkUniqueness(CompilationTimeStamp timestamp) {
        if (this.lastTimeUniquenessChecked != null && !this.lastTimeUniquenessChecked.isLess(timestamp)) {
            return;
        }
        if (this.parameterMap != null) {
            this.parameterMap.clear();
        }
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            FormalParameter parameter = this.parameters.get(i);
            if (parameter == null) continue;
            String parameterName = parameter.getIdentifier().getName();
            if (this.parameterMap == null) {
                this.parameterMap = new HashMap<String, FormalParameter>(this.parameters.size());
            }
            if (this.parameterMap.containsKey(parameterName)) {
                Location otherLocation = this.parameterMap.get(parameterName).getIdentifier().getLocation();
                otherLocation.reportSingularSemanticError(MessageFormat.format(DUPLICATEPARAMETERFIRST, parameter.getIdentifier().getDisplayName()));
                Location paramLocation = parameter.getIdentifier().getLocation();
                paramLocation.reportSemanticError(MessageFormat.format(DUPLICATEPARAMETERREPEATED, parameter.getIdentifier().getDisplayName()));
                continue;
            }
            this.parameterMap.put(parameterName, parameter);
        }
        this.lastTimeUniquenessChecked = timestamp;
    }

    public final void check(CompilationTimeStamp timestamp, Assignment.Assignment_type definitionType) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.minimumNofParameters = 0;
        this.isStartable = true;
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            FormalParameter parameter = this.parameters.get(i);
            Identifier identifier = parameter.getIdentifier();
            if (this.parentScope != null) {
                if (this.parentScope.hasAssignmentWithId(timestamp, identifier)) {
                    parameter.getLocation().reportSemanticError(MessageFormat.format(HIDINGSCOPEELEMENT, identifier.getDisplayName()));
                    this.parentScope.hasAssignmentWithId(timestamp, identifier);
                    ArrayList<ISubReference> subReferences = new ArrayList<ISubReference>();
                    subReferences.add(new FieldSubReference(identifier));
                    Reference reference = new Reference(null, subReferences);
                    Assignment assignment = this.parentScope.getAssBySRef(timestamp, reference);
                    if (assignment != null && assignment.getLocation() != null) {
                        assignment.getLocation().reportSingularSemanticWarning(MessageFormat.format(HIDDENSCOPEELEMENT, identifier.getDisplayName()));
                    }
                } else if (this.parentScope.isValidModuleId(identifier)) {
                    parameter.getLocation().reportSemanticWarning(MessageFormat.format(HIDINGMODULEIDENTIFIER, identifier.getDisplayName()));
                }
            }
            parameter.check(timestamp);
            if (parameter.getAssignmentType() != parameter.getRealAssignmentType()) {
                parameter = parameter.setParameterType(parameter.getRealAssignmentType());
                this.parameters.set(i, parameter);
            }
            if (Assignment.Assignment_type.A_TEMPLATE.equals(definitionType)) {
                if (!(Assignment.Assignment_type.A_PAR_VAL_IN.equals(parameter.getAssignmentType()) || Assignment.Assignment_type.A_PAR_VAL.equals(parameter.getAssignmentType()) || Assignment.Assignment_type.A_PAR_TEMP_IN.equals(parameter.getAssignmentType()))) {
                    parameter.getLocation().reportSemanticError("A template cannot have " + parameter.getAssignmentName());
                }
            } else if (Assignment.Assignment_type.A_TESTCASE.equals(definitionType) && Assignment.Assignment_type.A_PAR_TIMER.equals(parameter.getAssignmentType()) && Assignment.Assignment_type.A_PAR_PORT.equals(parameter.getAssignmentType())) {
                parameter.getLocation().reportSemanticError("A testcase cannot have " + parameter.getAssignmentName());
            }
            switch (parameter.getAssignmentType()) {
                case A_PAR_VAL: 
                case A_PAR_VAL_IN: 
                case A_PAR_TEMP_IN: 
                case A_PAR_VAL_INOUT: 
                case A_PAR_TEMP_INOUT: {
                    Type tempType = parameter.getType(timestamp);
                    if (!this.isStartable || tempType == null || !tempType.isComponentInternal(timestamp)) break;
                    this.isStartable = false;
                    break;
                }
                default: {
                    this.isStartable = false;
                }
            }
            if (parameter.hasDefaultValue()) continue;
            this.minimumNofParameters = i + 1;
        }
        if (this.parameters.size() > reportTooManyParametersSize) {
            this.getLocation().reportConfigurableSemanticProblem(reportTooManyParameters, MessageFormat.format(TOOMANYPARAMETERS, reportTooManyParametersSize));
        }
        this.checkUniqueness(timestamp);
        this.lastTimeChecked = timestamp;
    }

    public final void postCheck() {
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            this.parameters.get(i).postCheck();
        }
    }

    public final void checkNoLazyParams() {
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            if (!this.parameters.get(i).getIsLazy()) continue;
            Location tempLocation = this.parameters.get(i).getLocation();
            tempLocation.reportSemanticError(MessageFormat.format("Formal parameter `{0}'' cannot be @lazy, not supported in this case.", this.parameters.get(i).getAssignmentName()));
        }
    }

    public final void collateLazyAndNonLazyActualParameters(CompilationTimeStamp timestamp, ParsedActualParameters parsedParameters, ActualParameterList actualLazyParameters, ActualParameterList actualNonLazyParameters) {
        int i;
        ASTNode temp;
        FormalParameter formalParameter;
        TemplateInstances unnamed = parsedParameters.getInstances();
        NamedParameters named = parsedParameters.getNamedParameters();
        int nofLocated = unnamed.getNofTis();
        HashMap<FormalParameter, Integer> formalParameterMap = new HashMap<FormalParameter, Integer>();
        int size = this.parameters.size();
        for (int i2 = 0; i2 < size; ++i2) {
            formalParameterMap.put(this.parameters.get(i2), i2);
        }
        TemplateInstances finalUnnamed = new TemplateInstances(unnamed);
        int size2 = named.getNofParams();
        for (int i3 = 0; i3 < size2; ++i3) {
            NamedParameter namedParameter = named.getParamByIndex(i3);
            formalParameter = this.parameterMap.get(namedParameter.getName().getName());
            int isAt = (Integer)formalParameterMap.get(formalParameter);
            while (nofLocated < isAt) {
                temp = new NotUsed_Template();
                if (!this.parameters.get(nofLocated).hasDefaultValue()) {
                    ((Setting)temp).setIsErroneous(true);
                }
                TemplateInstance instance = new TemplateInstance(null, null, (TTCN3Template)temp);
                instance.setLocation(parsedParameters.getLocation());
                finalUnnamed.addTemplateInstance(instance);
                ++nofLocated;
            }
            finalUnnamed.addTemplateInstance(namedParameter.getInstance());
            ++nofLocated;
        }
        finalUnnamed.setLocation(parsedParameters.getLocation());
        int upperLimit = finalUnnamed.getNofTis() < this.parameters.size() ? finalUnnamed.getNofTis() : this.parameters.size();
        for (i = 0; i < upperLimit; ++i) {
            TemplateInstance instance = finalUnnamed.getInstanceByIndex(i);
            formalParameter = this.parameters.get(i);
            if (instance.getType() == null && instance.getDerivedReference() == null && ITTCN3Template.Template_type.TEMPLATE_NOTUSED.equals((Object)instance.getTemplateBody().getTemplatetype())) {
                ActualParameter defaultValue = formalParameter.getDefaultValue();
                temp = new Default_ActualParameter(defaultValue);
                if (defaultValue != null && !defaultValue.getIsErroneous()) {
                    ((ActualParameter)temp).setLocation(defaultValue.getLocation());
                }
                if (formalParameter.getIsLazy()) {
                    actualLazyParameters.addParameter((ActualParameter)temp);
                    continue;
                }
                actualNonLazyParameters.addParameter((ActualParameter)temp);
                continue;
            }
            ActualParameter actualParameter = formalParameter.checkActualParameter(timestamp, instance, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            actualParameter.setLocation(instance.getLocation());
            if (formalParameter.getIsLazy()) {
                actualLazyParameters.addParameter(actualParameter);
                continue;
            }
            actualNonLazyParameters.addParameter(actualParameter);
        }
        for (i = upperLimit; i < this.parameters.size(); ++i) {
            FormalParameter formalParameter2 = this.parameters.get(i);
            ActualParameter defaultValue = formalParameter2.getDefaultValue();
            Default_ActualParameter temp2 = new Default_ActualParameter(defaultValue);
            if (defaultValue != null && !defaultValue.getIsErroneous()) {
                temp2.setLocation(defaultValue.getLocation());
            }
            if (formalParameter2.getIsLazy()) {
                actualLazyParameters.addParameter(temp2);
                continue;
            }
            actualNonLazyParameters.addParameter(temp2);
        }
    }

    public final boolean checkActualParameterList(CompilationTimeStamp timestamp, ParsedActualParameters parsedParameters, ActualParameterList actualParameters) {
        parsedParameters.setFormalParList(this);
        this.checkUniqueness(timestamp);
        boolean isErroneous = false;
        TemplateInstances unnamed = parsedParameters.getInstances();
        NamedParameters named = parsedParameters.getNamedParameters();
        int nofLocated = unnamed.getNofTis();
        HashMap<FormalParameter, Integer> formalParameterMap = new HashMap<FormalParameter, Integer>();
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            formalParameterMap.put(this.parameters.get(i), i);
        }
        TemplateInstances finalUnnamed = new TemplateInstances(unnamed);
        int size2 = named.getNofParams();
        for (int i = 0; i < size2; ++i) {
            String name;
            NamedParameter namedParameter = named.getParamByIndex(i);
            if (this.parameterMap != null && this.parameterMap.containsKey(namedParameter.getName().getName())) {
                FormalParameter formalParameter = this.parameterMap.get(namedParameter.getName().getName());
                int isAt = (Integer)formalParameterMap.get(formalParameter);
                if (isAt >= nofLocated) {
                    while (nofLocated < isAt) {
                        NotUsed_Template temp = new NotUsed_Template();
                        if (!this.parameters.get(nofLocated).hasDefaultValue()) {
                            temp.setIsErroneous(true);
                        }
                        TemplateInstance instance = new TemplateInstance(null, null, temp);
                        instance.setLocation(parsedParameters.getLocation());
                        finalUnnamed.addTemplateInstance(instance);
                        ++nofLocated;
                    }
                    finalUnnamed.addTemplateInstance(namedParameter.getInstance());
                    ++nofLocated;
                    continue;
                }
                isErroneous = true;
                if (isAt >= unnamed.getNofTis()) {
                    namedParameter.getLocation().reportSemanticError(MessageFormat.format("Named parameter `{0}'' is out of order", namedParameter.getName().getDisplayName()));
                    continue;
                }
                namedParameter.getLocation().reportSemanticError(MessageFormat.format("Named parameter `{0}'' is assigned more than once", namedParameter.getName().getDisplayName()));
                continue;
            }
            block0 : switch (this.myDefinition.getAssignmentType()) {
                case A_TYPE: {
                    switch (((Def_Type)this.myDefinition).getType(timestamp).getTypetype()) {
                        case TYPE_FUNCTION: {
                            name = "Function reference";
                            break block0;
                        }
                        case TYPE_ALTSTEP: {
                            name = "Altstep reference";
                            break block0;
                        }
                        case TYPE_TESTCASE: {
                            name = "Testcase reference";
                            break block0;
                        }
                    }
                    name = "";
                    break;
                }
                default: {
                    name = this.myDefinition.getAssignmentName();
                }
            }
            isErroneous = true;
            namedParameter.getLocation().reportSemanticError(MessageFormat.format("{0} `{1}'' has no formal parameter with name `{2}''", name, this.myDefinition.getFullName(), namedParameter.getName().getDisplayName()));
        }
        if (isErroneous) {
            return false;
        }
        finalUnnamed.setLocation(parsedParameters.getLocation());
        return this.checkActualParameterList(timestamp, finalUnnamed, actualParameters);
    }

    private boolean checkActualParameterList(CompilationTimeStamp timestamp, TemplateInstances instances, ActualParameterList actualParameters) {
        ActualParameter temp;
        int i;
        boolean isErroneous = false;
        if (this.minimumNofParameters == this.parameters.size()) {
            if (instances.getNofTis() != this.parameters.size()) {
                instances.getLocation().reportSemanticError(MessageFormat.format("Too {0} parameters: {1} was expected instead of {2}", instances.getNofTis() < this.parameters.size() ? "few" : "many", this.parameters.size(), instances.getNofTis()));
                isErroneous = true;
            }
        } else if (instances.getNofTis() < this.minimumNofParameters) {
            instances.getLocation().reportSemanticError(MessageFormat.format("Too few parameters: at least {0} was expected instaed of {1}", this.minimumNofParameters, instances.getNofTis()));
            isErroneous = true;
        } else if (instances.getNofTis() > this.parameters.size()) {
            instances.getLocation().reportSemanticError(MessageFormat.format("Too many parameters: at most {0} was expected instead of {1}", this.parameters.size(), instances.getNofTis()));
            isErroneous = true;
        }
        int upperLimit = instances.getNofTis() < this.parameters.size() ? instances.getNofTis() : this.parameters.size();
        for (i = 0; i < upperLimit; ++i) {
            TemplateInstance instance = instances.getInstanceByIndex(i);
            FormalParameter formalParameter = this.parameters.get(i);
            if (instance.getType() == null && instance.getDerivedReference() == null && ITTCN3Template.Template_type.TEMPLATE_NOTUSED.equals((Object)instance.getTemplateBody().getTemplatetype())) {
                if (formalParameter.hasDefaultValue()) {
                    ActualParameter defaultValue = formalParameter.getDefaultValue();
                    Default_ActualParameter temp2 = new Default_ActualParameter(defaultValue);
                    actualParameters.addParameter(temp2);
                    if (defaultValue == null || defaultValue.getIsErroneous()) {
                        isErroneous = true;
                        continue;
                    }
                    temp2.setLocation(defaultValue.getLocation());
                    continue;
                }
                if (instance.getTemplateBody().getIsErroneous(timestamp)) {
                    instances.getLocation().reportSemanticError(MessageFormat.format(MISSINGPARAMETER, formalParameter.getIdentifier().getDisplayName()));
                    isErroneous = true;
                    continue;
                }
                instance.getLocation().reportSemanticError("Not used symbol (`-'') cannot be used for parameter that does not have a default value");
                temp = new Value_ActualParameter(null);
                temp.setLocation(instances.getLocation());
                temp.setIsErroneous();
                actualParameters.addParameter(temp);
                isErroneous = true;
                continue;
            }
            ActualParameter actualParameter = formalParameter.checkActualParameter(timestamp, instance, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            actualParameter.setLocation(instance.getLocation());
            actualParameters.addParameter(actualParameter);
            if (!actualParameter.getIsErroneous()) continue;
            isErroneous = true;
        }
        for (i = upperLimit; i < this.parameters.size(); ++i) {
            FormalParameter formalParameter = this.parameters.get(i);
            if (formalParameter.hasDefaultValue()) {
                ActualParameter defaultValue = formalParameter.getDefaultValue();
                temp = new Default_ActualParameter(defaultValue);
                actualParameters.addParameter(temp);
                if (defaultValue == null || defaultValue.getIsErroneous()) {
                    isErroneous = true;
                    continue;
                }
                temp.setLocation(defaultValue.getLocation());
                continue;
            }
            Value_ActualParameter temp3 = new Value_ActualParameter(null);
            temp3.setLocation(instances.getLocation());
            temp3.setIsErroneous();
            actualParameters.addParameter(temp3);
            isErroneous = true;
        }
        return isErroneous;
    }

    public final boolean checkActivateArgument(CompilationTimeStamp timestamp, ActualParameterList actualParameters, String description) {
        if (actualParameters == null) {
            return false;
        }
        boolean returnValue = true;
        block8: for (int i = 0; i < actualParameters.getNofParameters(); ++i) {
            ActualParameter actualParameter = actualParameters.getParameter(i);
            if (!(actualParameter instanceof Referenced_ActualParameter)) continue;
            FormalParameter formalParameter = this.parameters.get(i);
            switch (formalParameter.getAssignmentType()) {
                case A_PAR_VAL_INOUT: 
                case A_PAR_TEMP_INOUT: 
                case A_PAR_VAL_OUT: 
                case A_PAR_TEMP_OUT: 
                case A_PAR_TIMER: {
                    break;
                }
                case A_PAR_PORT: {
                    continue block8;
                }
                default: {
                    return false;
                }
            }
            Reference reference = ((Referenced_ActualParameter)actualParameter).getReference();
            Assignment assignment = reference.getRefdAssignment(timestamp, true);
            if (assignment == null) {
                return false;
            }
            switch (assignment.getAssignmentType()) {
                case A_VAR: 
                case A_VAR_TEMPLATE: 
                case A_TIMER: {
                    if (!assignment.isLocal()) continue block8;
                    reference.getLocation().reportSemanticError(MessageFormat.format(ILLEGALACTIVATEPARAMETER, i + 1, description, assignment.getDescription()));
                    returnValue = false;
                    continue block8;
                }
                case A_PAR_VAL: 
                case A_PAR_VAL_IN: 
                case A_PAR_TEMP_IN: 
                case A_PAR_VAL_INOUT: 
                case A_PAR_TEMP_INOUT: 
                case A_PAR_VAL_OUT: 
                case A_PAR_TEMP_OUT: 
                case A_PAR_TIMER: {
                    Definition definition;
                    FormalParameter referencedFormalParameter = (FormalParameter)assignment;
                    FormalParameterList formalParameterList = referencedFormalParameter.getMyParameterList();
                    if (formalParameterList == null || (definition = formalParameterList.getMyDefinition()) == null || Assignment.Assignment_type.A_TESTCASE.equals(definition.getAssignmentType())) continue block8;
                    reference.getLocation().reportSemanticError(MessageFormat.format(ILLEGALACTIVATEPARAMETER, i + 1, description, assignment.getDescription()));
                    returnValue = false;
                    continue block8;
                }
            }
        }
        return returnValue;
    }

    public void checkStartability(CompilationTimeStamp timestamp, String what, INamedNode namedNode, Location errorLocation) {
        if (this.isStartable) {
            return;
        }
        block3: for (int i = 0; i < this.parameters.size(); ++i) {
            FormalParameter parameter = this.parameters.get(i);
            switch (parameter.getAssignmentType()) {
                case A_PAR_VAL: 
                case A_PAR_VAL_IN: 
                case A_PAR_TEMP_IN: 
                case A_PAR_VAL_INOUT: 
                case A_PAR_TEMP_INOUT: {
                    Type tempType = parameter.getType(timestamp);
                    if (tempType == null || !tempType.isComponentInternal(timestamp)) continue block3;
                    HashSet<IType> typeSet = new HashSet<IType>();
                    String errorString = MessageFormat.format(CANNOTBESTARTED, what, namedNode.getFullName(), parameter.getDescription());
                    tempType.checkComponentInternal(timestamp, typeSet, errorString);
                    continue block3;
                }
                default: {
                    errorLocation.reportSemanticError(MessageFormat.format("{0} `{1}'' cannot be started on a parallel test component because it has {2}", what, namedNode.getFullName(), parameter.getDescription()));
                }
            }
        }
    }

    public void checkCompatibility(CompilationTimeStamp timestamp, FormalParameterList fpList, Location callSite) {
        if (this.parameters.size() != fpList.parameters.size()) {
            callSite.reportSemanticError(MessageFormat.format("{0} formal parameters was expected instead of {1}", this.parameters.size(), fpList.parameters.size()));
        }
        int upperLimit = Math.min(this.parameters.size(), fpList.parameters.size());
        for (int i = 0; i < upperLimit; ++i) {
            Type functionParameterType;
            Type typeParameterType;
            FormalParameter typeParameter = this.parameters.get(i);
            FormalParameter functionParameter = fpList.getParameterByIndex(i);
            if (typeParameter.getIsErroneous() || functionParameter.getIsErroneous()) continue;
            if (!typeParameter.getAssignmentType().equals(functionParameter.getAssignmentType())) {
                callSite.reportSemanticError(MessageFormat.format("The kind of the {0}th parameter is not the same: {1} was expected instead of {2}", i, typeParameter.getAssignmentName(), functionParameter.getAssignmentName()));
            }
            if (typeParameter.getAssignmentType() != Assignment.Assignment_type.A_TIMER && functionParameter.getAssignmentType() != Assignment.Assignment_type.A_TIMER && !(typeParameterType = typeParameter.getType(timestamp)).isIdentical(timestamp, functionParameterType = functionParameter.getType(timestamp))) {
                callSite.reportSemanticError(MessageFormat.format("The type of the {0}th parameter is not the same: `{1}'' was expected instead of `{2}''", i, typeParameterType.getTypename(), functionParameterType.getTypename()));
            }
            if (typeParameter.getTemplateRestriction() != functionParameter.getTemplateRestriction()) {
                callSite.reportSemanticError(MessageFormat.format("The template restriction of the {0}th parameter is not the same: `{1}'' was expected instead of `{2}''", i, typeParameter.getTemplateRestriction().getDisplayName(), functionParameter.getTemplateRestriction().getDisplayName()));
            }
            if (typeParameter.getIsLazy() != functionParameter.getIsLazy()) {
                callSite.reportSemanticError(MessageFormat.format("{0}th parameter @lazy-ness mismatch", i));
            }
            if (typeParameter.getIdentifier().equals(functionParameter.getIdentifier())) continue;
            callSite.reportSemanticWarning(MessageFormat.format("The name of the {0}th parameter is not the same: `{1}'' was expected instead of `{2}''", i, typeParameter.getIdentifier().getDisplayName(), functionParameter.getIdentifier().getDisplayName()));
        }
    }

    @Override
    public final boolean hasAssignmentWithId(CompilationTimeStamp timestamp, Identifier identifier) {
        if (this.parameterMap != null && this.parameterMap.containsKey(identifier.getName())) {
            return true;
        }
        if (this.parentScope != null) {
            return this.parentScope.hasAssignmentWithId(timestamp, identifier);
        }
        return false;
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.getAssBySRef(timestamp, reference, null);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        if (reference.getModuleIdentifier() != null || this.parameterMap == null) {
            return this.getParentScope().getAssBySRef(timestamp, reference);
        }
        Identifier identifier = reference.getId();
        if (identifier == null) {
            return this.getParentScope().getAssBySRef(timestamp, reference);
        }
        Assignment assignment = this.parameterMap.get(identifier.getName());
        if (assignment != null) {
            return assignment;
        }
        return this.getParentScope().getAssBySRef(timestamp, reference);
    }

    public final StringBuilder getAsProposalDesriptionPart(StringBuilder builder) {
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            this.parameters.get(i).getAsProposalDesriptionPart(builder);
        }
        return builder;
    }

    public final StringBuilder getAsProposalPart(StringBuilder builder) {
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            this.parameters.get(i).getAsProposalPart(builder);
        }
        return builder;
    }

    @Override
    public final void addProposal(ProposalCollector propCollector) {
        if (propCollector.getReference().getModuleIdentifier() == null) {
            for (FormalParameter parameter : this.parameters) {
                parameter.addProposal(propCollector, 0);
            }
        }
        super.addProposal(propCollector);
    }

    @Override
    public void addSkeletonProposal(ProposalCollector propCollector) {
        for (SkeletonTemplateProposal templateProposal : TTCN3CodeSkeletons.FORMAL_VALUE_PARAMETER_PROPOSALS) {
            propCollector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
        for (SkeletonTemplateProposal templateProposal : TTCN3CodeSkeletons.FORMAL_TEMPLATE_PARAMETER_PROPOSALS) {
            propCollector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
        for (SkeletonTemplateProposal templateProposal : TTCN3CodeSkeletons.FORMAL_TIMER_PARAMETER_PROPOSALS) {
            propCollector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
    }

    @Override
    public final void addKeywordProposal(ProposalCollector propCollector) {
        propCollector.addProposal(TTCN3Keywords.FORMAL_PARAMETER_SCOPE, null, "keyword");
        super.addKeywordProposal(propCollector);
    }

    @Override
    public final void addDeclaration(DeclarationCollector declarationCollector) {
        if (declarationCollector.getReference().getModuleIdentifier() == null) {
            Identifier identifier = declarationCollector.getReference().getId();
            if (this.parameterMap != null && this.parameterMap.containsKey(identifier.getName())) {
                this.parameterMap.get(identifier.getName()).addDeclaration(declarationCollector, 0);
            }
        }
        super.addDeclaration(declarationCollector);
    }

    @Override
    public final void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            FormalParameter parameter = this.parameters.get(i);
            parameter.updateSyntax(reparser, isDamaged);
            reparser.updateLocation(parameter.getLocation());
        }
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        if (this.parameters == null) {
            return null;
        }
        for (FormalParameter parameter : this.parameters) {
            if (!parameter.getLocation().containsOffset(offset)) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.parameters != null) {
            for (FormalParameter formalPar : this.parameters) {
                formalPar.findReferences(referenceFinder, foundIdentifiers);
            }
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.parameters != null) {
            for (FormalParameter formalPar : this.parameters) {
                if (formalPar.accept(v)) continue;
                return false;
            }
        }
        return v.leave(this) != 2;
    }

    static {
        final IPreferencesService ps = Platform.getPreferencesService();
        if (ps != null) {
            reportTooManyParameters = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTooManyParameters", "warning", null);
            reportTooManyParametersSize = ps.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTooManyParametersSize", 7, null);
            Activator activator = Activator.getDefault();
            if (activator != null) {
                activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        String property = event.getProperty();
                        if ("org.eclipse.titan.designer.reportTooManyParameters".equals(property)) {
                            reportTooManyParameters = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTooManyParameters", "warning", null);
                        }
                        if ("org.eclipse.titan.designer.reportTooManyParametersSize".equals(property)) {
                            reportTooManyParametersSize = ps.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTooManyParametersSize", 7, null);
                        }
                    }
                });
            }
        }
    }
}

