/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ExternalConst;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ValueList_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.TemporalReference;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReparseUtilities;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Assignment_Statement
extends Statement {
    private static final String FULLNAMEPART = ".assignment";
    private static final String TEMPLATEASSIGNMENTTOVALUE = "A template body with matching symbols cannot be assigned to a variable";
    private static final String VARIABLEREFERENCEEXPECTED = "Reference to a variable or template variable was expected instead of `{0}''";
    private static final String OMITTOMANDATORYASSIGNMENT1 = "Omit value can only be assigned to an optional field of a record or set value";
    private static final String OMITTOMANDATORYASSIGNMENT2 = "Assignment of `omit'' to mandatory field `{0}'' of type `{1}''";
    private static final String STATEMENT_NAME = "assignment";
    private final Reference reference;
    private final TTCN3Template template;

    public Assignment_Statement(Reference reference, TTCN3Template template) {
        this.reference = reference;
        this.template = template;
        if (reference != null) {
            reference.setFullNameParent(this);
        }
        if (template != null) {
            template.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_ASSIGNMENT;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.reference == child) {
            return builder.append(FULLNAMEPART);
        }
        if (this.template == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
        if (this.template != null) {
            this.template.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isErroneous = false;
        if (this.reference == null) {
            return;
        }
        this.reference.setUsedOnLeftHandSide();
        Assignment assignment = this.reference.getRefdAssignment(timestamp, true);
        if (assignment == null || assignment.getIsErroneous()) {
            this.isErroneous = true;
            return;
        }
        if (this.template == null) {
            return;
        }
        switch (assignment.getAssignmentType()) {
            case A_PAR_VAL_IN: {
                ((FormalParameter)assignment).useAsLValue(this.reference);
                if (this.template.isValue(timestamp)) {
                    IValue temporalValue = this.template.getValue();
                    this.checkVarAssignment(timestamp, assignment, temporalValue);
                    break;
                }
                this.template.getLocation().reportSemanticError(TEMPLATEASSIGNMENTTOVALUE);
                this.template.setIsErroneous(true);
                break;
            }
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: 
            case A_PAR_VAL: {
                ((FormalParameter)assignment).setWritten();
                if (this.template.isValue(timestamp)) {
                    IValue temporalValue = this.template.getValue();
                    this.checkVarAssignment(timestamp, assignment, temporalValue);
                    break;
                }
                if (ITTCN3Template.Template_type.VALUE_LIST.equals((Object)this.template.getTemplatetype()) && ((ValueList_Template)this.template).getNofTemplates() == 1) break;
                this.template.getLocation().reportSemanticError(TEMPLATEASSIGNMENTTOVALUE);
                this.template.setIsErroneous(true);
                return;
            }
            case A_VAR: {
                ((Def_Var)assignment).setWritten();
                if (this.template.isValue(timestamp)) {
                    IValue temporalValue = this.template.getValue();
                    this.checkVarAssignment(timestamp, assignment, temporalValue);
                    break;
                }
                if (ITTCN3Template.Template_type.VALUE_LIST.equals((Object)this.template.getTemplatetype()) && ((ValueList_Template)this.template).getNofTemplates() == 1) break;
                this.template.getLocation().reportSemanticError(TEMPLATEASSIGNMENTTOVALUE);
                this.template.setIsErroneous(true);
                return;
            }
            case A_PAR_TEMP_IN: {
                ((FormalParameter)assignment).useAsLValue(this.reference);
                this.checkTemplateAssignment(timestamp, assignment);
                break;
            }
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                ((FormalParameter)assignment).setWritten();
                this.checkTemplateAssignment(timestamp, assignment);
                break;
            }
            case A_VAR_TEMPLATE: {
                ((Def_Var_Template)assignment).setWritten();
                this.checkTemplateAssignment(timestamp, assignment);
                break;
            }
            default: {
                this.reference.getLocation().reportSemanticError(MessageFormat.format(VARIABLEREFERENCEEXPECTED, assignment.getAssignmentName()));
                this.reference.setIsErroneous(true);
                this.isErroneous = true;
            }
        }
    }

    private void checkVarAssignment(CompilationTimeStamp timestamp, Assignment assignment, IValue value) {
        block31: {
            IValue lastValue;
            IType type;
            block30: {
                IType varType = this.getType(timestamp, assignment);
                if (varType == null || value == null) {
                    this.isErroneous = true;
                    return;
                }
                type = varType.getFieldType(timestamp, this.reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                if (type == null) {
                    this.isErroneous = true;
                    return;
                }
                value.setMyGovernor(type);
                lastValue = type.checkThisValueRef(timestamp, value);
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                lastValue = lastValue.getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                if (!IValue.Value_type.OMIT_VALUE.equals((Object)lastValue.getValuetype())) break block30;
                ISubReference lastReference = this.reference.removeLastSubReference();
                if (lastReference == null || lastReference.getId() == null) {
                    value.getLocation().reportSemanticError(OMITTOMANDATORYASSIGNMENT1);
                    this.isErroneous = true;
                    this.reference.addSubReference(lastReference);
                    return;
                }
                Identifier lastField = lastReference.getId();
                List<ISubReference> baseReference = this.reference.getSubreferences(0, this.reference.getSubreferences().size() - 1);
                this.reference.addSubReference(lastReference);
                TemporalReference newReference = new TemporalReference(null, baseReference);
                newReference.clearStringElementReferencing();
                IType baseType = varType.getFieldType(timestamp, newReference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                if (baseType == null) {
                    this.isErroneous = true;
                    return;
                }
                if ((baseType = baseType.getTypeRefdLast(timestamp)).getIsErroneous(timestamp)) {
                    this.isErroneous = true;
                    return;
                }
                switch (baseType.getTypetype()) {
                    case TYPE_TTCN3_SEQUENCE: {
                        CompField componentField = ((TTCN3_Sequence_Type)baseType).getComponentByName(lastField.getName());
                        if (componentField != null && !componentField.isOptional()) {
                            value.getLocation().reportSemanticError(MessageFormat.format(OMITTOMANDATORYASSIGNMENT2, lastField.getDisplayName(), baseType.getTypename()));
                            value.setIsErroneous(true);
                            break;
                        }
                        break block31;
                    }
                    case TYPE_ASN1_SEQUENCE: {
                        CompField componentField = ((ASN1_Sequence_Type)baseType).getComponentByName(lastField);
                        if (componentField != null && !componentField.isOptional()) {
                            value.getLocation().reportSemanticError(MessageFormat.format(OMITTOMANDATORYASSIGNMENT2, lastField.getDisplayName(), baseType.getTypename()));
                            value.setIsErroneous(true);
                            break;
                        }
                        break block31;
                    }
                    case TYPE_TTCN3_SET: {
                        CompField componentField = ((TTCN3_Set_Type)baseType).getComponentByName(lastField.getName());
                        if (componentField != null && !componentField.isOptional()) {
                            value.getLocation().reportSemanticError(MessageFormat.format(OMITTOMANDATORYASSIGNMENT2, lastField.getDisplayName(), baseType.getTypename()));
                            value.setIsErroneous(true);
                            break;
                        }
                        break block31;
                    }
                    case TYPE_ASN1_SET: {
                        CompField componentField = ((ASN1_Set_Type)baseType).getComponentByName(lastField);
                        if (componentField != null && !componentField.isOptional()) {
                            value.getLocation().reportSemanticError(MessageFormat.format(OMITTOMANDATORYASSIGNMENT2, lastField.getDisplayName(), baseType.getTypename()));
                            value.setIsErroneous(true);
                            break;
                        }
                        break block31;
                    }
                    default: {
                        value.getLocation().reportSemanticError(OMITTOMANDATORYASSIGNMENT1);
                        value.setIsErroneous(true);
                        this.isErroneous = true;
                        break;
                    }
                }
                break block31;
            }
            boolean isStringElement = this.reference.refersToStringElement();
            type.checkThisValue(timestamp, value, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, true, false, !isStringElement, false, isStringElement));
            if (isStringElement) {
                IType lastType = type.getTypeRefdLast(timestamp);
                int stringLength = 1;
                switch (lastType.getTypetype()) {
                    case TYPE_BITSTRING: 
                    case TYPE_BITSTRING_A: {
                        if (!IValue.Value_type.BITSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                            return;
                        }
                        stringLength = ((Bitstring_Value)lastValue).getValueLength();
                        break;
                    }
                    case TYPE_HEXSTRING: {
                        if (!IValue.Value_type.HEXSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                            lastValue = null;
                            break;
                        }
                        stringLength = ((Hexstring_Value)lastValue).getValueLength();
                        break;
                    }
                    case TYPE_OCTETSTRING: {
                        if (!IValue.Value_type.OCTETSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                            return;
                        }
                        stringLength = ((Octetstring_Value)lastValue).getValueLength();
                        break;
                    }
                    case TYPE_CHARSTRING: 
                    case TYPE_NUMERICSTRING: 
                    case TYPE_PRINTABLESTRING: 
                    case TYPE_IA5STRING: 
                    case TYPE_VISIBLESTRING: 
                    case TYPE_UTCTIME: 
                    case TYPE_GENERALIZEDTIME: {
                        if (!IValue.Value_type.CHARSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                            return;
                        }
                        stringLength = ((Charstring_Value)lastValue).getValueLength();
                        break;
                    }
                    case TYPE_UCHARSTRING: 
                    case TYPE_UTF8STRING: 
                    case TYPE_TELETEXSTRING: 
                    case TYPE_VIDEOTEXSTRING: 
                    case TYPE_GRAPHICSTRING: 
                    case TYPE_GENERALSTRING: 
                    case TYPE_UNIVERSALSTRING: 
                    case TYPE_BMPSTRING: 
                    case TYPE_OBJECTDESCRIPTOR: {
                        if (IValue.Value_type.UNIVERSALCHARSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                            stringLength = ((UniversalCharstring_Value)lastValue).getValueLength();
                            break;
                        }
                        if (IValue.Value_type.CHARSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                            stringLength = ((Charstring_Value)lastValue).getValueLength();
                            break;
                        }
                        return;
                    }
                    default: {
                        lastValue = null;
                        return;
                    }
                }
                if (stringLength != 1) {
                    String message = MessageFormat.format("The length of the string to be assigned to a string element of type `{0}'' should be 1 instead of {1}", type.getTypename(), stringLength);
                    value.getLocation().reportSemanticError(message);
                    value.setIsErroneous(true);
                }
            }
        }
    }

    private void checkTemplateAssignment(CompilationTimeStamp timestamp, Assignment assignment) {
        IType type = this.getType(timestamp, assignment);
        if (type == null) {
            this.isErroneous = true;
            return;
        }
        if ((type = type.getFieldType(timestamp, this.reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false)) == null) {
            this.isErroneous = true;
            return;
        }
        this.template.setMyGovernor(type);
        ITTCN3Template temporalTemplate = type.checkThisTemplateRef(timestamp, this.template);
        temporalTemplate.checkThisTemplateGeneric(timestamp, type, false, true, true, true, false);
        Assignment ass = this.reference.getRefdAssignment(timestamp, true);
        if (ass != null && ass instanceof Definition) {
            TemplateRestriction.check(timestamp, (Definition)ass, this.template, this.reference);
        }
        if (this.reference.refersToStringElement() && !this.template.isValue(timestamp)) {
            this.template.getLocation().reportSemanticError(TEMPLATEASSIGNMENTTOVALUE);
            this.template.setIsErroneous(true);
            return;
        }
    }

    private IType getType(CompilationTimeStamp timestamp, Assignment assignment) {
        switch (assignment.getAssignmentType()) {
            case A_CONST: {
                return ((Def_Const)assignment).getType(timestamp);
            }
            case A_EXT_CONST: {
                return ((Def_ExternalConst)assignment).getType(timestamp);
            }
            case A_VAR: {
                return ((Def_Var)assignment).getType(timestamp);
            }
            case A_VAR_TEMPLATE: {
                return ((Def_Var_Template)assignment).getType(timestamp);
            }
            case A_TEMPLATE: {
                return ((Def_Template)assignment).getType(timestamp);
            }
            case A_MODULEPAR: {
                return ((Def_ModulePar)assignment).getType(timestamp);
            }
            case A_MODULEPAR_TEMPLATE: {
                return ((Def_ModulePar_Template)assignment).getType(timestamp);
            }
            case A_EXT_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RTEMP: {
                return ((Def_ExternalConst)assignment).getType(timestamp);
            }
            case A_FUNCTION_RVAL: 
            case A_FUNCTION_RTEMP: {
                return ((Def_Function)assignment).getType(timestamp);
            }
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: 
            case A_PAR_VAL: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: 
            case A_PAR_PORT: 
            case A_PAR_TIMER: {
                return ((FormalParameter)assignment).getType(timestamp);
            }
        }
        return null;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        return ReparseUtilities.getAllValidTokenTypes();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.reference != null) {
            this.reference.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference.getLocation());
        }
        if (this.template != null) {
            this.template.updateSyntax(reparser, false);
            reparser.updateLocation(this.template.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.reference != null) {
            this.reference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.template != null) {
            this.template.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.reference != null && !this.reference.accept(v)) {
            return false;
        }
        return this.template == null || this.template.accept(v);
    }

    public Reference getReference() {
        return this.reference;
    }

    public TTCN3Template getTemplate() {
        return this.template;
    }
}

