/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITemplateListItem;
import org.eclipse.titan.designer.AST.TTCN3.templates.IndexedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.IndexedTemplates;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.IndexedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Values;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Indexed_Template_List
extends TTCN3Template {
    private final IndexedTemplates indexedTemplates;
    private boolean hasPermutation = false;
    private SequenceOf_Value asValue = null;

    public Indexed_Template_List(IndexedTemplates indexedTemplates) {
        this.indexedTemplates = indexedTemplates;
        indexedTemplates.setFullNameParent(this);
        int size = indexedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (!ITTCN3Template.Template_type.PERMUTATION_MATCH.equals((Object)indexedTemplates.getTemplateByIndex(i).getTemplate().getTemplatetype())) continue;
            this.hasPermutation = true;
            break;
        }
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.INDEXED_TEMPLATE_LIST;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous indexed assignment notation";
        }
        return "indexed assignment notation";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        int size = this.indexedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            IndexedTemplate indexedTemplate = this.indexedTemplates.getTemplateByIndex(i);
            builder.append(" [").append(indexedTemplate.getIndex().getValue().createStringRepresentation());
            builder.append("] := ");
            builder.append(indexedTemplate.getTemplate().createStringRepresentation());
        }
        builder.append(" }");
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.indexedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            IndexedTemplate template = this.indexedTemplates.getTemplateByIndex(i);
            if (template != child) continue;
            Value index = template.getIndex().getValue();
            return builder.append("[").append(index.createStringRepresentation()).append("]");
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.indexedTemplates != null) {
            this.indexedTemplates.setMyScope(scope);
        }
    }

    public int getNofTemplates() {
        if (this.indexedTemplates == null) {
            return 0;
        }
        return this.indexedTemplates.getNofTemplates();
    }

    public IndexedTemplate getIndexedTemplateByIndex(int index) {
        return this.indexedTemplates.getTemplateByIndex(index);
    }

    @Override
    protected ITTCN3Template getReferencedArrayTemplate(CompilationTimeStamp timestamp, IValue arrayIndex, IReferenceChain referenceChain) {
        IValue indexValue = arrayIndex.setLoweridToReference(timestamp);
        if ((indexValue = indexValue.getValueRefdLast(timestamp, referenceChain)).getIsErroneous(timestamp)) {
            return null;
        }
        long index = 0L;
        if (!indexValue.isUnfoldable(timestamp)) {
            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)indexValue.getValuetype())) {
                arrayIndex.getLocation().reportSemanticError("An integer value was expected as index");
                return null;
            }
        } else {
            return null;
        }
        index = ((Integer_Value)indexValue).getValue();
        IType tempType = this.myGovernor.getTypeRefdLast(timestamp);
        if (tempType.getIsErroneous(timestamp)) {
            return null;
        }
        switch (tempType.getTypetype()) {
            case TYPE_SEQUENCE_OF: {
                if (index >= 0L) break;
                String message = MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a template of `sequence of'' type `{1}''", index, tempType.getTypename());
                arrayIndex.getLocation().reportSemanticError(message);
                return null;
            }
            case TYPE_SET_OF: {
                if (index >= 0L) break;
                String message = MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a template of `set of'' type `{1}''", index, tempType.getTypename());
                arrayIndex.getLocation().reportSemanticError(message);
                return null;
            }
            case TYPE_ARRAY: {
                ArrayDimension dimension = ((Array_Type)tempType).getDimension();
                dimension.checkIndex(timestamp, indexValue, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                if (!dimension.getIsErroneous(timestamp)) {
                    if ((index -= dimension.getOffset()) >= 0L && index <= (long)this.getNofTemplates()) break;
                    arrayIndex.getLocation().reportSemanticError(MessageFormat.format("The index value {0} is outside the array indexable range", index + dimension.getOffset()));
                    return null;
                }
                return null;
            }
            default: {
                arrayIndex.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' cannot be indexed", tempType.getTypename()));
                return null;
            }
        }
        int size = this.indexedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            long tempIndex;
            IndexedTemplate template = this.indexedTemplates.getTemplateByIndex(i);
            IValue lastValue = template.getIndex().getValue();
            ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            lastValue = lastValue.getValueRefdLast(timestamp, chain);
            chain.release();
            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)lastValue.getValuetype()) || index != (tempIndex = ((Integer_Value)lastValue).getValue())) continue;
            ITemplateListItem realTemplate = template.getTemplate();
            if (ITTCN3Template.Template_type.TEMPLATE_NOTUSED.equals((Object)realTemplate.getTemplatetype())) {
                if (this.baseTemplate != null) {
                    return this.baseTemplate.getTemplateReferencedLast(timestamp, referenceChain).getReferencedArrayTemplate(timestamp, indexValue, referenceChain);
                }
                return null;
            }
            return realTemplate;
        }
        switch (tempType.getTypetype()) {
            case TYPE_SEQUENCE_OF: 
            case TYPE_SET_OF: 
            case TYPE_ARRAY: {
                arrayIndex.getLocation().reportSemanticError(MessageFormat.format("No elements were found with the index {0} in the referenced template", index));
                break;
            }
        }
        return null;
    }

    @Override
    public boolean isValue(CompilationTimeStamp timestamp) {
        if (this.lengthRestriction != null || this.isIfpresent || this.getIsErroneous(timestamp)) {
            return false;
        }
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (this.indexedTemplates.getTemplateByIndex(i).getTemplate().isValue(timestamp)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IValue getValue() {
        if (this.asValue != null) {
            return this.asValue;
        }
        Values values = new Values(true);
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            IndexedTemplate indexedTemplate = this.indexedTemplates.getTemplateByIndex(i);
            IndexedValue indexedValue = new IndexedValue(indexedTemplate.getIndex(), indexedTemplate.getTemplate().getValue());
            indexedValue.setLocation(indexedTemplate.getLocation());
            values.addIndexedValue(indexedValue);
        }
        this.asValue = new SequenceOf_Value(values);
        this.asValue.setLocation(this.getLocation());
        this.asValue.setMyScope(this.getMyScope());
        this.asValue.setFullNameParent(this.getNameParent());
        return this.asValue;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            ITemplateListItem temp = this.indexedTemplates.getTemplateByIndex(i).getTemplate();
            if (temp == null) continue;
            temp.checkSpecificValue(timestamp, true);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            int size = this.indexedTemplates.getNofTemplates();
            for (int i = 0; i < size; ++i) {
                IndexedTemplate template = this.indexedTemplates.getTemplateByIndex(i);
                if (template == null) continue;
                referenceChain.markState();
                template.getTemplate().checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public boolean checkValueomitRestriction(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Location usageLocation) {
        if (omitAllowed) {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_OMIT, usageLocation);
        } else {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_VALUE, usageLocation);
        }
        int size = this.indexedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            this.indexedTemplates.getTemplateByIndex(i).getTemplate().checkValueomitRestriction(timestamp, definitionName, true, usageLocation);
        }
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        this.indexedTemplates.updateSyntax(reparser, false);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.asValue != null) {
            this.asValue.findReferences(referenceFinder, foundIdentifiers);
        } else if (this.indexedTemplates != null) {
            this.indexedTemplates.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return !(this.asValue != null ? !this.asValue.accept(v) : this.indexedTemplates != null && !this.indexedTemplates.accept(v));
    }
}

