/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITemplateListItem;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplates;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValues;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Named_Template_List
extends TTCN3Template {
    private static final String ALLARENOTUSED = "All elements of value list notation for type `{0}'' are not used symbols (`-'')";
    private static final String TOOMANYELEMENTS = "Too many elements in value list notation for type `{0}'': {1} was expected instead of {2}";
    private final NamedTemplates namedTemplates;
    private Sequence_Value asValue = null;

    public Named_Template_List(NamedTemplates namedTemplates) {
        this.namedTemplates = namedTemplates;
        namedTemplates.setFullNameParent(this);
    }

    public static Named_Template_List convert(CompilationTimeStamp timestamp, Template_List other) {
        boolean allNotUsed;
        int upperLimit;
        IType lastType = other.getMyGovernor().getTypeRefdLast(timestamp);
        int nofTemplates = other.getNofTemplates();
        int nofTypeComponents = 0;
        switch (lastType.getTypetype()) {
            case TYPE_TTCN3_SEQUENCE: {
                nofTypeComponents = ((TTCN3_Sequence_Type)lastType).getNofComponents();
                break;
            }
            case TYPE_ASN1_SEQUENCE: {
                nofTypeComponents = ((ASN1_Sequence_Type)lastType).getNofComponents(timestamp);
                break;
            }
            case TYPE_SIGNATURE: {
                nofTypeComponents = ((Signature_Type)lastType).getNofParameters();
                break;
            }
            case TYPE_TTCN3_SET: {
                nofTypeComponents = ((TTCN3_Set_Type)lastType).getNofComponents();
                break;
            }
            case TYPE_ASN1_SET: {
                nofTypeComponents = ((ASN1_Set_Type)lastType).getNofComponents(timestamp);
                break;
            }
        }
        if (nofTemplates > nofTypeComponents) {
            other.getLocation().reportSemanticError(MessageFormat.format(TOOMANYELEMENTS, lastType.getTypename(), nofTypeComponents, nofTemplates));
            other.setIsErroneous(true);
        }
        if (nofTemplates <= nofTypeComponents) {
            upperLimit = nofTemplates;
            allNotUsed = true;
        } else {
            upperLimit = nofTypeComponents;
            allNotUsed = false;
        }
        NamedTemplates namedTemplates = new NamedTemplates();
        for (int i = 0; i < upperLimit; ++i) {
            ITemplateListItem template = other.getTemplateByIndex(i);
            if (ITTCN3Template.Template_type.TEMPLATE_NOTUSED.equals((Object)template.getTemplatetype())) continue;
            allNotUsed = false;
            Identifier identifier = null;
            switch (lastType.getTypetype()) {
                case TYPE_TTCN3_SEQUENCE: {
                    identifier = ((TTCN3_Sequence_Type)lastType).getComponentIdentifierByIndex(i);
                    break;
                }
                case TYPE_ASN1_SEQUENCE: {
                    identifier = ((ASN1_Sequence_Type)lastType).getComponentIdentifierByIndex(i);
                    break;
                }
                case TYPE_SIGNATURE: {
                    identifier = ((Signature_Type)lastType).getParameterIdentifierByIndex(i);
                    break;
                }
                case TYPE_TTCN3_SET: {
                    identifier = ((TTCN3_Set_Type)lastType).getComponentIdentifierByIndex(i);
                    break;
                }
                case TYPE_ASN1_SET: {
                    identifier = ((ASN1_Set_Type)lastType).getComponentIdentifierByIndex(i);
                    break;
                }
            }
            if (identifier == null) continue;
            NamedTemplate namedTemplate = new NamedTemplate(identifier.newInstance(), template);
            namedTemplate.setLocation(template.getLocation());
            namedTemplates.addTemplate(namedTemplate);
        }
        namedTemplates.setMyScope(other.getMyScope());
        namedTemplates.setFullNameParent(other);
        if (allNotUsed && nofTemplates > 0 && !IType.Type_type.TYPE_SIGNATURE.equals((Object)lastType.getTypetype())) {
            other.getLocation().reportSemanticWarning(MessageFormat.format(ALLARENOTUSED, lastType.getTypename()));
            other.setIsErroneous(true);
        }
        Named_Template_List target = new Named_Template_List(namedTemplates);
        target.copyGeneralProperties(other);
        return target;
    }

    public void addNamedValue(NamedTemplate template) {
        if (template != null) {
            this.namedTemplates.addTemplate(template);
            template.setMyScope(this.myScope);
        }
    }

    public boolean hasNamedTemplate(Identifier name) {
        if (name == null || this.namedTemplates == null) {
            return false;
        }
        return this.namedTemplates.hasNamedTemplateWithName(name);
    }

    public NamedTemplate getNamedTemplate(Identifier name) {
        if (name == null || this.namedTemplates == null) {
            return null;
        }
        return this.namedTemplates.getNamedTemplateByName(name);
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous assignment notation";
        }
        return "assignment notation";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        int size = this.namedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            NamedTemplate namedTemplate = this.namedTemplates.getTemplateByIndex(i);
            builder.append(namedTemplate.getName().getDisplayName());
            builder.append(" := ");
            builder.append(namedTemplate.getTemplate().createStringRepresentation());
        }
        builder.append(" }");
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.namedTemplates != null) {
            this.namedTemplates.setMyScope(scope);
        }
    }

    public void removeGeneratedValues() {
        if (this.namedTemplates != null) {
            this.namedTemplates.removeGeneratedValues();
        }
    }

    public int getNofTemplates() {
        return this.namedTemplates.getNofTemplates();
    }

    public NamedTemplate getTemplateByIndex(int index) {
        return this.namedTemplates.getTemplateByIndex(index);
    }

    @Override
    public boolean isValue(CompilationTimeStamp timestamp) {
        if (this.lengthRestriction != null || this.isIfpresent || this.getIsErroneous(timestamp)) {
            return false;
        }
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (this.namedTemplates.getTemplateByIndex(i).getTemplate().isValue(timestamp)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IValue getValue() {
        if (this.asValue != null) {
            return this.asValue;
        }
        NamedValues values = new NamedValues();
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            NamedTemplate namedTemplate = this.namedTemplates.getTemplateByIndex(i);
            NamedValue namedValue = new NamedValue(namedTemplate.getName(), namedTemplate.getTemplate().getValue());
            namedValue.setLocation(namedTemplate.getLocation());
            values.addNamedValue(namedValue);
        }
        this.asValue = new Sequence_Value(values);
        this.asValue.setLocation(this.getLocation());
        this.asValue.setMyScope(this.getMyScope());
        this.asValue.setFullNameParent(this.getNameParent());
        return this.asValue;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        int size = this.namedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            ITemplateListItem temp = this.namedTemplates.getTemplateByIndex(i).getTemplate();
            if (temp == null) continue;
            temp.checkSpecificValue(timestamp, true);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            for (int i = 0; i < this.namedTemplates.getNofTemplates(); ++i) {
                NamedTemplate template = this.namedTemplates.getTemplateByIndex(i);
                if (template == null) continue;
                referenceChain.markState();
                template.getTemplate().checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public boolean chkRestrictionNamedListBaseTemplate(CompilationTimeStamp timestamp, String definitionName, Set<String> checkedNames, int neededCheckedCnt, Location usageLocation) {
        boolean needsRuntimeCheck = false;
        if (checkedNames.size() >= neededCheckedCnt) {
            return needsRuntimeCheck;
        }
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            ITemplateListItem tmpl = this.namedTemplates.getTemplateByIndex(i).getTemplate();
            String name = this.namedTemplates.getTemplateByIndex(i).getName().getName();
            if (checkedNames.contains(name)) continue;
            if (tmpl.checkValueomitRestriction(timestamp, definitionName, true, usageLocation)) {
                needsRuntimeCheck = true;
            }
            checkedNames.add(name);
        }
        if (this.baseTemplate instanceof Named_Template_List && ((Named_Template_List)this.baseTemplate).chkRestrictionNamedListBaseTemplate(timestamp, definitionName, checkedNames, neededCheckedCnt, usageLocation)) {
            needsRuntimeCheck = true;
        }
        return needsRuntimeCheck;
    }

    @Override
    public boolean checkValueomitRestriction(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Location usageLocation) {
        if (omitAllowed) {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_OMIT, usageLocation);
        } else {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_VALUE, usageLocation);
        }
        boolean needsRuntimeCheck = false;
        int neededCheckedCnt = 0;
        if (this.baseTemplate != null && this.myGovernor != null) {
            HashSet<String> checkedNames = new HashSet<String>();
            switch (this.myGovernor.getTypetype()) {
                case TYPE_TTCN3_SEQUENCE: {
                    neededCheckedCnt = ((TTCN3_Sequence_Type)this.myGovernor).getNofComponents();
                    break;
                }
                case TYPE_ASN1_SEQUENCE: {
                    neededCheckedCnt = ((ASN1_Sequence_Type)this.myGovernor).getNofComponents(timestamp);
                    break;
                }
                case TYPE_TTCN3_SET: {
                    neededCheckedCnt = ((TTCN3_Set_Type)this.myGovernor).getNofComponents();
                    break;
                }
                case TYPE_ASN1_SET: {
                    neededCheckedCnt = ((ASN1_Set_Type)this.myGovernor).getNofComponents(timestamp);
                    break;
                }
                case TYPE_SIGNATURE: {
                    neededCheckedCnt = ((Signature_Type)this.myGovernor).getNofParameters();
                    break;
                }
            }
            int size = this.getNofTemplates();
            for (int i = 0; i < size; ++i) {
                NamedTemplate temp = this.namedTemplates.getTemplateByIndex(i);
                if (temp.getTemplate().checkValueomitRestriction(timestamp, definitionName, true, usageLocation)) {
                    needsRuntimeCheck = true;
                }
                if (neededCheckedCnt <= 0) continue;
                checkedNames.add(temp.getName().getName());
            }
            if (neededCheckedCnt > 0 && this.baseTemplate instanceof Named_Template_List && ((Named_Template_List)this.baseTemplate).chkRestrictionNamedListBaseTemplate(timestamp, definitionName, checkedNames, neededCheckedCnt, usageLocation)) {
                needsRuntimeCheck = true;
            }
        }
        return needsRuntimeCheck;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.updateSyntax(reparser, false);
            reparser.updateLocation(this.lengthRestriction.getLocation());
        }
        if (this.baseTemplate instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.baseTemplate)).updateSyntax(reparser, false);
            reparser.updateLocation(this.baseTemplate.getLocation());
        } else if (this.baseTemplate != null) {
            throw new ReParseException();
        }
        this.namedTemplates.updateSyntax(reparser, false);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        NamedTemplate nt;
        IType govLast;
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.asValue != null) {
            this.asValue.findReferences(referenceFinder, foundIdentifiers);
            return;
        }
        if (this.namedTemplates == null) {
            return;
        }
        if (referenceFinder.assignment.getAssignmentType() == Assignment.Assignment_type.A_TYPE && referenceFinder.fieldId != null && this.myGovernor != null && referenceFinder.type == (govLast = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp())) && (nt = this.namedTemplates.getNamedTemplateByName(referenceFinder.fieldId)) != null) {
            foundIdentifiers.add(new ReferenceFinder.Hit(nt.getName()));
        }
        this.namedTemplates.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return !(this.asValue != null ? !this.asValue.accept(v) : this.namedTemplates != null && !this.namedTemplates.accept(v));
    }
}

