/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ComponentTypeReferenceList
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    public static final String FULLNAMEPART = ".<ref";
    public static final String DUPLICATECOMPONENTREFERENCEFIRST = "Duplicate reference to component `{0}'' was first declared here";
    public static final String DUPLICATECOMPONENTREFERENCEREPEATED = "Duplicate reference to component `{0}'' was declared here again";
    private final List<Reference> componentReferences = new CopyOnWriteArrayList<Reference>();
    private Map<ComponentTypeBody, Reference> componentTypeBodies;
    private List<ComponentTypeBody> orderedComponentTypeBodies;
    private Location location;
    private CompilationTimeStamp lastCompilationTimeStamp;

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (int i = 0; i < this.componentReferences.size(); ++i) {
            if (this.componentReferences.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(String.valueOf(i + 1)).append(">");
        }
        return builder;
    }

    public void addReference(Reference reference) {
        this.componentReferences.add(reference);
        reference.setFullNameParent(this);
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    public List<ComponentTypeBody> getComponentBodies() {
        return this.orderedComponentTypeBodies;
    }

    @Override
    public void setMyScope(Scope scope) {
        for (Reference reference : this.componentReferences) {
            reference.setMyScope(scope);
        }
    }

    protected void checkRecursion(IReferenceChain refChain) {
        if (this.orderedComponentTypeBodies == null) {
            return;
        }
        for (ComponentTypeBody body : this.orderedComponentTypeBodies) {
            refChain.markState();
            body.checkRecursion(refChain);
            refChain.previousState();
        }
    }

    private void checkUniqueness(CompilationTimeStamp timestamp) {
        if (this.orderedComponentTypeBodies == null) {
            this.componentTypeBodies = new HashMap<ComponentTypeBody, Reference>(this.componentReferences.size());
            this.orderedComponentTypeBodies = new ArrayList<ComponentTypeBody>(this.componentReferences.size());
        }
        this.componentTypeBodies.clear();
        this.orderedComponentTypeBodies.clear();
        for (Reference reference : this.componentReferences) {
            ComponentTypeBody compTypeBody;
            Component_Type componentType = reference.chkComponentypeReference(timestamp);
            if (componentType == null || (compTypeBody = componentType.getComponentBody()) == null) continue;
            if (this.componentTypeBodies.containsKey(compTypeBody)) {
                this.componentTypeBodies.get(compTypeBody).getId().getLocation().reportSingularSemanticError(MessageFormat.format(DUPLICATECOMPONENTREFERENCEFIRST, compTypeBody.getIdentifier().getDisplayName()));
                reference.getLocation().reportSemanticError(MessageFormat.format(DUPLICATECOMPONENTREFERENCEREPEATED, reference.getDisplayName()));
                continue;
            }
            this.componentTypeBodies.put(compTypeBody, reference);
            this.orderedComponentTypeBodies.add(compTypeBody);
        }
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        this.checkUniqueness(timestamp);
        this.lastCompilationTimeStamp = timestamp;
        for (ComponentTypeBody body : this.orderedComponentTypeBodies) {
            body.check(timestamp);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        int size = this.componentReferences.size();
        for (int i = 0; i < size; ++i) {
            Reference reference = this.componentReferences.get(i);
            reference.updateSyntax(reparser, false);
            reparser.updateLocation(reference.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentReferences != null) {
            for (Reference ref : this.componentReferences) {
                ref.findReferences(referenceFinder, foundIdentifiers);
            }
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentReferences != null) {
            for (Reference ref : this.componentReferences) {
                if (ref.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

