/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class AddExpression
extends Expression_Value {
    private static final String FIRSTOPERANDERROR = "The first operand of the `+' operation should be an integer or float value";
    private static final String FIRSTOPERANDERROR2 = "{0} can not be used as the first operand of the `+'' operation";
    private static final String SECONDOPERANDERROR = "The second operand of the `+' operation should be an integer or float value";
    private static final String SECONDOPERANDERROR2 = "{0} can not be used as the second operand of the `+'' operation";
    private static final String SAMEOPERANDERROR = "The operands of operation `+' should be of the same type";
    private final Value value1;
    private final Value value2;

    public AddExpression(Value value1, Value value2) {
        this.value1 = value1;
        this.value2 = value2;
        if (value1 != null) {
            value1.setFullNameParent(this);
        }
        if (value2 != null) {
            value2.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.ADD_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('(').append(this.value1.createStringRepresentation());
        builder.append(" + ");
        builder.append(this.value2.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value1 != null) {
            this.value1.setMyScope(scope);
        }
        if (this.value2 != null) {
            this.value2.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.value2 == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.value1 == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        this.value1.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value1.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_INTEGER: 
            case TYPE_REAL: {
                return tempType;
            }
            case TYPE_UNDEFINED: {
                return tempType;
            }
        }
        this.getValueRefdLast(timestamp, expectedValue, null);
        this.setIsErroneous(true);
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value1 == null || this.value2 == null) {
            return true;
        }
        return this.value1.isUnfoldable(timestamp, expectedValue, referenceChain) || this.value2.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        Real_Value real;
        IType.Type_type tempType1 = null;
        IType.Type_type tempType2 = null;
        if (this.value1 != null) {
            this.value1.setLoweridToReference(timestamp);
            tempType1 = this.value1.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType1) {
                case TYPE_INTEGER: {
                    this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_REAL: {
                    IValue last = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (last.getIsErroneous(timestamp) || last.isUnfoldable(timestamp) || !(real = (Real_Value)last).isSpecialFloat()) break;
                    this.value1.getLocation().reportSemanticError(MessageFormat.format(FIRSTOPERANDERROR2, real.createStringRepresentation()));
                    this.setIsErroneous(true);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.value1.getLocation().reportSemanticError(FIRSTOPERANDERROR);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.value2 != null) {
            this.value2.setLoweridToReference(timestamp);
            tempType2 = this.value2.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType2) {
                case TYPE_INTEGER: {
                    this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_REAL: {
                    IValue lastValue = this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (lastValue.getIsErroneous(timestamp) || lastValue.isUnfoldable(timestamp) || !(real = (Real_Value)lastValue).isSpecialFloat()) break;
                    this.value2.getLocation().reportSemanticError(MessageFormat.format(SECONDOPERANDERROR2, real.createStringRepresentation()));
                    this.setIsErroneous(true);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.value2.getLocation().reportSemanticError(SECONDOPERANDERROR);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.value1 != null && this.value2 != null && !this.getIsErroneous(timestamp)) {
            if (this.value1.getIsErroneous(timestamp) || this.value2.getIsErroneous(timestamp)) {
                this.setIsErroneous(true);
                return;
            }
            if (tempType1 != tempType2) {
                this.location.reportSemanticError(SAMEOPERANDERROR);
                this.setIsErroneous(true);
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value1 == null || this.value2 == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp) || this.isUnfoldable(timestamp, referenceChain)) {
            this.setIsErroneous(true);
            return this.lastValue;
        }
        IValue last1 = this.value1.getValueRefdLast(timestamp, referenceChain);
        IValue last2 = this.value2.getValueRefdLast(timestamp, referenceChain);
        if (last1.getIsErroneous(timestamp) || last2.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return this.lastValue;
        }
        switch (last1.getValuetype()) {
            case INTEGER_VALUE: {
                this.lastValue = ((Integer_Value)last1).add((Integer_Value)last2);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case REAL_VALUE: {
                double f1 = ((Real_Value)last1).getValue();
                double f2 = ((Real_Value)last2).getValue();
                this.lastValue = new Real_Value(f1 + f2);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            default: {
                this.setIsErroneous(true);
            }
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.value1 != null) {
                referenceChain.markState();
                this.value1.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value2 != null) {
                referenceChain.markState();
                this.value2.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value1 != null) {
            this.value1.updateSyntax(reparser, false);
            reparser.updateLocation(this.value1.getLocation());
        }
        if (this.value2 != null) {
            this.value2.updateSyntax(reparser, false);
            reparser.updateLocation(this.value2.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value1 != null) {
            this.value1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value2 != null) {
            this.value2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value1 != null && !this.value1.accept(v)) {
            return false;
        }
        return this.value2 == null || this.value2.accept(v);
    }
}

