/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ApplyExpression
extends Expression_Value {
    private static final String NORETURNTYPE = "The type `{0}' has no return type";
    private static final String VALUEXPECTED1 = "A value of type function was expected";
    private static final String VALUEXPECTED2 = "Reference to a value was expected, but functions of type `{0}'' return a template of type `{1}''";
    private static final String VALUEXPECTED3 = "A value of type function was expected in the argument of `{0}''";
    private static final String EVALUATABLEEXPECTED = "An evaluatable value was expected instead of operation `apply()''";
    private static final String STATICEXPECTED = "A static value was expected instead of operation `apply()''";
    private static final String FULLNAMEPART1 = ".<parameters>";
    private final Value value;
    private final ParsedActualParameters actualParameterList;

    public ApplyExpression(Value value, ParsedActualParameters actualParameterList) {
        this.value = value;
        this.actualParameterList = actualParameterList;
        if (value != null) {
            value.setFullNameParent(this);
        }
        if (actualParameterList != null) {
            actualParameterList.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.APPLY_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value.createStringRepresentation());
        builder.append(".apply(");
        builder.append("...");
        builder.append(')');
        return builder.toString();
    }

    public Value getValue() {
        return this.value;
    }

    public ParsedActualParameters getParameters() {
        return this.actualParameterList;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(".<operand>");
        }
        if (this.actualParameterList == child) {
            return builder.append(FULLNAMEPART1);
        }
        return builder;
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        if (this.value == null) {
            return null;
        }
        IType type = this.value.getExpressionGovernor(timestamp, expectedValue);
        if (type == null) {
            if (!this.value.getIsErroneous(timestamp)) {
                this.value.getLocation().reportSemanticError(VALUEXPECTED1);
            }
            this.setIsErroneous(true);
            return null;
        }
        type = type.getTypeRefdLast(timestamp);
        switch (type.getTypetype()) {
            case TYPE_FUNCTION: {
                Type result = ((Function_Type)type).getReturnType();
                if (!Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue) && ((Function_Type)type).returnsTemplate()) {
                    this.location.reportSemanticError(MessageFormat.format(VALUEXPECTED2, type.getTypename(), result.getTypename()));
                }
                return result;
            }
        }
        this.setIsErroneous(true);
        return null;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.value == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        if (this.value.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return IType.Type_type.TYPE_UNDEFINED;
        }
        IType type = this.value.getExpressionGovernor(timestamp, expectedValue);
        if (type == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        type = type.getTypeRefdLast(timestamp);
        switch (type.getTypetype()) {
            case TYPE_FUNCTION: {
                Type returnType = ((Function_Type)type).getReturnType();
                if (returnType == null) {
                    this.value.getLocation().reportSemanticError(MessageFormat.format(NORETURNTYPE, type.getTypename()));
                    this.setIsErroneous(true);
                    return IType.Type_type.TYPE_UNDEFINED;
                }
                return returnType.getTypeRefdLast(timestamp).getTypetype();
            }
            case TYPE_TESTCASE: {
                return IType.Type_type.TYPE_VERDICT;
            }
        }
        this.setIsErroneous(true);
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        ISetting type = null;
        if (this.value != null) {
            this.value.setLoweridToReference(timestamp);
            type = this.value.getExpressionGovernor(timestamp, expectedValue);
        }
        if (type == null || type.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return;
        }
        if (!IType.Type_type.TYPE_FUNCTION.equals((Object)(type = type.getTypeRefdLast(timestamp)).getTypetype())) {
            this.value.getLocation().reportSemanticError(MessageFormat.format(VALUEXPECTED3, type.getTypename()));
            this.setIsErroneous(true);
            return;
        }
        if (this.myScope != null) {
            this.myScope.checkRunsOnScope(timestamp, (IType)type, (ILocateableNode)this, "call");
        }
        ActualParameterList tempActualParameters = new ActualParameterList();
        FormalParameterList formalParameterList = ((Function_Type)type).getFormalParameters();
        if (!formalParameterList.checkActualParameterList(timestamp, this.actualParameterList, tempActualParameters)) {
            tempActualParameters.setFullNameParent(this);
            tempActualParameters.setMyScope(this.getMyScope());
        }
        switch (expectedValue) {
            case EXPECTED_CONSTANT: {
                this.getLocation().reportSemanticError(EVALUATABLEEXPECTED);
                this.setIsErroneous(true);
                break;
            }
            case EXPECTED_STATIC_VALUE: {
                this.getLocation().reportSemanticError(STATICEXPECTED);
                this.setIsErroneous(true);
                break;
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        return this.lastValue;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.updateSyntax(reparser, false);
            reparser.updateLocation(this.actualParameterList.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value != null && !this.value.accept(v)) {
            return false;
        }
        return this.actualParameterList == null || this.actualParameterList.accept(v);
    }
}

