/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ReplaceExpression
extends Expression_Value {
    private static final String OPERANDERROR1 = "The second operand of operation `replace' should be an integer value";
    private static final String OPERANDERROR2 = "The third operand of operation `replace' should be an integer value";
    private static final String OPERANDERROR3 = "The second operand of operation `replace' should not be negative";
    private static final String OPERANDERROR4 = "The third operand of operation `replace' should not be negative";
    private static final String OPERANDERROR5 = "The first operand of operation `replace' should be a string, `record of', or a `set of' value";
    private static final String OPERANDERROR6 = "The fourth operand of operation `replace' should be a string, `record of', or a `set of' value";
    private static final String OPERANDERROR7 = "The first and fourth operands of operation `replace' should be of the same type";
    private static final String OPERANDERROR8 = "The third operand of operation `replace'' ({0}) is greater than the length of the first operand ({1})";
    private static final String OPERANDERROR9 = "The second operand of operation `replace'' ({0}) is greater than the length of the first operand ({1})";
    private static final String OPERANDERROR10 = "The sum of the second operand ({0}) and the third operand ({1}) of operation `replace'' is greater than the length of the first operand ({2})";
    private static final String OPERANDERROR11 = "Using a large integer value ({0}) as the second operand of operation `replace'' is not allowed";
    private static final String OPERANDERROR12 = "Using a large integer value ({0}) as the third operand of operation `replace'' is not allowed'";
    private final TemplateInstance templateInstance1;
    private final Value value2;
    private final Value value3;
    private final TemplateInstance templateInstance4;

    public ReplaceExpression(TemplateInstance templateInstance1, Value value2, Value value3, TemplateInstance templateInstance4) {
        this.templateInstance1 = templateInstance1;
        this.value2 = value2;
        this.value3 = value3;
        this.templateInstance4 = templateInstance4;
        if (templateInstance1 != null) {
            templateInstance1.setFullNameParent(this);
        }
        if (value2 != null) {
            value2.setFullNameParent(this);
        }
        if (value3 != null) {
            value3.setFullNameParent(this);
        }
        if (templateInstance4 != null) {
            templateInstance4.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.REPLACE_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("replace(");
        builder.append(this.templateInstance1.createStringRepresentation());
        builder.append(", ");
        builder.append(this.value2.createStringRepresentation());
        builder.append(", ");
        builder.append(this.value3.createStringRepresentation());
        builder.append(", ");
        builder.append(this.templateInstance4.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstance1 != null) {
            this.templateInstance1.setMyScope(scope);
        }
        if (this.value2 != null) {
            this.value2.setMyScope(scope);
        }
        if (this.value3 != null) {
            this.value3.setMyScope(scope);
        }
        if (this.templateInstance4 != null) {
            this.templateInstance4.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstance1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.value2 == child) {
            return builder.append(".<operand2>");
        }
        if (this.value3 == child) {
            return builder.append(".<operand3>");
        }
        if (this.templateInstance4 == child) {
            return builder.append(".<operand4>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IValue last = this.getValueRefdLast(timestamp, expectedValue, null);
        if (last == null || this.templateInstance1 == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        if (last.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return IType.Type_type.TYPE_UNDEFINED;
        }
        ITTCN3Template template = this.templateInstance1.getTemplateBody().setLoweridToReference(timestamp);
        IType.Type_type tempType = template.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        switch (tempType) {
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: 
            case TYPE_SET_OF: 
            case TYPE_SEQUENCE_OF: {
                return tempType;
            }
            case TYPE_UNDEFINED: {
                return tempType;
            }
        }
        this.setIsErroneous(true);
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.templateInstance1 == null || this.templateInstance4 == null || this.getIsErroneous(timestamp)) {
            return true;
        }
        TTCN3Template template1 = this.templateInstance1.getTemplateBody();
        if (template1 == null || !ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)template1.getTemplatetype())) {
            return true;
        }
        TTCN3Template template4 = this.templateInstance4.getTemplateBody();
        if (template4 == null || !ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)template4.getTemplatetype())) {
            return true;
        }
        IValue value1 = ((SpecificValue_Template)template1).getSpecificValue();
        IValue value4 = ((SpecificValue_Template)template4).getSpecificValue();
        if (value1 == null || value4 == null) {
            return true;
        }
        if (this.value2 == null || this.value3 == null) {
            return true;
        }
        if (value1.isUnfoldable(timestamp, expectedValue, referenceChain) || this.value2.isUnfoldable(timestamp, expectedValue, referenceChain) || this.value3.isUnfoldable(timestamp, expectedValue, referenceChain) || value4.isUnfoldable(timestamp, expectedValue, referenceChain)) {
            return true;
        }
        value1.setLoweridToReference(timestamp);
        IType.Type_type tempType = value1.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: {
                return false;
            }
        }
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        long i;
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        Enum tempType1 = null;
        IValue value1 = null;
        if (this.templateInstance1 != null) {
            TTCN3Template temp = this.templateInstance1.getTemplateBody();
            if (!ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)temp.getTemplatetype())) {
                this.location.reportSemanticError(OPERANDERROR5);
                this.setIsErroneous(true);
                return;
            }
            value1 = ((SpecificValue_Template)temp).getSpecificValue();
            value1.setLoweridToReference(timestamp);
            tempType1 = value1.getExpressionReturntype(timestamp, internalExpectation);
            switch (1.$SwitchMap$org$eclipse$titan$designer$AST$IType$Type_type[tempType1.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    value1.getValueRefdLast(timestamp, internalExpectation, referenceChain);
                    break;
                }
                case 8: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERANDERROR5);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.value2 != null) {
            this.value2.setLoweridToReference(timestamp);
            IType.Type_type tempType2 = this.value2.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType2) {
                case TYPE_INTEGER: {
                    IValue last2 = this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (last2.isUnfoldable(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)last2.getValuetype())) break;
                    if (((Integer_Value)last2).isNative()) {
                        i = ((Integer_Value)last2).getValue();
                        if (i >= 0L) break;
                        this.value2.getLocation().reportSemanticError(OPERANDERROR3);
                        this.setIsErroneous(true);
                        break;
                    }
                    this.value2.getLocation().reportSemanticError(MessageFormat.format(OPERANDERROR11, this.value2));
                    this.setIsErroneous(true);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERANDERROR1);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.value3 != null) {
            this.value3.setLoweridToReference(timestamp);
            IType.Type_type tempType3 = this.value3.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType3) {
                case TYPE_INTEGER: {
                    IValue last3 = this.value3.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (last3.isUnfoldable(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)last3.getValuetype())) break;
                    if (((Integer_Value)last3).isNative()) {
                        i = ((Integer_Value)last3).getValue();
                        if (i >= 0L) break;
                        this.value3.getLocation().reportSemanticError(OPERANDERROR4);
                        this.setIsErroneous(true);
                        break;
                    }
                    this.value3.getLocation().reportSemanticError(MessageFormat.format(OPERANDERROR12, last3));
                    this.setIsErroneous(true);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERANDERROR2);
                    this.setIsErroneous(true);
                }
            }
        }
        IType.Type_type tempType4 = null;
        IValue value4 = null;
        if (this.templateInstance4 != null) {
            TTCN3Template temp = this.templateInstance4.getTemplateBody();
            switch (temp.getTemplatetype()) {
                case SPECIFIC_VALUE: {
                    value4 = ((SpecificValue_Template)temp).getSpecificValue();
                    break;
                }
                case TEMPLATE_LIST: {
                    if (!((Template_List)temp).isValue(timestamp)) {
                        this.location.reportSemanticError(OPERANDERROR6);
                        this.setIsErroneous(true);
                        return;
                    }
                }
                case NAMED_TEMPLATE_LIST: 
                case INDEXED_TEMPLATE_LIST: {
                    return;
                }
                default: {
                    this.location.reportSemanticError(OPERANDERROR6);
                    this.setIsErroneous(true);
                    return;
                }
            }
            value4.setLoweridToReference(timestamp);
            tempType4 = value4.getExpressionReturntype(timestamp, internalExpectation);
            switch (tempType4) {
                case TYPE_BITSTRING: 
                case TYPE_HEXSTRING: 
                case TYPE_OCTETSTRING: 
                case TYPE_CHARSTRING: 
                case TYPE_UCHARSTRING: 
                case TYPE_SET_OF: 
                case TYPE_SEQUENCE_OF: {
                    value4.getValueRefdLast(timestamp, internalExpectation, referenceChain);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERANDERROR6);
                    this.setIsErroneous(true);
                }
            }
        }
        if (tempType1 != null && tempType4 != null && !tempType1.equals((Object)tempType4) && !this.getIsErroneous(timestamp)) {
            this.location.reportSemanticError(OPERANDERROR7);
            this.setIsErroneous(true);
        }
        this.checkExpressionOperandsHelper(timestamp, value1, expectedValue, referenceChain);
    }

    private void checkExpressionOperandsHelper(CompilationTimeStamp timestamp, IValue value1, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.templateInstance1 == null || this.getIsErroneous(timestamp)) {
            return;
        }
        long valueSize = -1L;
        if (!value1.isUnfoldable(timestamp)) {
            IValue temp = value1.setLoweridToReference(timestamp);
            temp = temp.getValueRefdLast(timestamp, referenceChain);
            switch (temp.getValuetype()) {
                case BITSTRING_VALUE: {
                    valueSize = ((Bitstring_Value)temp).getValueLength();
                    break;
                }
                case HEXSTRING_VALUE: {
                    valueSize = ((Hexstring_Value)temp).getValueLength();
                    break;
                }
                case OCTETSTRING_VALUE: {
                    valueSize = ((Octetstring_Value)temp).getValueLength();
                    break;
                }
                case CHARSTRING_VALUE: {
                    valueSize = ((Charstring_Value)temp).getValueLength();
                    break;
                }
                case UNIVERSALCHARSTRING_VALUE: {
                    valueSize = ((UniversalCharstring_Value)temp).getValueLength();
                    break;
                }
                case SETOF_VALUE: {
                    valueSize = ((SetOf_Value)temp).getNofComponents();
                    break;
                }
                case SEQUENCEOF_VALUE: {
                    valueSize = ((SequenceOf_Value)temp).getNofComponents();
                    break;
                }
            }
        }
        if (valueSize < 0L) {
            return;
        }
        if (this.value2 == null || this.value3 == null || this.templateInstance4 == null) {
            return;
        }
        if (this.value2.isUnfoldable(timestamp)) {
            IValue last3;
            long last3Value;
            if (!this.value3.isUnfoldable(timestamp) && (last3Value = ((Integer_Value)(last3 = this.value3.getValueRefdLast(timestamp, expectedValue, referenceChain))).getValue()) > valueSize) {
                this.location.reportSemanticError(MessageFormat.format(OPERANDERROR8, last3Value, valueSize));
                this.setIsErroneous(true);
            }
        } else {
            IValue last2 = this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
            long last2Value = ((Integer_Value)last2).getValue();
            if (this.value3.isUnfoldable(timestamp)) {
                if (last2Value > valueSize) {
                    this.location.reportSemanticError(MessageFormat.format(OPERANDERROR9, last2Value, valueSize));
                    this.setIsErroneous(true);
                }
            } else {
                IValue last3 = this.value3.getValueRefdLast(timestamp, expectedValue, referenceChain);
                long last3Value = ((Integer_Value)last3).getValue();
                if (last2Value + last3Value > valueSize) {
                    this.location.reportSemanticError(MessageFormat.format(OPERANDERROR10, last2Value, last3Value, valueSize));
                    this.setIsErroneous(true);
                }
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance1 == null || this.value2 == null || this.value3 == null || this.templateInstance4 == null) {
            this.setIsErroneous(true);
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        TTCN3Template temp = this.templateInstance1.getTemplateBody();
        IValue value1 = ((SpecificValue_Template)temp).getSpecificValue();
        IValue v1 = value1.getValueRefdLast(timestamp, referenceChain);
        IValue v2 = this.value2.getValueRefdLast(timestamp, referenceChain);
        IValue v3 = this.value3.getValueRefdLast(timestamp, referenceChain);
        temp = this.templateInstance4.getTemplateBody();
        IValue value4 = ((SpecificValue_Template)temp).getSpecificValue();
        IValue v4 = value4.getValueRefdLast(timestamp, referenceChain);
        IValue.Value_type vt = value1.getValuetype();
        int index = ((Integer_Value)v2).intValue();
        int len = ((Integer_Value)v3).intValue();
        switch (vt) {
            case BITSTRING_VALUE: {
                String v1Str = ((Bitstring_Value)v1).getValue();
                String v4Str = ((Bitstring_Value)v4).getValue();
                String result = v1Str.substring(0, index);
                result = result.concat(v4Str);
                result = result.concat(v1Str.substring(index + len));
                this.lastValue = new Bitstring_Value(result);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case HEXSTRING_VALUE: {
                String v1Str = ((Hexstring_Value)v1).getValue();
                String v4Str = ((Hexstring_Value)v4).getValue();
                String result = v1Str.substring(0, index);
                result = result.concat(v4Str);
                result = result.concat(v1Str.substring(index + len));
                this.lastValue = new Hexstring_Value(result);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case OCTETSTRING_VALUE: {
                String v1Str = ((Octetstring_Value)v1).getValue();
                String v4Str = ((Octetstring_Value)v4).getValue();
                String result = v1Str.substring(0, index * 2);
                result = result.concat(v4Str);
                result = result.concat(v1Str.substring((index + len) * 2));
                this.lastValue = new Octetstring_Value(result);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case CHARSTRING_VALUE: {
                String v1Str = ((Charstring_Value)v1).getValue();
                String v4Str = ((Charstring_Value)v4).getValue();
                String result = v1Str.substring(0, index);
                result = result.concat(v4Str);
                result = result.concat(v1Str.substring(index + len));
                this.lastValue = new Charstring_Value(result);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case UNIVERSALCHARSTRING_VALUE: {
                UniversalCharstring v1Str = ((UniversalCharstring_Value)v1).getValue();
                UniversalCharstring v4Str = ((UniversalCharstring_Value)v4).getValue();
                UniversalCharstring result = v1Str.substring(0, index);
                result.append(v4Str);
                result.append(v1Str.substring(index + len));
                this.lastValue = new UniversalCharstring_Value(result);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            default: {
                this.setIsErroneous(true);
            }
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.templateInstance1 != null) {
                referenceChain.markState();
                this.templateInstance1.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value2 != null) {
                referenceChain.markState();
                this.value2.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value3 != null) {
                referenceChain.markState();
                this.value3.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.templateInstance4 != null) {
                referenceChain.markState();
                this.templateInstance4.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstance1 != null) {
            this.templateInstance1.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance1.getLocation());
        }
        if (this.value2 != null) {
            this.value2.updateSyntax(reparser, false);
            reparser.updateLocation(this.value2.getLocation());
        }
        if (this.value3 != null) {
            this.value3.updateSyntax(reparser, false);
            reparser.updateLocation(this.value3.getLocation());
        }
        if (this.templateInstance4 != null) {
            this.templateInstance4.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance4.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstance1 != null) {
            this.templateInstance1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value2 != null) {
            this.value2.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value3 != null) {
            this.value3.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.templateInstance4 != null) {
            this.templateInstance4.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.templateInstance1 != null && !this.templateInstance1.accept(v)) {
            return false;
        }
        if (this.value2 != null && !this.value2.accept(v)) {
            return false;
        }
        if (this.value3 != null && !this.value3.accept(v)) {
            return false;
        }
        return this.templateInstance4 == null || this.templateInstance4.accept(v);
    }
}

