/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectConfigurationParser;

public final class TITANBuilderResourceDeltaVisitor
implements IResourceDeltaVisitor {
    static final String[] FILES_NOT_WATCHED = new String[]{"compile", "Makefile", "Makefile.bak"};
    private boolean mandatoryMakefileRebuild = false;
    private final List<String> changedResources = new ArrayList<String>();
    private final Map<String, IFile> lastTimeRemovedFiles = new HashMap<String, IFile>();
    private boolean unAnalyzedFileChanged = false;
    private String makefileScript = null;
    private ProjectConfigurationParser configParser = null;

    public TITANBuilderResourceDeltaVisitor(IResourceDelta delta) {
        if (delta == null) {
            return;
        }
        IProject project = delta.getResource().getProject();
        if (project == null) {
            return;
        }
        try {
            this.makefileScript = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "makefileUpdateScript"));
            if (this.makefileScript != null) {
                URI uri = TITANPathUtilities.resolvePathURI((String)this.makefileScript, (String)project.getLocation().toOSString());
                this.makefileScript = URIUtil.toPath((URI)uri).toOSString();
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        this.configParser = GlobalParser.getConfigSourceParser(project);
    }

    public boolean needsMakefileRebuild() {
        return this.mandatoryMakefileRebuild;
    }

    public List<String> getChangedResources() {
        return this.changedResources;
    }

    public Map<String, IFile> getLastTimeRemovedFiles() {
        return this.lastTimeRemovedFiles;
    }

    public boolean getUnAnalyzedFileChanged() {
        return this.unAnalyzedFileChanged;
    }

    private boolean removeDangerousFiles(IFile file) {
        boolean foundDangerousFile = false;
        for (int i = 0; i < FILES_NOT_WATCHED.length; ++i) {
            if (!FILES_NOT_WATCHED[i].equals(file.getFullPath().lastSegment())) continue;
            foundDangerousFile = true;
            break;
        }
        if (!foundDangerousFile) {
            return false;
        }
        this.removeFromChangeList(file);
        return true;
    }

    private void removeFromChangeList(IFile file) {
        for (int i = this.changedResources.size() - 1; i >= 0; --i) {
            if (!new Path(this.changedResources.get(i)).isPrefixOf(file.getFullPath())) continue;
            this.changedResources.remove(i);
        }
    }

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        IPath resourceLocation = resource.getLocation();
        if (resourceLocation == null) {
            return false;
        }
        if (resource.getType() == 1) {
            if (this.removeDangerousFiles((IFile)resource)) {
                return false;
            }
            if (this.configParser != null && this.configParser.isFileKnown((IFile)resource)) {
                this.removeFromChangeList((IFile)resource);
                return false;
            }
            String extension = resource.getFileExtension();
            if (!(GlobalParser.SUPPORTED_TTCN3_EXTENSIONS[0].equals(extension) || GlobalParser.SUPPORTED_TTCN3_EXTENSIONS[1].equals(extension) || GlobalParser.SUPPORTED_ASN1_EXTENSIONS[0].equals(extension) || GlobalParser.SUPPORTED_ASN1_EXTENSIONS[1].equals(extension) || GlobalParser.SUPPORTED_CONFIG_FILE_EXTENSIONS[0].equals(extension))) {
                this.unAnalyzedFileChanged = true;
            }
        }
        switch (delta.getKind()) {
            case 1: {
                this.mandatoryMakefileRebuild = true;
                this.changedResources.add(delta.getFullPath().toString());
                break;
            }
            case 4: {
                if (resource.getType() == 1 && this.makefileScript != null && this.makefileScript.equals(resourceLocation.toOSString())) {
                    this.mandatoryMakefileRebuild = true;
                }
                this.changedResources.add(delta.getFullPath().toString());
                break;
            }
            case 2: {
                this.mandatoryMakefileRebuild = true;
                this.changedResources.add(delta.getFullPath().toString());
                if (resource.getType() != 1) break;
                this.lastTimeRemovedFiles.put(resourceLocation.lastSegment(), (IFile)resource);
                break;
            }
        }
        return true;
    }
}

