/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;

public final class BracketCompletionAutoEditStrategy
implements IAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text.length() != 1) {
            return;
        }
        char trigChar = command.text.charAt(0);
        try {
            switch (trigChar) {
                case '[': {
                    if (!Activator.getDefault().getPreferenceStore().getBoolean("org.eclipse.titan.designer.typing.close_square")) break;
                    this.insertSingleChar(command, ']');
                    break;
                }
                case '\"': {
                    if (!Activator.getDefault().getPreferenceStore().getBoolean("org.eclipse.titan.designer.typing.close_apostrophe")) break;
                    this.handleQuotes(document, command, '\"');
                    break;
                }
                case '\'': {
                    if (!Activator.getDefault().getPreferenceStore().getBoolean("org.eclipse.titan.designer.typing.close_apostrophe")) break;
                    this.handleQuotes(document, command, '\'');
                    break;
                }
                case '(': {
                    if (!Activator.getDefault().getPreferenceStore().getBoolean("org.eclipse.titan.designer.typing.close_parantheses")) break;
                    this.insertSingleChar(command, ')');
                    break;
                }
                case ')': {
                    this.handleClosingBracket(document, ')', command);
                    break;
                }
                case ']': {
                    this.handleClosingBracket(document, ']', command);
                    break;
                }
                case '{': {
                    if (!Activator.getDefault().getPreferenceStore().getBoolean("org.eclipse.titan.designer.typing.close_braces")) break;
                    this.insertSingleChar(command, '}');
                    break;
                }
                case '}': {
                    this.handleClosingBracket(document, '}', command);
                    break;
                }
            }
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    private void insertSingleChar(DocumentCommand docCommand, char newChar) {
        docCommand.text = docCommand.text + newChar;
        docCommand.caretOffset = docCommand.offset + 1;
        docCommand.shiftsCaret = false;
    }

    private void handleClosingBracket(IDocument doc, char bracket, DocumentCommand docCommand) {
        try {
            char nextChar;
            if (docCommand.offset + docCommand.length < doc.getLength() && (nextChar = doc.getChar(docCommand.offset + docCommand.length)) == bracket) {
                this.stepThrough(docCommand, 1);
            }
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return;
        }
    }

    private void handleQuotes(IDocument doc, DocumentCommand docCommand, char quoteChar) throws BadLocationException {
        char nextChar;
        char previousChar;
        if (docCommand.offset < 0) {
            return;
        }
        if (docCommand.offset + docCommand.length >= doc.getLength()) {
            this.insertSingleChar(docCommand, quoteChar);
            return;
        }
        if (docCommand.length > 0) {
            docCommand.text = quoteChar + doc.get(docCommand.offset, docCommand.length) + quoteChar;
            docCommand.caretOffset = docCommand.offset + docCommand.length + 2;
            docCommand.shiftsCaret = false;
            return;
        }
        try {
            previousChar = doc.getChar(docCommand.offset + docCommand.length - 1);
            nextChar = doc.getChar(docCommand.offset + docCommand.length);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return;
        }
        if (nextChar == quoteChar) {
            this.stepThrough(docCommand, 1);
            return;
        }
        if (Character.isLetterOrDigit(nextChar) || Character.isLetterOrDigit(previousChar)) {
            return;
        }
        this.insertSingleChar(docCommand, quoteChar);
    }

    protected void stepThrough(DocumentCommand docCommand, int chars2StepThru) {
        docCommand.text = "";
        docCommand.shiftsCaret = false;
        docCommand.offset += chars2StepThru;
        docCommand.caretOffset = docCommand.offset;
    }
}

