/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.actions;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ToggleComment
extends TextEditorAction {
    protected ITextOperationTarget operationTarget;
    private String documentPartitioning;
    private Map<String, String[]> prefixesMap;

    public ToggleComment(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        if (this.operationTarget == null || this.documentPartitioning == null || this.prefixesMap == null) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null || !this.validateEditorInputState()) {
            return;
        }
        final int operationCode = this.isSelectionCommented(editor.getSelectionProvider().getSelection()) ? 12 : 11;
        Shell shell = editor.getSite().getShell();
        if (!this.operationTarget.canDoOperation(operationCode)) {
            if (shell != null) {
                MessageDialog.openError((Shell)shell, (String)"Action can not be performed", (String)"The action \"Toggle Comment\" can not be performed right now.");
            }
            return;
        }
        Display display = null;
        if (shell != null && !shell.isDisposed()) {
            display = shell.getDisplay();
        }
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                ToggleComment.this.doOperation(operationCode);
            }
        });
    }

    protected void doOperation(int operationCode) {
        this.operationTarget.doOperation(operationCode);
    }

    private boolean isSelectionCommented(ISelection selection) {
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (textSelection.getStartLine() < 0 || textSelection.getEndLine() < 0) {
            return false;
        }
        IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
        try {
            IRegion block = this.getTextBlockFromSelection(textSelection, document);
            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)document, (String)this.documentPartitioning, (int)block.getOffset(), (int)block.getLength(), (boolean)false);
            int[] lines = new int[regions.length * 2];
            int i = 0;
            int j = 0;
            while (i < regions.length) {
                lines[j] = this.getFirstCompleteLineOfRegion((IRegion)regions[i], document);
                int length = regions[i].getLength();
                int offset = regions[i].getOffset() + length;
                if (length > 0) {
                    --offset;
                }
                lines[j + 1] = lines[j] == -1 ? -1 : document.getLineOfOffset(offset);
                ++i;
                j += 2;
            }
            i = 0;
            j = 0;
            while (i < regions.length) {
                String[] prefixes = this.prefixesMap.get(regions[i].getType());
                if (prefixes != null && prefixes.length > 0 && lines[j] >= 0 && lines[j + 1] >= 0 && !this.isBlockCommented(lines[j], lines[j + 1], prefixes, document)) {
                    return false;
                }
                ++i;
                j += 2;
            }
            return true;
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
    }

    private IRegion getTextBlockFromSelection(ITextSelection selection, IDocument document) {
        try {
            IRegion line = document.getLineInformationOfOffset(selection.getOffset());
            int length = selection.getLength() == 0 ? line.getLength() : selection.getLength() + (selection.getOffset() - line.getOffset());
            return new Region(line.getOffset(), length);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return null;
        }
    }

    private int getFirstCompleteLineOfRegion(IRegion region, IDocument document) {
        try {
            int startLine = document.getLineOfOffset(region.getOffset());
            int offset = document.getLineOffset(startLine);
            if (offset >= region.getOffset()) {
                return startLine;
            }
            int nextLine = startLine + 1;
            if (nextLine == document.getNumberOfLines()) {
                return -1;
            }
            offset = document.getLineOffset(nextLine);
            return offset > region.getOffset() + region.getLength() ? -1 : nextLine;
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return -1;
        }
    }

    private boolean isBlockCommented(int startLine, int endLine, String[] prefixes, IDocument document) {
        try {
            for (int i = startLine; i <= endLine; ++i) {
                IRegion line = document.getLineInformation(i);
                String text = document.get(line.getOffset(), line.getLength());
                int[] found = TextUtilities.indexOf((String[])prefixes, (String)text, (int)0);
                if (found[0] == -1) {
                    return false;
                }
                String s = document.get(line.getOffset(), found[0]);
                if ((s = s.trim()).length() == 0) continue;
                return false;
            }
            return true;
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
    }

    public void update() {
        super.update();
        if (!this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (this.operationTarget == null && editor != null) {
            this.operationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        }
        boolean isEnabled = this.operationTarget != null && this.operationTarget.canDoOperation(11) && this.operationTarget.canDoOperation(12);
        this.setEnabled(isEnabled);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this.operationTarget = null;
    }

    public void configure(ISourceViewer sourceViewer, SourceViewerConfiguration configuration) {
        String[] types = configuration.getConfiguredContentTypes(sourceViewer);
        this.prefixesMap = new HashMap<String, String[]>(types.length);
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            String[] defaultPrefixes = configuration.getDefaultPrefixes(sourceViewer, type);
            if (defaultPrefixes == null || defaultPrefixes.length <= 0) continue;
            this.prefixesMap.put(type, defaultPrefixes);
        }
        this.documentPartitioning = configuration.getConfiguredDocumentPartitioning(sourceViewer);
    }
}

