/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.execute;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.ExecuteSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigItemTransferBase;

public final class ExecuteItemTransfer
extends ConfigItemTransferBase {
    private static ExecuteItemTransfer instance = new ExecuteItemTransfer();
    private static final String TYPE_NAME = "TITAN-ExecutableItem-transfer-format";
    private static final int TYPEID = ExecuteItemTransfer.registerType((String)"TITAN-ExecutableItem-transfer-format");

    public static ExecuteItemTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        ExecuteSectionHandler.ExecuteItem[] items = (ExecuteSectionHandler.ExecuteItem[])object;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        byte[] bytes = null;
        try {
            out.writeInt(items.length);
            for (int i = 0; i < items.length; ++i) {
                out.writeUTF(this.convertToString(items[i].getRoot()));
            }
            out.close();
            bytes = byteOut.toByteArray();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        if (bytes != null) {
            super.javaToNative(bytes, transferData);
        }
    }

    protected ExecuteSectionHandler.ExecuteItem[] nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int n = in.readInt();
            ExecuteSectionHandler.ExecuteItem[] items = new ExecuteSectionHandler.ExecuteItem[n];
            for (int i = 0; i < n; ++i) {
                items[i] = new ExecuteSectionHandler.ExecuteItem();
                ParserRuleContext root = new ParserRuleContext();
                items[i].setRoot((ParseTree)root);
                String hiddenBefore = in.readUTF();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)hiddenBefore));
                String moduleName = in.readUTF();
                AddedParseTree moduleNameNode = new AddedParseTree(moduleName);
                items[i].setModuleName((ParseTree)moduleNameNode);
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)moduleNameNode);
                hiddenBefore = in.readUTF();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)hiddenBefore));
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree("."));
                hiddenBefore = in.readUTF();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)hiddenBefore));
                String testcaseName = in.readUTF();
                AddedParseTree testcaseNameNode = new AddedParseTree(testcaseName);
                items[i].setTestcaseName((ParseTree)testcaseNameNode);
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)testcaseNameNode);
            }
            return items;
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return new ExecuteSectionHandler.ExecuteItem[0];
        }
    }
}

