/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.include;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.IncludeSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.include.IncludeItemTransfer;

public final class IncludeSectionDropTargetListener
implements DropTargetListener {
    private TableViewer viewer;
    private ConfigEditor editor;

    public IncludeSectionDropTargetListener(TableViewer viewer, ConfigEditor editor) {
        this.viewer = viewer;
        this.editor = editor;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16 && (event.operations & 3) == 0) {
            event.detail = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (event.detail == 16 && (event.operations & 3) == 0) {
            event.detail = 0;
        }
    }

    public void dragOver(DropTargetEvent event) {
        if (event.item == null) {
            event.feedback = 8;
            event.detail = 0;
        } else {
            event.feedback = event.item.getData() instanceof ParseTree ? 25 : 10;
            if (event.detail == 0) {
                if ((event.operations & 2) != 0) {
                    event.detail = 2;
                } else if ((event.operations & 1) != 0) {
                    event.detail = 1;
                }
            }
        }
    }

    public void drop(DropTargetEvent event) {
        if (IncludeItemTransfer.getInstance().isSupportedType(event.currentDataType) && event.item != null && this.viewer.getInput() != null) {
            IncludeSectionHandler includeSectionHandler = (IncludeSectionHandler)this.viewer.getInput();
            ParseTree element = (ParseTree)event.item.getData();
            ParseTree[] items = (ParseTree[])event.data;
            int baseindex = includeSectionHandler.getFiles().indexOf(element);
            ParserRuleContext parent = includeSectionHandler.getLastSectionRoot();
            ConfigTreeNodeUtilities.removeChild((ParseTree)parent, (ParseTree)element);
            ConfigTreeNodeUtilities.addChild((ParseTree)parent, (ParseTree)element, (int)baseindex);
            if (items.length > 0) {
                for (int i = 0; i < items.length - 1; ++i) {
                    includeSectionHandler.getFiles().add(++baseindex, items[i]);
                }
                includeSectionHandler.getFiles().add(++baseindex, items[items.length - 1]);
            }
            this.viewer.refresh(true);
            this.editor.setDirty();
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

