/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.testportpar;

import java.util.Arrays;
import java.util.Iterator;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.TestportParameterSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.testportpar.TestportParameterDataContentProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.testportpar.TestportParameterDataLabelProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.testportpar.TestportParameterSectionDragSourceListener;
import org.eclipse.titan.designer.editors.configeditor.pages.testportpar.TestportParameterSectionDropTargetListener;
import org.eclipse.titan.designer.editors.configeditor.pages.testportpar.TestportParameterTransfer;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public final class TestportParametersSectionPage
extends FormPage {
    private Label totalTestportParametersLabel;
    private Table testportParametersTable;
    private TableViewer testportParametersTableViewer;
    private Button add;
    private Button remove;
    private String[] columnNames = new String[]{"componentName", "testportName", "parameterName"};
    private ScrolledForm form;
    private ConfigEditor editor;
    private Text parameterValueText;
    private boolean valueChanged = false;
    private TestportParameterSectionHandler testportParametersHandler = null;

    public TestportParametersSectionPage(ConfigEditor editor) {
        super((FormEditor)editor, "TestportParameters_section_page", "Testport parameters");
        this.editor = editor;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this.form.setText("Testport parameters section");
        this.form.setBackgroundImage(ImageCache.getImage("form_banner.gif"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.form.getBody().setLayout((Layout)layout);
        this.createTestportParameterTable(this.form.getBody(), this.form, toolkit);
        this.createDetailsPart(this.form.getBody(), this.form, toolkit);
        this.internalRefresh();
        this.setErrorMessage();
    }

    private void createTestportParameterTable(Composite parent, final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        this.testportParametersTable = toolkit.createTable(client, 66306);
        this.testportParametersTable.setEnabled(this.testportParametersHandler != null);
        TableColumn column = new TableColumn(this.testportParametersTable, 16384, 0);
        column.setText("Parameter name");
        column.setWidth(150);
        column.setMoveable(false);
        column = new TableColumn(this.testportParametersTable, 16384, 0);
        column.setText("Testport name");
        column.setMoveable(false);
        column.setWidth(130);
        column = new TableColumn(this.testportParametersTable, 16384, 0);
        column.setText("Component name");
        column.setMoveable(false);
        column.setWidth(130);
        this.testportParametersTable.setHeaderVisible(true);
        this.testportParametersTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        gd.heightHint = 200;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.testportParametersTable.setLayoutData((Object)gd);
        Composite buttons = toolkit.createComposite(client);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(1026));
        this.add = toolkit.createButton(buttons, "Add...", 8);
        gd = new GridData(258);
        this.add.setLayoutData((Object)gd);
        this.add.setEnabled(this.testportParametersHandler != null);
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TestportParameterSectionHandler.TestportParameter newTestportParameter;
                if (TestportParametersSectionPage.this.testportParametersHandler == null) {
                    return;
                }
                if (TestportParametersSectionPage.this.testportParametersHandler.getLastSectionRoot() == null) {
                    TestportParametersSectionPage.this.createNewTestportParameterSection();
                }
                if ((newTestportParameter = TestportParametersSectionPage.this.createNewParameter()) == null) {
                    return;
                }
                ConfigTreeNodeUtilities.addChild((ParseTree)TestportParametersSectionPage.this.testportParametersHandler.getLastSectionRoot(), (ParseTree)newTestportParameter.getRoot());
                TestportParametersSectionPage.this.testportParametersHandler.getTestportParameters().add(newTestportParameter);
                TestportParametersSectionPage.this.internalRefresh();
                TestportParametersSectionPage.this.testportParametersTableViewer.setSelection((ISelection)new StructuredSelection((Object)newTestportParameter));
                TestportParametersSectionPage.this.parameterValueText.setText(newTestportParameter.getValue().getText());
                TestportParametersSectionPage.this.editor.setDirty();
            }
        });
        this.remove = toolkit.createButton(buttons, "Remove", 8);
        gd = new GridData(258);
        this.remove.setLayoutData((Object)gd);
        this.remove.setEnabled(this.testportParametersHandler != null);
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (TestportParametersSectionPage.this.testportParametersTableViewer == null || TestportParametersSectionPage.this.testportParametersHandler == null) {
                    return;
                }
                TestportParametersSectionPage.this.removeSelectedParameters();
                if (TestportParametersSectionPage.this.testportParametersHandler.getTestportParameters().isEmpty()) {
                    TestportParametersSectionPage.this.removeTestportParameterSection();
                }
                TestportParametersSectionPage.this.internalRefresh();
                TestportParametersSectionPage.this.editor.setDirty();
            }
        });
        this.totalTestportParametersLabel = toolkit.createLabel(buttons, "Total: 0");
        gd = new GridData(258);
        this.totalTestportParametersLabel.setLayoutData((Object)gd);
        section.setText("Testport parameters");
        section.setDescription("Specify the list of testport parameters for this configuration.");
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        this.testportParametersTableViewer = new TableViewer(this.testportParametersTable);
        this.testportParametersTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.size() != 1) {
                    TestportParametersSectionPage.this.parameterValueText.setEnabled(false);
                    return;
                }
                TestportParameterSectionHandler.TestportParameter testportParameter = (TestportParameterSectionHandler.TestportParameter)selection.getFirstElement();
                if (testportParameter != null) {
                    if (testportParameter.getValue() != null) {
                        if (testportParameter.getValue().getText().length() == 0) {
                            String temp = ConfigTreeNodeUtilities.toString((ParseTree)testportParameter.getValue());
                            ConfigTreeNodeUtilities.setText((ParseTree)testportParameter.getValue(), (String)temp);
                        }
                        TestportParametersSectionPage.this.parameterValueText.setText(testportParameter.getValue().getText());
                    }
                    TestportParametersSectionPage.this.valueChanged = true;
                }
                TestportParametersSectionPage.this.parameterValueText.setEnabled(TestportParametersSectionPage.this.testportParametersHandler != null && testportParameter != null);
            }
        });
        this.testportParametersTableViewer.setContentProvider((IContentProvider)new TestportParameterDataContentProvider());
        this.testportParametersTableViewer.setLabelProvider((IBaseLabelProvider)new TestportParameterDataLabelProvider());
        this.testportParametersTableViewer.setInput((Object)this.testportParametersHandler);
        this.testportParametersTableViewer.setColumnProperties(this.columnNames);
        this.testportParametersTableViewer.setCellEditors((CellEditor[])new TextCellEditor[]{new TextCellEditor((Composite)this.testportParametersTable), new TextCellEditor((Composite)this.testportParametersTable), new TextCellEditor((Composite)this.testportParametersTable)});
        this.testportParametersTableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public String getValue(Object element, String property) {
                int columnIndex = Arrays.asList(TestportParametersSectionPage.this.columnNames).indexOf(property);
                TestportParameterDataLabelProvider labelProvider = (TestportParameterDataLabelProvider)TestportParametersSectionPage.this.testportParametersTableViewer.getLabelProvider();
                return labelProvider.getColumnText(element, columnIndex);
            }

            public void modify(Object element, String property, Object value) {
                int columnIndex = Arrays.asList(TestportParametersSectionPage.this.columnNames).indexOf(property);
                if (element != null && element instanceof TableItem && value instanceof String) {
                    TestportParameterSectionHandler.TestportParameter testportParameter = (TestportParameterSectionHandler.TestportParameter)((TableItem)element).getData();
                    switch (columnIndex) {
                        case 0: {
                            ConfigTreeNodeUtilities.setText((ParseTree)testportParameter.getComponentName(), (String)((String)value).trim());
                            break;
                        }
                        case 1: {
                            ConfigTreeNodeUtilities.setText((ParseTree)testportParameter.getTestportName(), (String)((String)value).trim());
                            break;
                        }
                        case 2: {
                            ConfigTreeNodeUtilities.setText((ParseTree)testportParameter.getParameterName(), (String)((String)value).trim());
                            break;
                        }
                    }
                    TestportParametersSectionPage.this.testportParametersTableViewer.refresh((Object)testportParameter);
                    TestportParametersSectionPage.this.editor.setDirty();
                }
            }
        });
        this.testportParametersTableViewer.addDragSupport(3, new Transfer[]{TestportParameterTransfer.getInstance()}, (DragSourceListener)new TestportParameterSectionDragSourceListener(this, this.testportParametersTableViewer));
        this.testportParametersTableViewer.addDropSupport(3, new Transfer[]{TestportParameterTransfer.getInstance()}, (DropTargetListener)new TestportParameterSectionDropTargetListener(this.testportParametersTableViewer, this.editor));
    }

    private void createDetailsPart(Composite parent, final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        client.setLayout((Layout)layout);
        this.parameterValueText = toolkit.createText(client, "", 2050);
        this.parameterValueText.setLayoutData((Object)new GridData(1808));
        this.parameterValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StructuredSelection selection = (StructuredSelection)TestportParametersSectionPage.this.testportParametersTableViewer.getSelection();
                Iterator iterator = selection.iterator();
                if (!iterator.hasNext()) {
                    return;
                }
                TestportParameterSectionHandler.TestportParameter testportParameter = (TestportParameterSectionHandler.TestportParameter)iterator.next();
                ConfigTreeNodeUtilities.setText((ParseTree)testportParameter.getValue(), (String)TestportParametersSectionPage.this.parameterValueText.getText());
                if (TestportParametersSectionPage.this.valueChanged) {
                    TestportParametersSectionPage.this.valueChanged = false;
                    return;
                }
                TestportParametersSectionPage.this.editor.setDirty();
            }
        });
        this.parameterValueText.setEnabled(this.testportParametersHandler != null);
        section.setText("Testport parameter details");
        section.setDescription("Specify the concrete value for the actually selected testport parameter.");
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
    }

    private void internalRefresh() {
        StructuredSelection selection = (StructuredSelection)this.testportParametersTableViewer.getSelection();
        Iterator iterator = selection.iterator();
        if (iterator.hasNext()) {
            this.valueChanged = true;
        } else {
            this.parameterValueText.setText("");
        }
        this.add.setEnabled(this.testportParametersHandler != null);
        this.remove.setEnabled(this.testportParametersHandler != null);
        this.testportParametersTableViewer.setInput((Object)this.testportParametersHandler);
        this.testportParametersTable.setEnabled(this.testportParametersHandler != null);
        this.parameterValueText.setEnabled(this.testportParametersHandler != null && selection.size() == 1);
        if (this.testportParametersHandler != null) {
            this.totalTestportParametersLabel.setText("Total: " + this.testportParametersHandler.getTestportParameters().size());
        }
    }

    public void refreshData(TestportParameterSectionHandler testportParametersHandler) {
        this.testportParametersHandler = testportParametersHandler;
        if (this.testportParametersTableViewer != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TestportParametersSectionPage.this.internalRefresh();
                }
            });
        }
    }

    private void createNewTestportParameterSection() {
        if (this.testportParametersHandler == null) {
            return;
        }
        ParserRuleContext sectionRoot = new ParserRuleContext();
        this.testportParametersHandler.setLastSectionRoot((ParseTree)sectionRoot);
        AddedParseTree header = new AddedParseTree("\n[TESTPORT_PARAMETERS]");
        ConfigTreeNodeUtilities.addChild((ParseTree)sectionRoot, (ParseTree)header);
        ParserRuleContext root = this.editor.getParseTreeRoot();
        if (root != null) {
            root.addChild((RuleContext)sectionRoot);
        }
    }

    private TestportParameterSectionHandler.TestportParameter createNewParameter() {
        if (this.testportParametersHandler == null) {
            return null;
        }
        TestportParameterSectionHandler.TestportParameter newTestportParameter = new TestportParameterSectionHandler.TestportParameter();
        ParserRuleContext root = new ParserRuleContext();
        newTestportParameter.setRoot((ParseTree)root);
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree("\n"));
        newTestportParameter.setComponentName((ParseTree)new AddedParseTree("component_name"));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)newTestportParameter.getComponentName());
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree("."));
        newTestportParameter.setTestportName((ParseTree)new AddedParseTree("testport_name"));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)newTestportParameter.getTestportName());
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree("."));
        newTestportParameter.setParameterName((ParseTree)new AddedParseTree("parameter_name"));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)newTestportParameter.getParameterName());
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree(" := "));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree("\"value\""));
        return newTestportParameter;
    }

    private void removeTestportParameterSection() {
        if (this.testportParametersHandler == null || this.testportParametersHandler.getLastSectionRoot() == null) {
            return;
        }
        ConfigTreeNodeUtilities.removeChild((ParseTree)this.editor.getParseTreeRoot(), (ParseTree)this.testportParametersHandler.getLastSectionRoot());
        this.testportParametersHandler.setLastSectionRoot(null);
    }

    public void removeSelectedParameters() {
        if (this.testportParametersTableViewer == null || this.testportParametersHandler == null) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)this.testportParametersTableViewer.getSelection();
        for (TestportParameterSectionHandler.TestportParameter testportParameter : selection) {
            if (testportParameter == null) continue;
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.testportParametersHandler.getLastSectionRoot(), (ParseTree)testportParameter.getRoot());
            this.testportParametersHandler.getTestportParameters().remove(testportParameter);
        }
        this.testportParametersTableViewer.setSelection(null);
    }

    public void setActive(boolean active) {
        this.setErrorMessage();
        if (this.testportParametersTableViewer != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TestportParametersSectionPage.this.internalRefresh();
                }
            });
        }
        super.setActive(active);
    }

    public void setErrorMessage() {
        if (this.form != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TestportParametersSectionPage.this.editor.getErrorMessage() == null) {
                        TestportParametersSectionPage.this.form.getForm().setMessage(null, 0);
                    } else {
                        TestportParametersSectionPage.this.form.getForm().setMessage(TestportParametersSectionPage.this.editor.getErrorMessage(), 3);
                    }
                    TestportParametersSectionPage.this.form.getForm().getHead().layout();
                    TestportParametersSectionPage.this.form.getForm().getHead().redraw();
                }
            });
        }
    }
}

