/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Timer;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Keywords;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3ReferenceParser;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public final class ContentAssistProcessor
implements IContentAssistProcessor {
    private final AbstractDecoratedTextEditor editor;
    private final String sortingpolicy;

    public ContentAssistProcessor(AbstractDecoratedTextEditor editor) {
        this.editor = editor;
        this.sortingpolicy = Activator.getDefault().getPreferenceStore().getString("org.eclipse.titan.designer.proposalSorting");
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IPreferencesService prefs;
        if (this.editor == null) {
            return new ICompletionProposal[0];
        }
        IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            return new ICompletionProposal[0];
        }
        TTCN3ReferenceParser refParser = new TTCN3ReferenceParser(true);
        IDocument doc = viewer.getDocument();
        Reference ref = refParser.findReferenceForCompletion(file, offset, doc);
        if (ref == null || ref.getSubreferences().isEmpty()) {
            return new ICompletionProposal[0];
        }
        Scope scope = null;
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module tempModule = projectSourceParser.containedModule(file);
        String moduleName = null;
        if (tempModule != null) {
            moduleName = tempModule.getName();
            scope = tempModule.getSmallestEnclosingScope(refParser.getReplacementOffset());
            ref.setMyScope(scope);
            ref.detectModid();
        }
        if ((prefs = Platform.getPreferencesService()).getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            TITANDebugConsole.println("parsed the reference: " + ref);
        }
        TemplateContextType contextType = new TemplateContextType("TTCN3_SOURCE_CODE", "TTCN3 Code Skeleton Context");
        ProposalCollector propCollector = new ProposalCollector(Identifier.Identifier_type.ID_TTCN, "TTCN3_SOURCE_CODE", contextType, doc, ref, refParser.getReplacementOffset());
        propCollector.setProjectParser(projectSourceParser);
        if (moduleName == null) {
            if (ref.getModuleIdentifier() == null) {
                Set<String> moduleNames = projectSourceParser.getKnownModuleNames();
                for (String name : moduleNames) {
                    Module module = projectSourceParser.getModuleByName(name);
                    if (module == null) continue;
                    propCollector.addProposal(name, name, ImageCache.getImage("ttcn.gif"), "module");
                    module.getAssignments().addProposal(propCollector);
                }
            } else {
                Module module = projectSourceParser.getModuleByName(ref.getModuleIdentifier().getName());
                if (module != null) {
                    module.getAssignments().addProposal(propCollector);
                }
            }
        } else if (scope != null) {
            scope.addProposal(propCollector);
        }
        propCollector.sortTillMarked();
        propCollector.markPosition();
        if (ref.getSubreferences().size() != 1) {
            if ("alphabetically".equals(this.sortingpolicy)) {
                propCollector.sortAll();
            }
            return propCollector.getCompletitions();
        }
        Set<String> knownModuleNames = projectSourceParser.getKnownModuleNames();
        for (String knownModuleName : knownModuleNames) {
            Identifier tempIdentifier = new Identifier(Identifier.Identifier_type.ID_NAME, knownModuleName);
            Module tempModule2 = projectSourceParser.getModuleByName(knownModuleName);
            propCollector.addProposal(tempIdentifier, ImageCache.getImage(tempModule2.getOutlineIcon()), "module");
        }
        propCollector.sortTillMarked();
        propCollector.markPosition();
        if (ref.getModuleIdentifier() == null) {
            if (scope == null) {
                TTCN3CodeSkeletons.addSkeletonProposals(doc, refParser.getReplacementOffset(), propCollector);
            } else {
                scope.addSkeletonProposal(propCollector);
            }
            propCollector.addTemplateProposal("refers", new Template("refers( function/altstep/testcase name )", "", propCollector.getContextIdentifier(), "refers( ${fatName} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("derefers", new Template("derefers( function/altstep/testcase name )(parameters)", "", propCollector.getContextIdentifier(), "derefers( ${fatName} ) ( ${parameters} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.sortTillMarked();
            propCollector.markPosition();
            TTCN3CodeSkeletons.addPredefinedSkeletonProposals(doc, refParser.getReplacementOffset(), propCollector);
            if (scope == null) {
                TTCN3Keywords.addKeywordProposals(propCollector);
            } else {
                scope.addKeywordProposal(propCollector);
            }
            propCollector.sortTillMarked();
            propCollector.markPosition();
        } else {
            if (scope == null || !(scope instanceof StatementBlock)) {
                if ("alphabetically".equals(this.sortingpolicy)) {
                    propCollector.sortAll();
                }
                return propCollector.getCompletitions();
            }
            String fakeModule = ref.getModuleIdentifier().getName();
            if ("any component".equals(fakeModule) || "all component".equals(fakeModule)) {
                Component_Type.addAnyorAllProposal(propCollector, 0);
            } else if ("any port".equals(fakeModule) || "all port".equals(fakeModule)) {
                PortTypeBody.addAnyorAllProposal(propCollector, 0);
            } else if ("any timer".equals(fakeModule) || "all timer".equals(fakeModule)) {
                Timer.addAnyorAllProposal(propCollector, 0);
            }
        }
        if ("alphabetically".equals(this.sortingpolicy)) {
            propCollector.sortAll();
        }
        return propCollector.getCompletitions();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return new ContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

