/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.parsers.GlobalParser;

public final class OutdatedFileCollector
implements IResourceVisitor {
    public static final String TRUE = "true";
    private static final String DOT = ".";
    private String resourcename;
    private Map<IFile, String> uptodateFiles;
    private Set<IFile> highlySyntaxErroneousFiles;
    private List<IFile> asn1FilesToCheck;
    private List<IFile> cfgFilesToCheck;
    private List<IFile> ttcn3FilesToCheck;
    private List<IFile> ttcninFilesModified;
    private final IContainer[] workingDirectories;
    private ResourceExclusionHelper helper;

    public OutdatedFileCollector(IContainer[] workingDirectories, Map<IFile, String> uptodateFiles, Set<IFile> highlySyntaxErroneousFiles) {
        this.uptodateFiles = uptodateFiles;
        this.highlySyntaxErroneousFiles = highlySyntaxErroneousFiles;
        this.asn1FilesToCheck = new ArrayList<IFile>();
        this.cfgFilesToCheck = new ArrayList<IFile>();
        this.ttcn3FilesToCheck = new ArrayList<IFile>();
        this.ttcninFilesModified = new ArrayList<IFile>();
        this.workingDirectories = workingDirectories;
        this.helper = new ResourceExclusionHelper();
    }

    public List<IFile> getASN1FilesToCheck() {
        return this.asn1FilesToCheck;
    }

    public List<IFile> getCFGFilesToCheck() {
        return this.cfgFilesToCheck;
    }

    public List<IFile> getTTCN3FilesToCheck() {
        return this.ttcn3FilesToCheck;
    }

    public List<IFile> getTtcninFilesModified() {
        return this.ttcninFilesModified;
    }

    public boolean visit(IResource resource) {
        if (resource == null || !resource.isAccessible()) {
            return false;
        }
        this.resourcename = resource.getName();
        if (this.resourcename == null || this.resourcename.startsWith(DOT)) {
            return false;
        }
        switch (resource.getType()) {
            case 1: {
                IFile file = (IFile)resource;
                String extension = file.getFileExtension();
                if (ResourceExclusionHelper.isDirectlyExcluded((IFile)resource) || this.uptodateFiles.containsKey(file) || this.highlySyntaxErroneousFiles.contains(file) || this.helper.isExcludedByRegexp(this.resourcename)) break;
                if (GlobalParser.isSupportedTTCN3Extension(extension)) {
                    this.ttcn3FilesToCheck.add(file);
                    break;
                }
                if (GlobalParser.SUPPORTED_CONFIG_FILE_EXTENSIONS[0].equals(extension)) {
                    this.cfgFilesToCheck.add(file);
                    break;
                }
                if (GlobalParser.SUPPORTED_ASN1_EXTENSIONS[0].equals(extension) || GlobalParser.SUPPORTED_ASN1_EXTENSIONS[1].equals(extension)) {
                    this.asn1FilesToCheck.add(file);
                    break;
                }
                if (!"ttcnin".equals(extension)) break;
                this.ttcninFilesModified.add(file);
                break;
            }
            case 2: {
                for (IContainer workingDirectory : this.workingDirectories) {
                    if (!workingDirectory.equals(resource)) continue;
                    return false;
                }
                if (!ResourceExclusionHelper.isDirectlyExcluded((IFolder)resource) && !this.helper.isExcludedByRegexp(this.resourcename)) break;
                return false;
            }
        }
        return true;
    }
}

