/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.applications;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.wizards.GUIProjectImporter;

public class ImportProjectsFromPrj
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        Platform.getBundle((String)"org.eclipse.titan.designer").start();
        String[] projectFiles = (String[])context.getArguments().get("application.args");
        if (projectFiles.length != 1) {
            System.out.println("This application takes as parameter the location of the prj file it should load projects from.");
            return -1;
        }
        boolean result = true;
        try {
            if (Activator.getDefault() != null) {
                Activator.getDefault().pauseHandlingResourceChanges();
            }
            System.out.println("Importing from prj");
            result = GUIProjectImporter.importProjectfromPrj((String)projectFiles[0]);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)("Error while importing from prj " + projectFiles[0]), (Throwable)e);
        }
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while closing workspace", (Throwable)e);
            result = false;
        }
        if (result) {
            return EXIT_OK;
        }
        return -1;
    }

    public void stop() {
    }
}

