/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.clustering.gui;

import edu.uci.ics.jung.algorithms.layout.AggregateLayout;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Set;
import org.apache.commons.collections15.Transformer;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public final class ClusterTransformer
implements Transformer<NodeDescriptor, Point2D> {
    protected AggregateLayout<NodeDescriptor, EdgeDescriptor> mainLayout;
    protected Set<Set<NodeDescriptor>> clusters;

    public ClusterTransformer(Layout<NodeDescriptor, EdgeDescriptor> subLayouts, Set<Set<NodeDescriptor>> clusters, Dimension extSize) {
        this.mainLayout = new AggregateLayout(subLayouts);
        this.clusters = clusters;
        this.mainLayout.setSize(extSize);
        for (Set<NodeDescriptor> clust : clusters) {
            this.groupCluster(clust);
        }
    }

    protected void groupCluster(Set<NodeDescriptor> vertices) {
        if (vertices.size() < this.mainLayout.getGraph().getVertexCount()) {
            Point2D center = this.mainLayout.transform((Object)vertices.iterator().next());
            DirectedSparseGraph subGraph = new DirectedSparseGraph();
            for (NodeDescriptor v : vertices) {
                subGraph.addVertex((Object)v);
            }
            CircleLayout subLayout = new CircleLayout((Graph)subGraph);
            subLayout.setInitializer(this.mainLayout);
            Dimension canvasSize = new Dimension(100, 100);
            subLayout.setSize(canvasSize);
            this.mainLayout.put((Layout)subLayout, center);
        }
    }

    public Point2D transform(NodeDescriptor v) {
        return this.mainLayout.transform((Object)v);
    }
}

