/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.visualization;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.io.PajekNetWriter;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.collections15.Transformer;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.error.GUIErrorHandler;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.EdgeStroke;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.gui.common.CustomSatelliteViewer;
import org.eclipse.titanium.graph.gui.common.CustomVisualizationViewer;
import org.eclipse.titanium.graph.gui.common.Layouts;
import org.eclipse.titanium.graph.gui.menus.NodePopupMenu;
import org.eclipse.titanium.graph.gui.utils.LayoutEntry;
import org.eclipse.titanium.graph.utils.GraphVizWriter;
import org.eclipse.titanium.graph.visualization.BadLayoutException;
import org.eclipse.titanium.graph.visualization.ErrorType;
import org.eclipse.titanium.graph.visualization.GraphRenderer;
import org.eclipse.titanium.graph.visualization.LayoutBuilder;
import org.eclipse.titanium.metrics.IMetricEnum;

public class GraphHandler {
    private DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> g;
    private static final Transformer<NodeDescriptor, String> NODE_LABELER = new ToStringLabeller();
    private CustomVisualizationViewer actVisualisator;
    private Layout<NodeDescriptor, EdgeDescriptor> layout;
    private GraphRenderer<NodeDescriptor, EdgeDescriptor> renderer;
    protected NodePopupMenu popupMenu = new NodePopupMenu(this);
    protected IMetricEnum chosenLayoutMetric = null;
    private CustomSatelliteViewer satView;
    private Set<Set<NodeDescriptor>> clusters;

    public void changeLayout(LayoutEntry newLayout, Dimension newWindowSize) throws BadLayoutException {
        if (this.g == null) {
            throw new BadLayoutException("You must draw a graph before!", ErrorType.NO_OBJECT);
        }
        Dimension extSize = null;
        extSize = this.g.getVertexCount() >= 20 ? new Dimension(newWindowSize.height * (this.g.getVertexCount() / 20), newWindowSize.width * (this.g.getVertexCount() / 20)) : newWindowSize;
        this.layout = new LayoutBuilder(this.g, newLayout, extSize).clusters(this.clusters).build();
        this.actVisualisator = new CustomVisualizationViewer(this.layout, this.popupMenu);
        this.actVisualisator.setPreferredSize(new Dimension(newWindowSize.width, newWindowSize.height));
        this.actVisualisator.getRenderContext().setVertexLabelTransformer(NODE_LABELER);
        GraphRenderer<NodeDescriptor, EdgeDescriptor> rnd = new GraphRenderer<NodeDescriptor, EdgeDescriptor>(NODE_LABELER, this.actVisualisator.getPickedVertexState(), this.actVisualisator.getPickedEdgeState());
        GraphHandler.setNodeRenderer(rnd, this.actVisualisator);
        this.renderer = rnd;
        this.actVisualisator.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.actVisualisator.setBackground(Color.white);
        this.actVisualisator.setDoubleBuffered(false);
        this.initSatView();
    }

    public void drawGraph(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> g, Dimension windowSize, LayoutEntry layout) throws BadLayoutException {
        if (g == null) {
            throw new BadLayoutException("There is no graph (it is set null)", ErrorType.NO_OBJECT);
        }
        if (g.getVertexCount() == 0) {
            throw new BadLayoutException("The graph doesn't contain any node", ErrorType.EMPTY_GRAPH);
        }
        this.g = g;
        this.changeLayout(layout, windowSize);
    }

    public static void saveGraphToPajek(Graph<NodeDescriptor, EdgeDescriptor> g, String path) throws BadLayoutException {
        if (g == null) {
            throw new BadLayoutException("You must draw a graph before!", ErrorType.NO_OBJECT);
        }
        Transformer<EdgeDescriptor, Number> edgeWeights = new Transformer<EdgeDescriptor, Number>(){

            public Number transform(EdgeDescriptor e) {
                return e.getWeight();
            }
        };
        try {
            PajekNetWriter writer = new PajekNetWriter();
            writer.save(g, path, NODE_LABELER, (Transformer)edgeWeights);
        }
        catch (IOException e) {
            throw new BadLayoutException("An error occured during writing to the output file.", ErrorType.IO_ERROR, e);
        }
    }

    public static void saveGraphToDot(Graph<NodeDescriptor, EdgeDescriptor> g, String path, String graphName) throws BadLayoutException {
        if (g == null) {
            throw new BadLayoutException("You must draw a graph before!", ErrorType.NO_OBJECT);
        }
        try {
            new GraphVizWriter<NodeDescriptor, EdgeDescriptor>().save(g, path, NODE_LABELER, graphName);
        }
        catch (IOException e) {
            throw new BadLayoutException("An error occured during writing to the output file!", ErrorType.IO_ERROR, e);
        }
    }

    public void saveToImage(String path, ImageExportType mode) throws BadLayoutException {
        BufferedImage image;
        if (this.layout == null || this.actVisualisator == null) {
            throw new BadLayoutException("Either the layout or the visuaizer is not set (is null)", ErrorType.NO_OBJECT);
        }
        Object tempVisualisator = null;
        Dimension size = null;
        switch (mode) {
            case EXPORT_SEEN_GRAPH: {
                tempVisualisator = this.actVisualisator;
                size = this.actVisualisator.getPreferredSize();
                break;
            }
            case EXPORT_WHOLE_GRAPH: {
                this.layout = this.actVisualisator.getGraphLayout();
                if (size == null) {
                    size = new Dimension(this.layout.getSize().width, this.layout.getSize().height);
                }
                Transformer<NodeDescriptor, Point2D> trf = new Transformer<NodeDescriptor, Point2D>(){

                    public Point2D transform(NodeDescriptor v) {
                        return (Point2D)GraphHandler.this.layout.transform((Object)v);
                    }
                };
                tempVisualisator = new VisualizationViewer(new LayoutBuilder(this.g, Layouts.LAYOUT_STATIC, size).transformer(trf).build());
                tempVisualisator.setPreferredSize(size);
                tempVisualisator.setSize(size);
                tempVisualisator.getRenderContext().setVertexLabelTransformer(NODE_LABELER);
                GraphRenderer<NodeDescriptor, EdgeDescriptor> rnd = new GraphRenderer<NodeDescriptor, EdgeDescriptor>(NODE_LABELER, tempVisualisator.getPickedVertexState(), tempVisualisator.getPickedEdgeState());
                GraphHandler.setNodeRenderer(rnd, tempVisualisator);
                tempVisualisator.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
                tempVisualisator.setBackground(Color.white);
                tempVisualisator.setDoubleBuffered(false);
                break;
            }
            case EXPORT_SATELLITE: {
                tempVisualisator = this.satView;
                size = tempVisualisator.getSize();
                break;
            }
            default: {
                ErrorReporter.logError((String)("Unexpected image export type " + (Object)((Object)mode)));
                return;
            }
        }
        GUIErrorHandler errorHandler = new GUIErrorHandler();
        try {
            image = new BufferedImage(size.width, size.height, 1);
        }
        catch (OutOfMemoryError e) {
            long needed = (long)size.width * (long)size.height * 4L;
            String temp = needed < 1024L ? needed + " bytes" : (needed < 0x100000L ? needed / 1024L + " Kbytes" : needed / 1024L / 1024L + " Mbytes");
            String errorText = "Could not save an image of " + size.width + "*" + size.height + " size as there was not enough free memory (" + temp + ")";
            errorHandler.reportErrorMessage(errorText);
            ErrorReporter.logExceptionStackTrace((String)errorText, (Throwable)e);
            return;
        }
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        tempVisualisator.paint(g2);
        g2.dispose();
        try {
            ImageIO.write((RenderedImage)image, "png", new File(path));
        }
        catch (IOException e) {
            String message = "Error while writing to file" + path;
            ErrorReporter.logExceptionStackTrace((String)message, (Throwable)e);
            errorHandler.reportException(message, e);
        }
    }

    public static void setNodeRenderer(GraphRenderer<NodeDescriptor, EdgeDescriptor> rnd, VisualizationViewer<NodeDescriptor, EdgeDescriptor> visualisator) {
        if (visualisator == null || rnd == null) {
            return;
        }
        visualisator.getRenderContext().setVertexShapeTransformer(rnd.getShape());
        visualisator.getRenderContext().setVertexFillPaintTransformer(rnd.getVertexColour());
        visualisator.getRenderContext().setVertexLabelRenderer(rnd.getFont());
        visualisator.getRenderContext().setEdgeDrawPaintTransformer(rnd.getEdgeColour());
        visualisator.getRenderContext().setArrowFillPaintTransformer(rnd.getEdgeColour());
        visualisator.getRenderContext().setArrowDrawPaintTransformer(rnd.getEdgeColour());
        EdgeStroke stroke = new EdgeStroke();
        visualisator.getRenderContext().setEdgeStrokeTransformer(stroke);
    }

    public void changeWindowSize(Dimension newSize) {
        if (this.actVisualisator != null) {
            this.actVisualisator.setPreferredSize(new Dimension(newSize.width, newSize.height));
        }
    }

    public CustomSatelliteViewer getSatelliteViewer() {
        return this.satView;
    }

    private void initSatView() {
        if (this.actVisualisator == null) {
            return;
        }
        this.satView = new CustomSatelliteViewer(this.actVisualisator);
        this.satView.getRenderContext().setVertexLabelTransformer(NODE_LABELER);
        this.satView.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.satView.getRenderContext().setVertexShapeTransformer(this.renderer.getShape());
        this.satView.getRenderContext().setVertexFillPaintTransformer(this.renderer.getVertexColour());
        this.satView.scaleToLayout((ScalingControl)new CrossoverScalingControl());
    }

    public CustomVisualizationViewer getVisualizator() {
        return this.actVisualisator;
    }

    public void zoom(float scale) {
        if (this.actVisualisator == null) {
            return;
        }
        CrossoverScalingControl control = new CrossoverScalingControl();
        control.scale((VisualizationServer)this.actVisualisator, scale, this.actVisualisator.getCenter());
    }

    public void setClusters(Set<Set<NodeDescriptor>> clusters) {
        this.clusters = clusters;
    }

    public void setMenusEnabled(boolean value) {
        if (this.popupMenu == null) {
            return;
        }
        this.popupMenu.enableGoToDefinition(value);
    }

    public static enum ImageExportType {
        EXPORT_WHOLE_GRAPH,
        EXPORT_SEEN_GRAPH,
        EXPORT_SATELLITE;

    }
}

