/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.titanium.error.GUIErrorHandler;
import org.eclipse.titanium.gui.Searchable;
import org.eclipse.titanium.swt.SWTResourceManager;

public class FindWindow<T extends Comparable>
extends Dialog {
    protected Shell shlFind;
    private static final Dimension EXT_SIZE = new Dimension(344, 317);
    private static final Dimension NORM_SIZE = new Dimension(344, 135);
    private final Searchable<T> view;
    private final Collection<T> totalSet;
    private Label label;
    private Label lblResults;
    private Tree tree;
    private SortedSet<T> treeItems;
    protected final GUIErrorHandler errorHandler = new GUIErrorHandler();

    public FindWindow(Shell parent, Searchable<T> view, Collection<T> totalList) throws IllegalArgumentException {
        super(parent);
        if (view == null) {
            throw new IllegalArgumentException("The totalList parameter of FindWindow's constructor mustn't be null!");
        }
        if (totalList == null) {
            throw new IllegalArgumentException("The totalList parameter of FindWindow's constructor mustn't be null!");
        }
        this.view = view;
        this.treeItems = new TreeSet<T>();
        this.totalSet = totalList;
        this.setText("Find");
    }

    public void open() {
        this.createContents();
        this.shlFind.open();
        this.shlFind.layout();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.shlFind.setLocation(new Point(screenSize.width / 2, 20));
        this.lblResults = new Label((Composite)this.shlFind, 0);
        this.lblResults.setBounds(10, 108, 40, 15);
        this.lblResults.setText("Results:");
        this.label = new Label((Composite)this.shlFind, 0x1000102);
        this.label.setBounds(10, 94, 323, 21);
        this.tree = new Tree((Composite)this.shlFind, 2048);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindWindow.this.view.elemChosen((Comparable)FindWindow.this.tree.getSelection()[0].getData());
            }
        });
        this.tree.setBounds(10, 129, 318, 149);
        this.showResultTable(false);
        Display display = this.getParent().getDisplay();
        while (!this.shlFind.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.view.clearResults();
    }

    public void close() {
        this.view.clearResults();
        if (!this.shlFind.isDisposed()) {
            this.shlFind.close();
        }
    }

    private void createContents() {
        this.shlFind = new Shell(this.getParent(), 96);
        this.shlFind.setModified(true);
        this.shlFind.setImage(SWTResourceManager.getImage("resources/icons/search_src.gif"));
        this.shlFind.setSize(FindWindow.EXT_SIZE.width, FindWindow.EXT_SIZE.height);
        this.shlFind.setText("Find");
        this.shlFind.setLayout(null);
        final Text text = new Text((Composite)this.shlFind, 2048);
        text.setBounds(10, 23, 323, 21);
        final Button btnExactMatch = new Button((Composite)this.shlFind, 32);
        btnExactMatch.setBounds(10, 50, 93, 16);
        btnExactMatch.setText("Exact match");
        final Button btnCaseSensitive = new Button((Composite)this.shlFind, 32);
        btnCaseSensitive.setBounds(10, 72, 93, 16);
        btnCaseSensitive.setText("Case sensitive");
        Button btnFind = new Button((Composite)this.shlFind, 0);
        btnFind.setBounds(258, 68, 75, 25);
        btnFind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = text.getText();
                boolean exactMatch = btnExactMatch.getSelection();
                boolean caseSensitive = btnCaseSensitive.getSelection();
                boolean noResult = true;
                if (!caseSensitive) {
                    name = name.toLowerCase();
                }
                for (Comparable actElem : FindWindow.this.totalSet) {
                    String elemName = actElem.toString();
                    if (!caseSensitive) {
                        elemName = elemName.toLowerCase();
                    }
                    if (!exactMatch && elemName.contains(name)) {
                        FindWindow.this.treeItems.add(actElem);
                        continue;
                    }
                    if (!exactMatch || !elemName.equals(name)) continue;
                    FindWindow.this.treeItems.add(actElem);
                }
                for (Comparable actElem : FindWindow.this.treeItems) {
                    TreeItem item = new TreeItem(FindWindow.this.tree, 0);
                    item.setText(actElem.toString());
                    item.setData((Object)actElem);
                    noResult = false;
                }
                if (noResult) {
                    FindWindow.this.errorHandler.reportInformation("The search hasn't found such node!");
                } else {
                    FindWindow.this.showResultTable(true);
                }
            }
        });
        btnFind.setText("Find");
        Label nameLabel = new Label((Composite)this.shlFind, 0);
        nameLabel.setBounds(10, 2, 283, 15);
        nameLabel.setText("Name: ");
        Button btnClearResult = new Button((Composite)this.shlFind, 0);
        btnClearResult.setBounds(177, 68, 75, 25);
        btnClearResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindWindow.this.showResultTable(false);
                FindWindow.this.view.clearResults();
            }
        });
        btnClearResult.setText("Clear result");
    }

    private void showResultTable(boolean show) {
        if (show) {
            this.shlFind.setSize(FindWindow.EXT_SIZE.width, FindWindow.EXT_SIZE.height);
        } else {
            this.shlFind.setSize(FindWindow.NORM_SIZE.width, FindWindow.NORM_SIZE.height);
            this.tree.removeAll();
            this.treeItems.clear();
        }
        this.tree.setVisible(show);
        this.lblResults.setVisible(show);
        this.label.setVisible(show);
    }
}

