/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.titanium.markers.handler.Marker;
import org.eclipse.titanium.markers.types.CodeSmellType;

public final class MarkerHandler {
    private final Map<IResource, List<Marker>> markersByResource = new HashMap<IResource, List<Marker>>();
    private final Map<CodeSmellType, List<Marker>> markersByType;

    public MarkerHandler(Map<IResource, List<Marker>> markers) {
        for (Map.Entry<IResource, List<Marker>> entry : markers.entrySet()) {
            for (Marker m : entry.getValue()) {
                IResource belongsTo = m.getResource();
                if (belongsTo == null) {
                    belongsTo = entry.getKey();
                }
                if (this.markersByResource.get(belongsTo) == null) {
                    this.markersByResource.put(belongsTo, new ArrayList());
                }
                this.markersByResource.get(belongsTo).add(m);
            }
        }
        this.markersByType = new HashMap<CodeSmellType, List<Marker>>();
    }

    public List<Marker> get(IResource res) {
        return this.markersByResource.get(res) == null ? Collections.emptyList() : Collections.unmodifiableList(this.markersByResource.get(res));
    }

    public List<Marker> get(CodeSmellType type) {
        if (this.markersByType.isEmpty()) {
            this.lazyInit();
        }
        return Collections.unmodifiableList(this.markersByType.get(type));
    }

    public int numberOfOccurrences(CodeSmellType type) {
        if (this.markersByType.isEmpty()) {
            this.lazyInit();
        }
        return this.markersByType.get(type).size();
    }

    private synchronized void lazyInit() {
        for (CodeSmellType type : CodeSmellType.values()) {
            this.markersByType.put(type, new ArrayList());
        }
        for (IResource res : this.markersByResource.keySet()) {
            for (Marker m : this.markersByResource.get(res)) {
                this.markersByType.get(m.getProblemType()).add(m);
            }
        }
    }

    public void show(IResource res) {
        this.refresh(res);
    }

    public void showAll() {
        for (IResource res : this.markersByResource.keySet()) {
            this.refresh(res);
        }
    }

    private void refresh(IResource res) {
        org.eclipse.titan.designer.AST.MarkerHandler.markMarkersForRemoval((String)"org.eclipse.titanium.markers.CodeSmellMarker", (IResource)res);
        List<Marker> markers = this.markersByResource.get(res);
        if (markers != null) {
            for (Marker m : markers) {
                m.show();
            }
        }
        org.eclipse.titan.designer.AST.MarkerHandler.removeMarkedMarkers((String)"org.eclipse.titanium.markers.CodeSmellMarker", (IResource)res);
    }

    public Map<IResource, List<Marker>> getMarkersByResource() {
        return this.markersByResource;
    }
}

