/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.preferences;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.preferences.PreferenceManager;
import org.eclipse.titanium.metrics.preferences.RiskMethod;
import org.eclipse.titanium.metrics.preferences.SimpleRiskFieldEditor;

public class InstabilityRiskFieldEditor
extends SimpleRiskFieldEditor {
    public InstabilityRiskFieldEditor(Composite parent, IMetricEnum owner) {
        super(parent, owner);
    }

    @Override
    public void store() {
        Number[] n = new Number[this.spinners.length];
        for (int i = 0; i < this.spinners.length; ++i) {
            n[i] = new Double((double)this.spinners[i].getSelection() / 100.0);
        }
        PreferenceManager.storeRisk(this.owner, this.old, n);
    }

    @Override
    protected void updateSpinners(RiskMethod m, boolean toDefault) {
        for (Spinner s : this.spinners) {
            s.dispose();
        }
        Number[] limits = this.getLimits(m, toDefault);
        switch (m) {
            case NEVER: {
                this.spinners = new Spinner[0];
                break;
            }
            case NO_HIGH: 
            case NO_LOW: {
                this.spinners = new Spinner[1];
                this.spinners[0] = new Spinner(this.shell, 0);
                this.spinners[0].setDigits(2);
                this.spinners[0].setMaximum(50);
                this.spinners[0].setSelection((int)Math.round(limits[0].doubleValue() * 100.0));
                this.spinners[0].addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        InstabilityRiskFieldEditor.this.firePropChanged();
                    }
                });
                break;
            }
            case NO_LOW_HIGH: {
                this.spinners = new Spinner[2];
                for (int i = 0; i < 2; ++i) {
                    this.spinners[i] = new Spinner(this.shell, 0);
                    this.spinners[i].setDigits(2);
                    this.spinners[i].setMaximum(50);
                    this.spinners[i].setSelection((int)Math.round(limits[i].doubleValue() * 100.0));
                    this.spinners[i].addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            InstabilityRiskFieldEditor.this.firePropChanged();
                        }
                    });
                }
                break;
            }
        }
        this.postUpdateSpinners();
    }
}

