/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.refactoring.CreateHeaderChangeOperation;

public class FindReferenceOperation
implements IWorkspaceRunnable {
    private BundleDescription fDesc;
    private String fNewId;
    private Change[] fChanges;

    public FindReferenceOperation(BundleDescription desc, String newId) {
        this.fDesc = desc;
        this.fNewId = newId;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        ArrayList<TextFileChange> list = new ArrayList<TextFileChange>();
        if (this.fDesc != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            this.findRequireBundleReferences(list, (IProgressMonitor)subMonitor.split(1));
            this.findFragmentReferences(list, (IProgressMonitor)subMonitor.split(1));
            this.findXFriendReferences(list, (IProgressMonitor)subMonitor.split(1));
        }
        this.fChanges = list.toArray(new Change[list.size()]);
    }

    public Change[] getChanges() {
        return this.fChanges;
    }

    private void findRequireBundleReferences(ArrayList<TextFileChange> changes, IProgressMonitor monitor) throws CoreException {
        String oldId = this.fDesc.getSymbolicName();
        BundleDescription[] dependents = this.fDesc.getDependents();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)dependents.length);
        int i = 0;
        while (i < dependents.length) {
            BundleSpecification[] requires = dependents[i].getRequiredBundles();
            SubMonitor iterationMonitor = subMonitor.split(1);
            int j = 0;
            while (j < requires.length) {
                if (requires[j].getName().equals(oldId)) {
                    CreateHeaderChangeOperation op = new CreateHeaderChangeOperation(PluginRegistry.findModel((BundleDescription)dependents[i]), "Require-Bundle", oldId, this.fNewId);
                    op.run((IProgressMonitor)iterationMonitor);
                    TextFileChange change = op.getChange();
                    if (change == null) break;
                    changes.add(change);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void findFragmentReferences(ArrayList<TextFileChange> changes, IProgressMonitor monitor) throws CoreException {
        BundleDescription[] fragments = this.fDesc.getFragments();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)fragments.length);
        String id = this.fDesc.getSymbolicName();
        int i = 0;
        while (i < fragments.length) {
            IPluginModelBase base = PluginRegistry.findModel((BundleDescription)fragments[i]);
            SubMonitor iterationMonitor = subMonitor.split(1);
            if (base instanceof IFragmentModel && id.equals(((IFragmentModel)base).getFragment().getPluginId())) {
                CreateHeaderChangeOperation op = new CreateHeaderChangeOperation(base, "Fragment-Host", id, this.fNewId);
                op.run((IProgressMonitor)iterationMonitor);
                TextFileChange change = op.getChange();
                if (change != null) {
                    changes.add(change);
                }
            }
            ++i;
        }
    }

    private void findXFriendReferences(ArrayList<TextFileChange> changes, IProgressMonitor monitor) throws CoreException {
        StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
        ExportPackageDescription[] pkgs = helper.getVisiblePackages(this.fDesc);
        String id = this.fDesc.getSymbolicName();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)pkgs.length);
        int i = 0;
        while (i < pkgs.length) {
            SubMonitor iterationMonitor = subMonitor.split(1);
            String[] friends = (String[])pkgs[i].getDirective("x-friends");
            if (friends != null) {
                int j = 0;
                while (j < friends.length) {
                    if (friends[j].equals(id)) {
                        CreateHeaderChangeOperation op = new CreateHeaderChangeOperation(PluginRegistry.findModel((BundleDescription)pkgs[i].getExporter()), "Export-Package", id, this.fNewId);
                        op.run((IProgressMonitor)iterationMonitor);
                        TextFileChange change = op.getChange();
                        if (change == null) break;
                        changes.add(change);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

