/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.workflow;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.sew.launcher.workflow.IWorkflowConfigurationConstants;
import org.eclipse.efm.sew.launcher.workflow.SupervisorWorkerCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.Worker;
import org.eclipse.efm.sew.launcher.workflow.Workflow;
import org.eclipse.efm.sew.launcher.workflow.common.CommonFactory;
import org.eclipse.efm.sew.launcher.workflow.common.ConsoleLogFormatCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.DeveloperTuningOptionCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.ManifestCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.Project;
import org.eclipse.efm.sew.launcher.workflow.coverage.BehaviorCoverageWorkerCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.coverage.TransitionCoverageWorkerCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.impl.DirectorImpl;
import org.eclipse.efm.sew.launcher.workflow.impl.SerializerImpl;
import org.eclipse.efm.sew.launcher.workflow.serializer.BasicTraceSerializerWorkerCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.serializer.ModelGraphvizSerializerWorkerCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.serializer.SymbexGraphvizSerializerWorkerCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.serializer.TTCNTraceSerializerWorkerCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.test.OfflineTestWorkerCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.util.PrettyPrintWriter;

public class DirectorCustomImpl
extends DirectorImpl
implements IWorkflowConfigurationConstants {
    public DirectorCustomImpl(Workflow workflow) {
        this.setWorkflow(workflow);
    }

    public DirectorCustomImpl(Workflow workflow, String name) {
        this.setWorkflow(workflow);
        this.setName(name);
    }

    public static DirectorCustomImpl create(Workflow workflow, ILaunchConfiguration configuration, boolean hasSecond) {
        DirectorCustomImpl director = new DirectorCustomImpl(workflow);
        director.setManifest(ManifestCustomImpl.create(true, true));
        director.configureProject(configuration);
        director.configureMainWorker(configuration);
        director.configureSerializerWorker(configuration);
        if (!hasSecond) {
            director.configureSecondSerializerWorker(configuration, hasSecond);
        }
        director.configureDebugWorker(configuration);
        return director;
    }

    public boolean configureProject(ILaunchConfiguration configuration) {
        String modelPath;
        try {
            modelPath = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
            modelPath = null;
        }
        if (modelPath != null && !modelPath.isEmpty()) {
            Project project = CommonFactory.eINSTANCE.createProject();
            int pos = modelPath.lastIndexOf(47);
            if (pos > 0) {
                project.setSource(modelPath.substring(0, pos));
                modelPath = modelPath.substring(pos + 1);
            }
            project.setModel(modelPath);
            this.setProject(project);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean configureMainWorker(ILaunchConfiguration configuration) {
        String modelAnalysis;
        String analysisProfile;
        SupervisorWorkerCustomImpl supervisor = SupervisorWorkerCustomImpl.create(configuration);
        this.setDescription("of graph exploration");
        this.setSupervisor(supervisor);
        try {
            analysisProfile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYSIS_PROFILE", "MODEL");
        }
        catch (CoreException e) {
            e.printStackTrace();
            analysisProfile = "MODEL";
        }
        try {
            modelAnalysis = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_ANALYSIS", "Exploration");
        }
        catch (CoreException e) {
            e.printStackTrace();
            modelAnalysis = "Exploration";
        }
        switch (analysisProfile) {
            case "MODEL": {
                switch (modelAnalysis) {
                    case "Transition Coverage": {
                        TransitionCoverageWorkerCustomImpl worker = TransitionCoverageWorkerCustomImpl.create(this, configuration);
                        this.getWorker().add((Object)worker);
                        supervisor.getQueue().setHeuristic(true);
                        supervisor.getQueue().setWeight(8);
                        return true;
                    }
                    case "Behavior Selection": {
                        BehaviorCoverageWorkerCustomImpl worker = BehaviorCoverageWorkerCustomImpl.create(this, configuration);
                        this.getWorker().add((Object)worker);
                        supervisor.getQueue().setHeuristic(true);
                        return true;
                    }
                    default: {
                        return true;
                    }
                    case "Exploration": {
                        return true;
                    }
                }
            }
            case "TESTOFFLINE": {
                OfflineTestWorkerCustomImpl worker = OfflineTestWorkerCustomImpl.create(this, configuration);
                this.getWorker().add((Object)worker);
                supervisor.getQueue().setHeuristic(true);
                return true;
            }
        }
        return true;
    }

    public boolean configureSerializerWorker(ILaunchConfiguration configuration) {
        SerializerImpl modelSerializer;
        boolean enabledSerialization;
        try {
            enabledSerialization = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_PARSED_MODEL_GRAPHVIZ_GENERATION", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            enabledSerialization = false;
        }
        if (enabledSerialization) {
            modelSerializer = ModelGraphvizSerializerWorkerCustomImpl.create(this, configuration);
            this.getWorker().add((Object)modelSerializer);
        }
        try {
            enabledSerialization = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            enabledSerialization = false;
        }
        if (enabledSerialization) {
            modelSerializer = SymbexGraphvizSerializerWorkerCustomImpl.create(this, configuration);
            this.getWorker().add((Object)modelSerializer);
        }
        DeveloperTuningOptionCustomImpl devTuning = DeveloperTuningOptionCustomImpl.createDirector(configuration);
        this.setDeveloperTuning(devTuning);
        return true;
    }

    public boolean configureDebugWorker(ILaunchConfiguration configuration) {
        return true;
    }

    public boolean configureOtherWorker(ILaunchConfiguration configuration) {
        return true;
    }

    public static DirectorCustomImpl createSecond(Workflow workflow, ILaunchConfiguration configuration) {
        DirectorCustomImpl director = new DirectorCustomImpl(workflow);
        director.setManifest(ManifestCustomImpl.create(true, true));
        director.configureSecondWorker(configuration);
        director.configureSecondSerializerWorker(configuration, true);
        return director;
    }

    public boolean configureSecondWorker(ILaunchConfiguration configuration) {
        SupervisorWorkerCustomImpl supervisor = SupervisorWorkerCustomImpl.createSecond(configuration);
        this.setDescription("of graph exploration");
        this.setSupervisor(supervisor);
        BehaviorCoverageWorkerCustomImpl worker = BehaviorCoverageWorkerCustomImpl.createSecond(this, configuration);
        this.getWorker().add((Object)worker);
        supervisor.getQueue().setHeuristic(true);
        return true;
    }

    public boolean configureSecondSerializerWorker(ILaunchConfiguration configuration, boolean hasSecond) {
        boolean enabledSerialization;
        try {
            enabledSerialization = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRACE_ENABLED", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            enabledSerialization = false;
        }
        if (enabledSerialization) {
            BasicTraceSerializerWorkerCustomImpl basicSerializer = BasicTraceSerializerWorkerCustomImpl.create(this, configuration);
            this.getWorker().add((Object)basicSerializer);
        }
        try {
            enabledSerialization = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TTCN_ENABLED", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            enabledSerialization = false;
        }
        if (enabledSerialization) {
            TTCNTraceSerializerWorkerCustomImpl ttcnSerializer = TTCNTraceSerializerWorkerCustomImpl.create(this, configuration);
            this.getWorker().add((Object)ttcnSerializer);
        }
        try {
            enabledSerialization = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            enabledSerialization = false;
        }
        if (enabledSerialization) {
            SymbexGraphvizSerializerWorkerCustomImpl modelSerializer = SymbexGraphvizSerializerWorkerCustomImpl.createSecond(this, configuration);
            this.getWorker().add((Object)modelSerializer);
        }
        if (hasSecond) {
            DeveloperTuningOptionCustomImpl devTuning = DeveloperTuningOptionCustomImpl.createSecondDirector(configuration);
            this.setDeveloperTuning(devTuning);
        }
        return true;
    }

    public void toWriter(PrettyPrintWriter writer) {
        DeveloperTuningOptionCustomImpl devTuning;
        Project project;
        writer.commentLine(this.getComment());
        writer.appendTab("director");
        String str = this.getName();
        if (str != null) {
            writer.append(' ').append(str);
        }
        if ((str = this.getDescription()) != null) {
            writer.append(" '").append(str).append("'");
        }
        writer.appendEol(" {");
        PrettyPrintWriter writer2 = writer.itab2();
        ManifestCustomImpl manifest = (ManifestCustomImpl)this.getManifest();
        if (manifest != null) {
            manifest.toWriter(writer2);
        }
        if ((project = this.getProject()) != null) {
            writer2.appendTabEol("project 'path of input model' [");
            writer2.appendTab2("source = \"").append(project.getSource()).appendEol("\"");
            writer2.appendTab2("model  = \"").append(project.getModel()).appendEol("\"");
            writer2.appendTabEol("] // end project");
        }
        ((SupervisorWorkerCustomImpl)this.getSupervisor()).toWriter(writer2);
        writer2.appendTabEol("worker [");
        PrettyPrintWriter writer3 = writer.itab3();
        for (Worker worker : this.getWorker()) {
            if (worker instanceof BehaviorCoverageWorkerCustomImpl) {
                ((BehaviorCoverageWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            if (worker instanceof TransitionCoverageWorkerCustomImpl) {
                ((TransitionCoverageWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            if (worker instanceof ModelGraphvizSerializerWorkerCustomImpl) {
                ((ModelGraphvizSerializerWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            if (worker instanceof SymbexGraphvizSerializerWorkerCustomImpl) {
                ((SymbexGraphvizSerializerWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            if (worker instanceof BasicTraceSerializerWorkerCustomImpl) {
                ((BasicTraceSerializerWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            if (worker instanceof TTCNTraceSerializerWorkerCustomImpl) {
                ((TTCNTraceSerializerWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            if (worker instanceof OfflineTestWorkerCustomImpl) {
                ((OfflineTestWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            writer3.commentLine(worker.getComment());
            writer3.appendTab();
            str = worker.getName();
            if (str != null) {
                writer3.append(str).append(' ');
            }
            if ((str = worker.getDescription()) != null) {
                writer3.append("'").append(str).append("' ");
            }
            writer3.appendEol("{");
            writer3.appendTabEol("}");
        }
        writer.appendTab2Eol("] // end worker");
        ConsoleLogFormatCustomImpl console = (ConsoleLogFormatCustomImpl)this.getConsole();
        if (console != null) {
            console.toWriter(writer2);
        }
        if ((devTuning = (DeveloperTuningOptionCustomImpl)this.getDeveloperTuning()) != null) {
            devTuning.toWriter(writer2);
        }
        writer.appendTabEol("}");
    }
}

