/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.workflow.test;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.sew.launcher.workflow.Director;
import org.eclipse.efm.sew.launcher.workflow.IWorkflowConfigurationConstants;
import org.eclipse.efm.sew.launcher.workflow.common.ConsoleLogFormatCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.ManifestCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.TraceSpecificationCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.test.impl.OfflineTestWorkerImpl;
import org.eclipse.efm.sew.launcher.workflow.util.PrettyPrintWriter;

public class OfflineTestWorkerCustomImpl
extends OfflineTestWorkerImpl
implements IWorkflowConfigurationConstants {
    public OfflineTestWorkerCustomImpl(Director director, String name) {
        this.setDirector(director);
        this.setName(name);
    }

    public OfflineTestWorkerCustomImpl(Director director, String name, String description) {
        this.setDirector(director);
        this.setName(name);
        this.setDescription(description);
    }

    public static OfflineTestWorkerCustomImpl create(Director director, ILaunchConfiguration configuration) {
        String path;
        OfflineTestWorkerCustomImpl testWorker = new OfflineTestWorkerCustomImpl(director, "offline_test");
        try {
            path = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TRACE_FILE_LOCATION", "<merge-trace-file-path>");
        }
        catch (CoreException e) {
            e.printStackTrace();
            path = "<merge-trace-file-path>";
        }
        if (!"<merge-trace-file-path>".equals(path)) {
            testWorker.setMergedTraceFile(path);
        }
        try {
            path = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TEST_PURPOSE_FILE_LOCATION", "<test-purpose-file-path>");
        }
        catch (CoreException e) {
            e.printStackTrace();
            path = "<test-purpose-file-path>";
        }
        if (!"<test-purpose-file-path>".equals(path)) {
            testWorker.setTestPurposeFile(path);
        }
        TraceSpecificationCustomImpl trace = TraceSpecificationCustomImpl.create("observable", "//[*] , use for ANY element w.r.t. the kind\n//com_element_id ::= <port_name_id> | <signal_name_id>\n//com = <machine_name_id> -> <com_element_id>\n//input = <machine_name_id> -> <com_element_id>\n//output = <machine_name_id> -> <com_element_id>\n");
        testWorker.setObservable(trace);
        trace = TraceSpecificationCustomImpl.create("controllable", "input#env = [*]");
        testWorker.setControllable(trace);
        return testWorker;
    }

    public void toWriter(PrettyPrintWriter writer) {
        ConsoleLogFormatCustomImpl console;
        TraceSpecificationCustomImpl controllable;
        writer.commentLine(this.getComment());
        writer.appendTab("test#offline");
        String str = this.getName();
        if (str != null) {
            writer.append(' ').append(str);
        }
        if ((str = this.getDescription()) != null) {
            writer.append(" '").append(str).append("'");
        }
        writer.appendEol(" {");
        PrettyPrintWriter writer2 = writer.itab2();
        ManifestCustomImpl manifest = (ManifestCustomImpl)this.getManifest();
        if (manifest != null) {
            manifest.toWriter(writer2);
        }
        writer.appendTab2Eol("merged_trace [");
        str = this.getMergedTraceFile();
        if (str != null) {
            writer.appendTab3("mergedTraceFile = \"").append(str).appendEol("\"");
        } else {
            writer.appendTab3("mergedTraceFile = \"").append("<merge-trace-file-path>").appendEol("\"");
        }
        str = this.getTestPurposeFile();
        if (str != null) {
            writer.appendTab3("testPurposeFile = \"").append(str).appendEol("\"");
        } else {
            writer.appendTab3("//testPurposeFile = \"").append("<test-purpose-file-path>").appendEol("\"");
        }
        writer.appendTab2Eol("] // end queue");
        TraceSpecificationCustomImpl observable = (TraceSpecificationCustomImpl)this.getObservable();
        if (observable != null) {
            observable.toWriter(writer2);
        }
        if ((controllable = (TraceSpecificationCustomImpl)this.getControllable()) != null) {
            controllable.toWriter(writer2);
        }
        if ((console = (ConsoleLogFormatCustomImpl)this.getConsole()) != null) {
            console.toWriter(writer2);
        }
        writer.appendTabEol("}");
    }
}

