/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.service.DispatchingProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

@Singleton
public class WorkspaceEncodingProvider
implements IEncodingProvider {
    private static final Logger LOG = Logger.getLogger(WorkspaceEncodingProvider.class);
    @Inject
    private IWorkspace workspace;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    @DispatchingProvider.Runtime
    private IEncodingProvider runtimeEncodingProvider;

    public String getEncoding(URI uri) {
        if (this.workspace != null) {
            if (uri != null) {
                for (Pair<IStorage, IProject> storage : this.storage2UriMapper.getStorages(uri)) {
                    if (storage.getFirst() instanceof IEncodedStorage) {
                        try {
                            return ((IEncodedStorage)storage.getFirst()).getCharset();
                        }
                        catch (CoreException e) {
                            LOG.error((Object)"Error getting file encoding", (Throwable)e);
                        }
                    }
                    try {
                        String result = ((IProject)storage.getSecond()).getDefaultCharset(true);
                        return result;
                    }
                    catch (CoreException e) {
                        LOG.error((Object)"Error getting project's default encoding", (Throwable)e);
                    }
                }
            }
            try {
                return this.workspace.getRoot().getDefaultCharset();
            }
            catch (CoreException e) {
                LOG.error((Object)"Error getting project's default encoding", (Throwable)e);
            }
        }
        return this.runtimeEncodingProvider.getEncoding(uri);
    }
}

