/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring.util;

import edu.uci.ics.jung.algorithms.scoring.util.VEPair;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniformDegreeWeight<V, E>
implements Transformer<VEPair<V, E>, Double> {
    private Hypergraph<V, E> graph;

    public UniformDegreeWeight(Hypergraph<V, E> graph) {
        this.graph = graph;
    }

    public Double transform(VEPair<V, E> ve_pair) {
        E e = ve_pair.getE();
        V v = ve_pair.getV();
        EdgeType edge_type = this.graph.getEdgeType(e);
        if (edge_type == EdgeType.UNDIRECTED) {
            return 1.0 / (double)this.graph.degree(v);
        }
        if (edge_type == EdgeType.DIRECTED) {
            return 1.0 / (double)this.graph.outDegree(this.graph.getSource(e));
        }
        throw new IllegalArgumentException("can't handle edge type: " + (Object)((Object)edge_type));
    }
}

