/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model;

import com.google.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.model.GeneratedJavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TextFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.XtendFileAccess;

public class FileAccessFactory {
    @Inject
    private CodeConfig codeConfig;

    public TextFileAccess createTextFile() {
        return new TextFileAccess();
    }

    public TextFileAccess createTextFile(String path) {
        TextFileAccess result = this.createTextFile();
        result.setPath(path);
        return result;
    }

    public TextFileAccess createTextFile(String path, StringConcatenationClient content) {
        TextFileAccess result = this.createTextFile(path);
        result.setContent(content);
        return result;
    }

    public JavaFileAccess createJavaFile(TypeReference typeRef) {
        return new JavaFileAccess(typeRef, this.codeConfig);
    }

    public JavaFileAccess createJavaFile(TypeReference typeRef, StringConcatenationClient content) {
        JavaFileAccess result = this.createJavaFile(typeRef);
        result.setContent(content);
        return result;
    }

    public XtendFileAccess createXtendFile(TypeReference typeRef) {
        return new XtendFileAccess(typeRef, this.codeConfig);
    }

    public XtendFileAccess createXtendFile(TypeReference typeRef, StringConcatenationClient content) {
        XtendFileAccess result = this.createXtendFile(typeRef);
        result.setContent(content);
        return result;
    }

    public GeneratedJavaFileAccess createGeneratedJavaFile(TypeReference typeRef) {
        return new GeneratedJavaFileAccess(typeRef, this.codeConfig);
    }
}

