/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.PView;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.event.RepaintAdapter;
import fr.inria.zvtm.event.ViewListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.RadarEvtHdlr;
import net.claribole.zgrviewer.SearchPanel;

class NavPanel
extends JPanel
implements ActionListener,
ChangeListener {
    GraphicsManager grMngr;
    View overview = null;
    JButton[] panBts = new JButton[9];
    static final ImageIcon[] icons = new ImageIcon[]{new ImageIcon(NavPanel.class.getResource("/images/m_nw.png")), new ImageIcon(NavPanel.class.getResource("/images/m_n.png")), new ImageIcon(NavPanel.class.getResource("/images/m_ne.png")), new ImageIcon(NavPanel.class.getResource("/images/m_w.png")), new ImageIcon(NavPanel.class.getResource("/images/m_home.png")), new ImageIcon(NavPanel.class.getResource("/images/m_e.png")), new ImageIcon(NavPanel.class.getResource("/images/m_sw.png")), new ImageIcon(NavPanel.class.getResource("/images/m_s.png")), new ImageIcon(NavPanel.class.getResource("/images/m_se.png")), new ImageIcon(NavPanel.class.getResource("/images/zm_i.png")), new ImageIcon(NavPanel.class.getResource("/images/zm_o.png"))};
    static final ImageIcon[] r_icons = new ImageIcon[]{new ImageIcon(NavPanel.class.getResource("/images/m_nw_h.png")), new ImageIcon(NavPanel.class.getResource("/images/m_n_h.png")), new ImageIcon(NavPanel.class.getResource("/images/m_ne_h.png")), new ImageIcon(NavPanel.class.getResource("/images/m_w_h.png")), new ImageIcon(NavPanel.class.getResource("/images/m_home_h.png")), new ImageIcon(NavPanel.class.getResource("/images/m_e_h.png")), new ImageIcon(NavPanel.class.getResource("/images/m_sw_h.png")), new ImageIcon(NavPanel.class.getResource("/images/m_s_h.png")), new ImageIcon(NavPanel.class.getResource("/images/m_se_h.png")), new ImageIcon(NavPanel.class.getResource("/images/zm_i_h.png")), new ImageIcon(NavPanel.class.getResource("/images/zm_o_h.png"))};
    JButton[] zoomBts = new JButton[2];
    JCheckBox aaCb;
    JButton aboutBt;

    NavPanel(GraphicsManager gm, String initialSearchString, boolean displayOverview) {
        this.setOpaque(false);
        this.grMngr = gm;
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 10;
        this.setLayout(gridBag);
        int gncl_i = 0;
        if (displayOverview) {
            JPanel borderPanel = new JPanel();
            borderPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 1), "Overview"));
            borderPanel.setOpaque(false);
            borderPanel.setLayout(new BorderLayout());
            Vector<Camera> cameras = new Vector<Camera>();
            cameras.add(this.grMngr.mSpace.getCamera(1));
            cameras.add(this.grMngr.rSpace.getCamera(0));
            PView pv = this.grMngr.vsm.addPanelView(cameras, "Overview", "std", 100, 100);
            JPanel ovPanel = (JPanel)pv.getPanel().getComponent();
            this.grMngr.reh = new RadarEvtHdlr(this.grMngr);
            this.grMngr.rView = this.grMngr.vsm.getView("Overview");
            this.grMngr.rView.setBackgroundColor(this.grMngr.cfgMngr.backgroundColor);
            this.grMngr.rView.setListener((ViewListener)this.grMngr.reh, 0);
            this.grMngr.rView.setListener((ViewListener)this.grMngr.reh, 1);
            this.grMngr.rView.setActiveLayer(1);
            this.grMngr.rView.setCursorIcon(13);
            this.grMngr.cameraMoved(null, null, 0.0);
            borderPanel.add((Component)ovPanel, "Center");
            NavPanel.buildConstraints(constraints, 0, gncl_i++, 1, 1, 100, 64);
            gridBag.setConstraints(borderPanel, constraints);
            this.add(borderPanel);
            this.grMngr.rView.repaint(new RepaintAdapter(){

                public void viewRepainted(View v) {
                    v.getGlobalView(NavPanel.this.grMngr.mSpace.getCamera(1), 100);
                    v.removeRepaintListener();
                }
            });
        }
        constraints.fill = 0;
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(3, 3));
        p1.setOpaque(false);
        for (int i = 0; i < this.panBts.length; ++i) {
            this.panBts[i] = new JButton(icons[i]);
            this.panBts[i].setBorder(BorderFactory.createEmptyBorder());
            this.panBts[i].setContentAreaFilled(false);
            this.panBts[i].setBorderPainted(false);
            this.panBts[i].setFocusPainted(false);
            this.panBts[i].setRolloverIcon(r_icons[i]);
            this.panBts[i].addActionListener(this);
            p1.add(this.panBts[i]);
        }
        NavPanel.buildConstraints(constraints, 0, gncl_i++, 1, 1, 0, 16);
        gridBag.setConstraints(p1, constraints);
        this.add(p1);
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(2, 1));
        p2.setOpaque(false);
        for (int i = 0; i < this.zoomBts.length; ++i) {
            this.zoomBts[i] = new JButton(icons[i + this.panBts.length]);
            this.zoomBts[i].setBorder(BorderFactory.createEmptyBorder());
            this.zoomBts[i].setContentAreaFilled(false);
            this.zoomBts[i].setBorderPainted(false);
            this.zoomBts[i].setFocusPainted(false);
            this.zoomBts[i].setRolloverIcon(r_icons[i + this.panBts.length]);
            this.zoomBts[i].addActionListener(this);
            p2.add(this.zoomBts[i]);
        }
        NavPanel.buildConstraints(constraints, 0, gncl_i++, 1, 1, 0, 16);
        gridBag.setConstraints(p2, constraints);
        this.add(p2);
        SearchPanel p3 = new SearchPanel(this.grMngr, initialSearchString);
        NavPanel.buildConstraints(constraints, 0, gncl_i++, 1, 1, 0, 16);
        gridBag.setConstraints(p3, constraints);
        this.add(p3);
        this.aaCb = new JCheckBox("Antialiasing", this.grMngr.mainView.getAntialiasing());
        this.aaCb.setOpaque(false);
        NavPanel.buildConstraints(constraints, 0, gncl_i++, 1, 1, 0, 16);
        gridBag.setConstraints(this.aaCb, constraints);
        this.add(this.aaCb);
        this.aaCb.addChangeListener(this);
        JPanel p4 = new JPanel();
        p4.setOpaque(false);
        this.aboutBt = new JButton("About...");
        this.aboutBt.setOpaque(false);
        this.aboutBt.addActionListener(this);
        p4.add(this.aboutBt);
        NavPanel.buildConstraints(constraints, 0, gncl_i++, 1, 1, 0, 16);
        gridBag.setConstraints(p4, constraints);
        this.add(p4);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.zoomBts[0]) {
            this.grMngr.getLowerView();
        } else if (o == this.zoomBts[1]) {
            this.grMngr.getHigherView();
        } else if (o == this.panBts[4]) {
            this.grMngr.getGlobalView();
        } else if (o == this.panBts[1]) {
            this.grMngr.translateView((short)0);
        } else if (o == this.panBts[7]) {
            this.grMngr.translateView((short)1);
        } else if (o == this.panBts[5]) {
            this.grMngr.translateView((short)3);
        } else if (o == this.panBts[3]) {
            this.grMngr.translateView((short)2);
        } else if (o == this.panBts[0]) {
            this.grMngr.translateView((short)4);
        } else if (o == this.panBts[2]) {
            this.grMngr.translateView((short)5);
        } else if (o == this.panBts[6]) {
            this.grMngr.translateView((short)6);
        } else if (o == this.panBts[8]) {
            this.grMngr.translateView((short)7);
        } else if (o == this.aboutBt) {
            this.grMngr.zapp.about();
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object o = e.getSource();
        if (o == this.aaCb) {
            this.grMngr.setAntialiasing(this.aaCb.isSelected());
        }
    }

    static void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }
}

