/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RankedObjectRegistry<T> {
    private final TreeSet<Registration<T>> objectList = new TreeSet();

    public synchronized void registerObject(int rank, T object) {
        this.objectList.add(new Registration<T>(rank, object));
    }

    public synchronized void unregisterObject(T object) {
        this.objectList.removeIf(r -> r.object == object);
    }

    public synchronized List<T> getRankedElements() {
        return this.objectList.stream().map(r -> r.object).collect(Collectors.toList());
    }

    public Stream<T> threadSafeStream() {
        return new TreeSet<Registration<T>>(this.objectList).stream().map(r -> r.object);
    }

    public Stream<T> unsynchronizedStream() {
        return this.objectList.stream().map(r -> r.object);
    }

    public static int getOSGiServiceRank(Map<String, Object> properties) {
        return RankedObjectRegistry.getServiceRank(properties, "service.ranking");
    }

    public static int getServiceRank(Map<String, Object> properties, String property) {
        Object object = properties.get(property);
        if (object == null || !(object instanceof Number)) {
            if (object instanceof String) {
                try {
                    return Integer.parseInt((String)object);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return 0;
        }
        return ((Number)object).intValue();
    }

    static class Registration<T>
    implements Comparable<Registration<T>> {
        final int rank;
        final T object;

        public Registration(int rank, T object) {
            this.rank = rank;
            this.object = object;
        }

        @Override
        public int compareTo(Registration<T> o) {
            int v = Integer.compare(this.rank, o.rank);
            if (v == 0) {
                v = this.object.getClass().toString().compareTo(o.object.getClass().getName());
            }
            return v * -1;
        }

        public String toString() {
            return "RankedObjectRegistry@" + Integer.toHexString(this.hashCode()) + "( ranking: " + this.rank + "," + this.object + ")";
        }
    }
}

