/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.emf.edit.ui;

import javafx.scene.control.Cell;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import javafx.util.Callback;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fx.emf.edit.ui.AdapterFactoryCellFactory;

public class AdapterFactoryTreeCellFactory
extends AdapterFactoryCellFactory
implements Callback<TreeView<Object>, TreeCell<Object>> {
    public AdapterFactoryTreeCellFactory(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public TreeCell<Object> call(TreeView<Object> param) {
        TreeCell<Object> treeCell = new TreeCell<Object>(){
            Object currentItem = null;
            AdapterFactoryCellFactory.ICellEditHandler cellEditHandler;
            AdapterImpl adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    this.update(msg.getNotifier());
                }
            };

            public void startEdit() {
                super.startEdit();
                this.cellEditHandler = AdapterFactoryTreeCellFactory.this.getCellEditHandler((Cell<?>)this);
                if (this.cellEditHandler != null) {
                    this.cellEditHandler.startEdit((Cell<?>)this);
                }
            }

            public void commitEdit(Object newValue) {
                super.commitEdit(newValue);
                if (this.cellEditHandler != null) {
                    this.cellEditHandler.commitEdit((Cell<?>)this, newValue);
                }
            }

            public void cancelEdit() {
                super.cancelEdit();
                if (this.cellEditHandler != null) {
                    this.cellEditHandler.cancelEdit((Cell<?>)this);
                }
                this.update(this.getItem());
            }

            protected void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                if (item != this.currentItem) {
                    if (this.currentItem instanceof Notifier) {
                        ((Notifier)this.currentItem).eAdapters().remove((Object)this.adapter);
                    }
                    this.currentItem = item;
                    if (this.currentItem instanceof Notifier) {
                        ((Notifier)this.currentItem).eAdapters().add((Object)this.adapter);
                    }
                }
                for (AdapterFactoryCellFactory.ICellUpdateListener cellUpdateListener : AdapterFactoryTreeCellFactory.this.cellUpdateListeners) {
                    cellUpdateListener.updateItem((Cell<?>)this, item, empty);
                }
                this.update(item);
            }

            void update(Object item) {
                if (item != null) {
                    AdapterFactoryTreeCellFactory.applyItemProviderStyle(item, this, AdapterFactoryTreeCellFactory.this.adapterFactory);
                } else {
                    this.setText(null);
                    this.setGraphic(null);
                }
            }
        };
        for (AdapterFactoryCellFactory.ICellCreationListener cellCreationListener : this.cellCreationListeners) {
            cellCreationListener.cellCreated((Cell<?>)treeCell);
        }
        return treeCell;
    }
}

