/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.command.GetContentCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.compare.GerritCompareHelper;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class PatchSetCompareItem
extends CommentableCompareItem
implements ITypedElement,
IModificationDate,
IEditableContent,
IStreamContentAccessor {
    private static final String REVISION = "REVISION";

    public PatchSetCompareItem() {
        super(REVISION);
    }

    public String getName() {
        return "Patch Set " + this.fileInfo.getRevision().get_number() + ": " + GerritCompareHelper.extractFilename(this.fileInfo.getPath());
    }

    @Override
    protected byte[] loadFileContent() {
        String fileContent = null;
        GetContentCommand command = this.gerrit.getContent(this.getChangeId(), this.fileInfo.getRevision().getId(), this.fileInfo.getPath());
        if (!"D".equals(this.fileInfo.getStatus())) {
            try {
                fileContent = (String)command.call();
                if (fileContent == null) {
                    fileContent = "";
                }
            }
            catch (EGerritException e) {
                EGerritCorePlugin.logError((String)(String.valueOf(this.gerrit.getRepository().formatGerritVersion()) + e.getMessage()));
            }
        } else {
            fileContent = "";
        }
        return Base64.decodeBase64((String)fileContent);
    }

    @Override
    protected EList<CommentInfo> filterComments(EList<CommentInfo> eList) {
        return (EList)eList.stream().filter(comment -> comment.getSide() == null || REVISION.equals(comment.getSide())).collect(Collectors.toCollection(BasicEList::new));
    }
}

