/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.impl.StringToFileInfoImpl;
import org.eclipse.egerrit.internal.ui.compare.GerritDiffNode;
import org.eclipse.egerrit.internal.ui.editors.ClearReviewedFlag;
import org.eclipse.egerrit.internal.ui.table.model.ITableModel;
import org.eclipse.egerrit.internal.ui.table.provider.FileInfoCompareCellLabelProvider;
import org.eclipse.egerrit.internal.ui.table.provider.FileTableLabelProvider;
import org.eclipse.egerrit.internal.ui.table.provider.HandleFileSelection;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableItem;

public class DynamicMenuBuilder {
    private Menu commonMenu;
    private HashMap<ITableModel, TreeViewerColumn> treeViewerColumn = new HashMap();
    private FileTableLabelProvider tableLabelProvider;

    public HashMap<ITableModel, TreeViewerColumn> getTreeViewerColumn() {
        return this.treeViewerColumn;
    }

    public void addPulldownMenu(final ColumnViewer viewer, final GerritClient client, final boolean available) {
        MenuManager menuManager = new MenuManager();
        if (viewer instanceof TableViewer) {
            this.commonMenu = menuManager.createContextMenu((Control)((TableViewer)viewer).getTable());
            ((TableViewer)viewer).getTable().setMenu(this.commonMenu);
        } else if (viewer instanceof DiffTreeViewer) {
            this.commonMenu = menuManager.createContextMenu(((DiffTreeViewer)viewer).getControl());
            ((DiffTreeViewer)viewer).getControl().setMenu(this.commonMenu);
        }
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DynamicMenuBuilder.this.addMenuItem(DynamicMenuBuilder.this.commonMenu, viewer, client, available);
            }
        });
        menuManager.update(true);
    }

    private void addMenuItem(Menu menu, final ColumnViewer viewer, final GerritClient client, boolean available) {
        if (menu.getItemCount() == 0) {
            if (available) {
                MenuItem openFile = new MenuItem(menu, 8);
                openFile.setText(Messages.UIFilesTable_0);
                if (viewer instanceof TableViewer) {
                    this.tableLabelProvider = (FileTableLabelProvider)viewer.getLabelProvider();
                    openFile.setSelection(this.tableLabelProvider.getFileOrder());
                }
                openFile.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        HandleFileSelection handleSelection = new HandleFileSelection(client, viewer);
                        handleSelection.showFileSelection();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            MenuItem removeCheckMark = new MenuItem(menu, 8);
            removeCheckMark.setText(Messages.UIFilesTable_clearReviewedFlag);
            removeCheckMark.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayList<FileInfo> listFiles = new ArrayList<FileInfo>();
                    if (viewer instanceof TableViewer) {
                        TableItem[] tableItems;
                        TableItem[] tableItemArray = tableItems = ((TableViewer)viewer).getTable().getItems();
                        int n = tableItems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem tableItem = tableItemArray[n2];
                            listFiles.add(((StringToFileInfoImpl)tableItem.getData()).getValue());
                            ++n2;
                        }
                    } else {
                        Object obj = viewer.getInput();
                        if (obj instanceof GerritDiffNode) {
                            IDiffElement[] children;
                            GerritDiffNode diffNode = (GerritDiffNode)((Object)obj);
                            IDiffElement[] iDiffElementArray = children = diffNode.getChildren();
                            int n = children.length;
                            int n3 = 0;
                            while (n3 < n) {
                                IDiffElement element = iDiffElementArray[n3];
                                listFiles.add(((GerritDiffNode)element).getFileInfo());
                                ++n3;
                            }
                        }
                    }
                    ClearReviewedFlag reviewCheck = new ClearReviewedFlag(client, listFiles);
                    reviewCheck.removeCheckMark();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (available) {
                new MenuItem(menu, 2);
                MenuItem nameFirst = new MenuItem(menu, 32);
                nameFirst.setText(Messages.UIFilesTable_1);
                if (viewer instanceof TableViewer) {
                    nameFirst.setSelection(this.tableLabelProvider.getFileOrder());
                } else {
                    nameFirst.setSelection(((FileInfoCompareCellLabelProvider)viewer.getLabelProvider()).getFileOrder());
                }
                nameFirst.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        MenuItem menuItem = (MenuItem)e.getSource();
                        if (viewer instanceof TableViewer) {
                            DynamicMenuBuilder.this.tableLabelProvider.setFileNameFirst(menuItem.getSelection());
                        } else {
                            ((FileInfoCompareCellLabelProvider)viewer.getLabelProvider()).setFileNameFirst(menuItem.getSelection());
                        }
                        viewer.refresh();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
        }
    }
}

