/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.errors;

import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.eclipse.jgit.lfs.internal.LfsText;

public class InvalidLongObjectIdException
extends IllegalArgumentException {
    private static final long serialVersionUID = 1L;

    public InvalidLongObjectIdException(byte[] bytes, int offset, int length) {
        super(MessageFormat.format(LfsText.get().invalidLongId, InvalidLongObjectIdException.asAscii(bytes, offset, length)));
    }

    public InvalidLongObjectIdException(String idString) {
        super(MessageFormat.format(LfsText.get().invalidLongId, idString));
    }

    private static String asAscii(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, StandardCharsets.US_ASCII);
        }
        catch (StringIndexOutOfBoundsException e) {
            return "";
        }
    }
}

