/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.cds;

import java.util.function.Supplier;
import org.eclipse.osgi.internal.cds.CDSHookImpls;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.hookregistry.HookConfigurator;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.internal.log.EquinoxLogServices;

public class CDSHookConfigurator
implements HookConfigurator {
    private static final String REPORT_ERRORS = "j9.cds.reporterrors";
    private static final String DISABLE_CDS = "j9.cds.disable";
    private static final String OLD_CDS_CONFIGURATOR = "com.ibm.cds.CDSHookConfigurator";
    private static final String J9_SHARED_CLASS_HELPER_CLASS = "com.ibm.oti.shared.SharedClassHelperFactory";

    static void print(Debug debug, Supplier<String> msg) {
        if (debug.DEBUG_LOADER_CDS) {
            Debug.println(msg.get());
        }
    }

    @Override
    public void addHooks(HookRegistry hookRegistry) {
        Debug debug = hookRegistry.getConfiguration().getDebug();
        boolean disableCDS = Boolean.valueOf(hookRegistry.getConfiguration().getProperty(DISABLE_CDS));
        if (disableCDS) {
            CDSHookConfigurator.print(debug, () -> "Class sharing is disabled by: j9.cds.disable");
            return;
        }
        try {
            Class.forName(OLD_CDS_CONFIGURATOR);
            CDSHookConfigurator.print(debug, () -> "Detected old com.ibm.cds fragment.");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName(J9_SHARED_CLASS_HELPER_CLASS);
                CDSHookConfigurator.print(debug, () -> "Found Eclipse OpenJ9 support class: com.ibm.oti.shared.SharedClassHelperFactory");
            }
            catch (ClassNotFoundException e) {
                CDSHookConfigurator.print(debug, () -> "Not running on Eclipse OpenJ9.");
                boolean reportErrors = Boolean.valueOf(hookRegistry.getConfiguration().getProperty(REPORT_ERRORS));
                if (reportErrors) {
                    EquinoxContainer container = hookRegistry.getContainer();
                    EquinoxLogServices logServices = container.getLogServices();
                    logServices.log("org.eclipse.osgi", 2, "The J9 Class Sharing Adaptor will not work in this configuration. You are not running on a J9 Java VM.", null);
                }
                return;
            }
            new CDSHookImpls(debug).registerHooks(hookRegistry);
            return;
        }
    }
}

