/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class CommitMessageHistory {
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_MESSAGES = "messages";

    public static Set<String> getCommitHistory() {
        XMLMemento memento;
        String all = CommitMessageHistory.getPreferenceStore().getString("commit_dialog_history_messages");
        if (all.length() == 0) {
            return Collections.emptySet();
        }
        int max = CommitMessageHistory.getCommitHistorySize();
        if (max < 1) {
            return Collections.emptySet();
        }
        try {
            memento = XMLMemento.createReadRoot((Reader)new StringReader(all));
        }
        catch (WorkbenchException e) {
            Activator.logError("Error reading commit message history", e);
            return Collections.emptySet();
        }
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        IMemento[] iMementoArray = memento.getChildren(KEY_MESSAGE);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            messages.add(child.getTextData());
            if (messages.size() == max) break;
            ++n2;
        }
        return messages;
    }

    public static void saveCommitHistory(String message) {
        if (message == null || message.length() == 0) {
            return;
        }
        int size = CommitMessageHistory.getCommitHistorySize();
        if (size < 1) {
            return;
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)KEY_MESSAGES);
        memento.createChild(KEY_MESSAGE).putTextData(message);
        int count = 1;
        if (count < size) {
            Set<String> history = CommitMessageHistory.getCommitHistory();
            history.remove(message);
            for (String previous : history) {
                memento.createChild(KEY_MESSAGE).putTextData(previous);
                if (++count == size) break;
            }
        }
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            CommitMessageHistory.getPreferenceStore().setValue("commit_dialog_history_messages", writer.toString());
        }
        catch (IOException e) {
            Activator.logError("Error writing commit message history", e);
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    private static int getCommitHistorySize() {
        return CommitMessageHistory.getPreferenceStore().getInt("commit_dialog_history_size");
    }
}

