/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

public abstract class PartVisibilityListener
implements IPartListener2 {
    private final IWorkbenchPart myself;
    private boolean viewVisible = true;

    public PartVisibilityListener(IWorkbenchPart part) {
        this.myself = part;
    }

    public boolean isVisible() {
        return this.viewVisible;
    }

    protected void setVisible(boolean visible) {
        this.viewVisible = visible;
    }

    private void updateHiddenState(IWorkbenchPartReference partRef, boolean visible) {
        if (this.isMe(partRef)) {
            this.setVisible(visible);
        }
    }

    protected final boolean isMe(IWorkbenchPartReference partRef) {
        return partRef.getPart(false) == this.myself;
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        this.updateHiddenState(partRef, false);
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        this.updateHiddenState(partRef, false);
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.updateHiddenState(partRef, true);
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        this.updateHiddenState(partRef, true);
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }
}

