/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class CheckoutCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode>
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        if (!(node.getObject() instanceof Ref)) {
            return null;
        }
        Ref ref = (Ref)node.getObject();
        Repository repo = node.getRepository();
        BranchOperationUI op = BranchOperationUI.checkout(repo, ref.getName());
        op.start();
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        Ref ref;
        RepositoryTreeNode node;
        List nodes = this.getSelectedNodes();
        if (!nodes.isEmpty() && (node = (RepositoryTreeNode)nodes.get(0)).getObject() instanceof Ref && BranchOperationUI.checkoutWillShowQuestionDialog((ref = (Ref)node.getObject()).getName())) {
            element.setText(UIText.CheckoutCommand_CheckoutLabelWithQuestion);
            return;
        }
        element.setText(UIText.CheckoutCommand_CheckoutLabel);
    }
}

