/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.agent.connector;

import java.io.IOException;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.PageantLibrary;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.Texts;
import org.eclipse.jgit.transport.sshd.agent.AbstractConnector;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;

public class PageantConnector
extends AbstractConnector {
    public static final ConnectorFactory.ConnectorDescriptor DESCRIPTOR = new ConnectorFactory.ConnectorDescriptor(){

        public String getIdentityAgent() {
            return "\\\\.\\pageant";
        }

        public String getDisplayName() {
            return Texts.get().pageant;
        }
    };
    private final PageantLibrary lib = new PageantLibrary();

    public boolean connect() throws IOException {
        return this.lib.isPageantAvailable();
    }

    public void close() throws IOException {
    }

    public byte[] rpc(byte command, byte[] message) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PageantLibrary.Pipe pipe = this.lib.createPipe(((Object)((Object)this)).getClass().getSimpleName(), this.getMaximumMessageLength());){
            this.prepareMessage(command, message);
            pipe.send(message);
            byte[] lengthBuf = new byte[4];
            pipe.receive(lengthBuf);
            int length = this.toLength(command, lengthBuf);
            byte[] payload = new byte[length];
            pipe.receive(payload);
            return payload;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

