/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import java.awt.geom.Rectangle2D;
import org.eclipse.elk.core.comments.IBoundsProvider;
import org.eclipse.elk.core.comments.IEligibilityFilter;
import org.eclipse.elk.core.comments.ShapeLayoutBoundsProvider;
import org.eclipse.elk.graph.ElkNode;

public class SizeEligibilityFilter
implements IEligibilityFilter {
    private IBoundsProvider boundsProvider = new ShapeLayoutBoundsProvider();
    private double maxArea = -1.0;

    public SizeEligibilityFilter withMaximumArea(double area) {
        if (area < 0.0) {
            throw new IllegalArgumentException("Maximum area must be >= 0.");
        }
        this.maxArea = area;
        return this;
    }

    public SizeEligibilityFilter withBoundsProvider(IBoundsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Bounds provider must not be null.");
        }
        this.boundsProvider = provider;
        return this;
    }

    @Override
    public boolean eligibleForAttachment(ElkNode comment) {
        Rectangle2D.Double bounds = this.boundsProvider.boundsFor(comment);
        return bounds.height * bounds.width <= this.maxArea;
    }
}

