/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.calculators;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopOpposingSegment;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.PortSide;

public final class SelfLoopLevelCalculator {
    private static final Comparator<SelfLoopOpposingSegment> OPPOSING_COMPARATOR = (segment1, segment2) -> {
        SelfLoopComponent component1 = segment1.getComponent();
        SelfLoopPort firstPort1 = component1.getPorts().get(0);
        SelfLoopComponent component2 = segment2.getComponent();
        SelfLoopPort firstPort2 = component2.getPorts().get(0);
        SelfLoopPort secondPort2 = component2.getPorts().get(component2.getPorts().size() - 1);
        if (firstPort1.getDirection() == firstPort2.getDirection()) {
            return -1 * Integer.compare(firstPort1.getOriginalIndex(), firstPort2.getOriginalIndex());
        }
        return -1 * Integer.compare(firstPort1.getOriginalIndex(), secondPort2.getOriginalIndex());
    };
    private static final Comparator<Map.Entry<SelfLoopEdge, SelfLoopOpposingSegment>> OPPOSING_NON_HYPER_EDGE_COMPARATOR = (entry1, entry2) -> {
        SelfLoopComponent component2;
        SelfLoopOpposingSegment segment1 = (SelfLoopOpposingSegment)entry1.getValue();
        SelfLoopOpposingSegment segment2 = (SelfLoopOpposingSegment)entry2.getValue();
        SelfLoopComponent component1 = segment1.getComponent();
        if (component1 == (component2 = segment2.getComponent())) {
            Integer order2;
            Integer order1;
            PortSide segmentSide = segment1.getSide();
            SelfLoopEdge edge1 = (SelfLoopEdge)entry1.getKey();
            SelfLoopEdge edge2 = (SelfLoopEdge)entry2.getKey();
            PortSide nextSide = segmentSide.left();
            do {
                order1 = edge1.getEdgeOrders().get(nextSide);
                order2 = edge2.getEdgeOrders().get(nextSide);
                nextSide = segmentSide.left();
            } while (order1 == null && order2 == null);
            return Integer.compare(order1, order2);
        }
        SelfLoopPort firstPort1 = component1.getPorts().get(0);
        SelfLoopPort firstPort2 = component2.getPorts().get(0);
        SelfLoopPort secondPort2 = component2.getPorts().get(component2.getPorts().size() - 1);
        if (firstPort1.getDirection() == firstPort2.getDirection()) {
            return -1 * Integer.compare(firstPort1.getOriginalIndex(), firstPort2.getOriginalIndex());
        }
        return -1 * Integer.compare(firstPort1.getOriginalIndex(), secondPort2.getOriginalIndex());
    };

    private SelfLoopLevelCalculator() {
    }

    public static void calculatePortLevels(SelfLoopNode slNode) {
        for (SelfLoopNodeSide side : slNode.getSides()) {
            ArrayList<SelfLoopComponent> sideComponentDependencies = new ArrayList<SelfLoopComponent>(side.getComponentDependencies());
            if (sideComponentDependencies.isEmpty()) continue;
            int maximumPortLevel = 0;
            maximumPortLevel = SelfLoopLevelCalculator.supportsHyperedges(slNode) ? SelfLoopLevelCalculator.calculateHyperedgePortLevels(side, sideComponentDependencies) : SelfLoopLevelCalculator.calculateNonHyperedgePortMaxLevels(side, sideComponentDependencies);
            side.setMaximumPortLevel(maximumPortLevel);
        }
    }

    public static int calculateHyperedgePortLevels(SelfLoopNodeSide side, List<SelfLoopComponent> components) {
        int maximumLevel = 0;
        int componentLevel = 0;
        for (SelfLoopComponent component : components) {
            List<SelfLoopComponent> sideDependencies = component.getDependencyComponents().get(side);
            componentLevel = sideDependencies == null || sideDependencies.isEmpty() ? 1 : SelfLoopLevelCalculator.calculateHyperedgePortLevels(side, sideDependencies) + 1;
            maximumLevel = Math.max(maximumLevel, componentLevel);
            for (SelfLoopPort port : component.getPorts()) {
                if (port.getPortSide() != side.getSide()) continue;
                port.setMaximumLevel(componentLevel);
            }
        }
        return maximumLevel;
    }

    private static int calculateNonHyperedgePortMaxLevels(SelfLoopNodeSide side, ArrayList<SelfLoopComponent> components) {
        int maximumLevel = 0;
        int componentLevel = 0;
        for (SelfLoopComponent component : components) {
            List<SelfLoopComponent> sideDependencies = component.getDependencyComponents().get(side);
            componentLevel = sideDependencies == null || sideDependencies.isEmpty() ? 1 : SelfLoopLevelCalculator.calculateHyperedgePortLevels(side, sideDependencies) + 1;
            maximumLevel = Math.max(maximumLevel, componentLevel);
            for (SelfLoopPort port : component.getPorts()) {
                if (port.getPortSide() != side.getSide()) continue;
                int connectedEdges = Iterables.size(port.getConnectedEdges());
                port.setMaximumLevel(componentLevel + connectedEdges - 1);
                maximumLevel = Math.max(maximumLevel, componentLevel + connectedEdges - 1);
            }
        }
        return maximumLevel;
    }

    public static void calculateOpposingSegmentLevel(SelfLoopNode slNode) {
        int maximumSegmentLevelOfNode = 0;
        boolean supportHyperedges = SelfLoopLevelCalculator.supportsHyperedges(slNode);
        for (SelfLoopNodeSide side : slNode.getSides()) {
            maximumSegmentLevelOfNode = supportHyperedges ? SelfLoopLevelCalculator.calculateHyperedgeOpposingSegmentMaxLevel(side, new HashSet<SelfLoopOpposingSegment>(side.getOpposingSegments().values())) : SelfLoopLevelCalculator.calculateNonHyperedgeOpposingSegmentMaxLevel(side, side.getOpposingSegments());
            side.setMaximumSegmentLevel(maximumSegmentLevelOfNode);
        }
    }

    private static int calculateHyperedgeOpposingSegmentMaxLevel(SelfLoopNodeSide side, Set<SelfLoopOpposingSegment> segments) {
        ArrayList<SelfLoopOpposingSegment> sortedSegments = new ArrayList<SelfLoopOpposingSegment>(segments);
        sortedSegments.sort(OPPOSING_COMPARATOR);
        int level = side.getMaximumPortLevel();
        for (SelfLoopOpposingSegment segment : sortedSegments) {
            SelfLoopPort levelGivingPort = segment.getLevelGivingPort();
            if (levelGivingPort != null) {
                segment.setLevel(levelGivingPort.getMaximumLevel());
                continue;
            }
            segment.setLevel(++level);
        }
        return level;
    }

    public static int calculateNonHyperedgeOpposingSegmentMaxLevel(SelfLoopNodeSide side, Map<SelfLoopEdge, SelfLoopOpposingSegment> opposingSegments) {
        Set<Map.Entry<SelfLoopEdge, SelfLoopOpposingSegment>> unsortedSegments = opposingSegments.entrySet();
        ArrayList<Map.Entry<SelfLoopEdge, SelfLoopOpposingSegment>> sortedSegments = new ArrayList<Map.Entry<SelfLoopEdge, SelfLoopOpposingSegment>>(unsortedSegments);
        sortedSegments.sort(OPPOSING_NON_HYPER_EDGE_COMPARATOR);
        int level = side.getMaximumPortLevel();
        for (Map.Entry<SelfLoopEdge, SelfLoopOpposingSegment> entry : sortedSegments) {
            SelfLoopOpposingSegment segment = entry.getValue();
            segment.setLevel(++level);
        }
        return level;
    }

    public static void calculateEdgeOrders(List<SelfLoopComponent> components) {
        PortSide[] portSideArray = PortSide.values();
        int n = portSideArray.length;
        int n2 = 0;
        while (n2 < n) {
            PortSide side = portSideArray[n2];
            if (side.ordinal() != 0) {
                for (SelfLoopComponent component : components) {
                    List<SelfLoopEdge> edgeDependencies = component.getEdgeDependencies().get(side);
                    SelfLoopLevelCalculator.calculateEdgeOrder(side, edgeDependencies);
                }
            }
            ++n2;
        }
    }

    private static int calculateEdgeOrder(PortSide side, List<SelfLoopEdge> edgeDependencies) {
        int maximumLevel = 0;
        int componentLevel = 0;
        for (SelfLoopEdge edge : edgeDependencies) {
            List<SelfLoopEdge> nextEdgeDependencies = edge.getDependencyEdges().get(side);
            componentLevel = nextEdgeDependencies == null || nextEdgeDependencies.isEmpty() ? 1 : SelfLoopLevelCalculator.calculateEdgeOrder(side, nextEdgeDependencies) + 1;
            maximumLevel = Math.max(maximumLevel, componentLevel);
        }
        for (SelfLoopEdge edge : edgeDependencies) {
            Map<PortSide, Integer> orderMap = edge.getEdgeOrders();
            orderMap.put(side, maximumLevel);
        }
        return maximumLevel;
    }

    private static boolean supportsHyperedges(SelfLoopNode nodeRep) {
        return nodeRep.getNode().getGraph().getProperty(LayeredOptions.EDGE_ROUTING) != EdgeRouting.SPLINES;
    }
}

