/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.options.NodeLabelPlacement;

public final class BigNodesLabelHandler {
    private BigNodesLabelHandler() {
    }

    public static void handle(LNode node, List<LNode> dummies, double chunkWidth) {
        new Handler(node, dummies, chunkWidth);
    }

    private static final class CompoundFunction
    implements Function<Void, Void> {
        private Function<Void, Void>[] funs;

        CompoundFunction(Function<Void, Void> ... funs) {
            this.funs = funs;
        }

        public static CompoundFunction of(List<Function<Void, Void>> funs) {
            Function[] funsArr = new Function[funs.size()];
            int i = 0;
            for (Function<Void, Void> f : funs) {
                funsArr[i++] = f;
            }
            return new CompoundFunction(funsArr);
        }

        public Void apply(Void v) {
            Function<Void, Void>[] functionArray = this.funs;
            int n = this.funs.length;
            int n2 = 0;
            while (n2 < n) {
                Function<Void, Void> f = functionArray[n2];
                f.apply(null);
                ++n2;
            }
            return null;
        }
    }

    private static final class Handler {
        private LNode node;
        private int chunks;
        private double minWidth;
        private ArrayList<LNode> dummies;
        private LNode lastDummy = null;
        private ArrayListMultimap<LLabel, LLabel> dumLabs = ArrayListMultimap.create();
        private List<Function<Void, Void>> postProcs = Lists.newArrayList();
        private Function<Void, Void> funRemoveLabelDummies = new Function<Void, Void>(){

            public Void apply(Void v) {
                for (LNode dummy : dummies) {
                    for (LLabel l : Lists.newLinkedList(dummy.getLabels())) {
                        if (l.getProperty(InternalProperties.ORIGIN) != null) continue;
                        dummy.getLabels().remove((Object)l);
                    }
                }
                return null;
            }
        };

        Handler(LNode node, List<LNode> dummies, double chunkWidth) {
            this.node = node;
            this.chunks = dummies.size();
            this.dummies = dummies instanceof ArrayList ? (ArrayList)dummies : Lists.newArrayList(dummies);
            this.lastDummy = this.dummies.get(this.dummies.size() - 1);
            this.minWidth = chunkWidth;
            this.handleLabels();
        }

        public void handleLabels() {
            this.node.setProperty(InternalProperties.BIGNODES_ORIG_LABELS, Lists.newLinkedList(this.node.getLabels()));
            int i = 1;
            while (i < this.dummies.size() - 1) {
                this.dummies.get(i).setProperty(LayeredOptions.NODE_LABELS_PLACEMENT, NodeLabelPlacement.insideCenter());
                ++i;
            }
            for (final LLabel l : Lists.newLinkedList(this.node.getLabels())) {
                EnumSet placement = (EnumSet)this.node.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT);
                if (placement.containsAll(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.V_CENTER))) continue;
                if (placement.containsAll(EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.V_CENTER))) {
                    this.lastDummy.getLabels().add(l);
                    this.node.getLabels().remove((Object)l);
                    Function<Void, Void> postProcess = new Function<Void, Void>(){

                        public Void apply(Void v) {
                            l.getPosition().x += minWidth * (double)(chunks - 1);
                            return null;
                        }
                    };
                    this.node.setProperty(InternalProperties.BIGNODES_POST_PROCESS, postProcess);
                    continue;
                }
                this.splitAndDistributeLabel(l);
                this.postProcs.add(this.funRemoveLabelDummies);
                this.node.setProperty(InternalProperties.BIGNODES_POST_PROCESS, CompoundFunction.of(this.postProcs));
            }
        }

        private void splitAndDistributeLabel(LLabel lab) {
            int length = lab.getText().length();
            int labelChunkSize = (int)Math.ceil((double)length / (double)this.chunks);
            String text = lab.getText();
            int lPos = 0;
            int rPos = labelChunkSize;
            int i = 0;
            while (i < this.chunks) {
                String subLabel = text.substring(Math.min(Math.max(0, lPos), length), Math.max(0, Math.min(rPos, length)));
                lPos = rPos;
                rPos += labelChunkSize;
                LNode dummy = this.dummies.get(i);
                LLabel dumLab = new LLabel(subLabel);
                dumLab.getSize().y = lab.getSize().y;
                this.dumLabs.put((Object)lab, (Object)dumLab);
                dummy.getLabels().add(dumLab);
                ++i;
            }
            this.node.getLabels().remove((Object)lab);
            this.postProcs.add(this.getPostProcFunctionForLabel(lab));
        }

        private Function<Void, Void> getPostProcFunctionForLabel(final LLabel label) {
            Function<Void, Void> fun = new Function<Void, Void>(){

                public Void apply(Void v) {
                    EnumSet placement = (EnumSet)node.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT);
                    if (!placement.equals(NodeLabelPlacement.fixed())) {
                        if (placement.containsAll(EnumSet.of(NodeLabelPlacement.H_LEFT))) {
                            LLabel dumLab = (LLabel)((Object)dumLabs.get((Object)label).get(0));
                            label.getPosition().x = dumLab.getPosition().x;
                            label.getPosition().y = dumLab.getPosition().y;
                        } else if (placement.containsAll(EnumSet.of(NodeLabelPlacement.H_RIGHT))) {
                            LNode rightMostDum = (LNode)((Object)dummies.get(dummies.size() - 1));
                            LLabel rightMostLab = (LLabel)((Object)dumLabs.get((Object)label).get(dumLabs.get((Object)label).size() - 1));
                            double rightOffset = rightMostDum.getSize().x - (rightMostLab.getPosition().x + rightMostLab.getSize().x);
                            label.getPosition().x = ((Handler)this).node.getSize().x - rightOffset - label.getSize().x;
                            label.getPosition().y = rightMostLab.getPosition().y;
                        } else if (placement.containsAll(EnumSet.of(NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_CENTER))) {
                            LLabel dumLab = (LLabel)((Object)dumLabs.get((Object)label).get(0));
                            label.getPosition().x = (((Handler)this).node.getSize().x - label.getSize().x) / 2.0;
                            label.getPosition().y = dumLab.getPosition().y;
                        } else if (placement.containsAll(EnumSet.of(NodeLabelPlacement.V_CENTER))) {
                            LLabel dumLab = (LLabel)((Object)dumLabs.get((Object)label).get(0));
                            label.getPosition().y = dumLab.getPosition().y;
                        } else if (placement.containsAll(EnumSet.of(NodeLabelPlacement.H_CENTER))) {
                            LLabel dumLab = (LLabel)((Object)dumLabs.get((Object)label).get(0));
                            label.getPosition().x = (((Handler)this).node.getSize().x - label.getSize().x) / 2.0;
                            label.getPosition().y = dumLab.getPosition().y;
                        }
                    }
                    return null;
                }
            };
            return fun;
        }
    }
}

