/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.position;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.position.AbstractSelfLoopPortPositioner;
import org.eclipse.elk.core.options.PortSide;

public class EquallyDistributedSelfLoopPortPositioner
extends AbstractSelfLoopPortPositioner {
    private SelfLoopNode slNode;

    @Override
    public void position(LNode node) {
        this.slNode = (SelfLoopNode)node.getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        List<SelfLoopComponent> components = this.slNode.getSelfLoopComponents();
        components.sort((comp1, comp2) -> Integer.compare(comp1.getPorts().size(), comp2.getPorts().size()));
        ArrayList<SelfLoopComponent> nonLoopWest = new ArrayList<SelfLoopComponent>();
        ArrayList<SelfLoopComponent> nonLoopEast = new ArrayList<SelfLoopComponent>();
        this.distributeNonLoops(node, components, nonLoopWest, nonLoopEast);
        ArrayListMultimap sides = ArrayListMultimap.create();
        this.distributeComponentsEqually(components, (Multimap<Sides, SelfLoopComponent>)sides);
        this.stackComponents(this.slNode, sides.get((Object)Sides.NORTH), PortSide.NORTH);
        this.stackComponents(this.slNode, sides.get((Object)Sides.SOUTH), PortSide.SOUTH);
        this.stackComponents(this.slNode, sides.get((Object)Sides.EAST), PortSide.EAST);
        this.stackComponents(this.slNode, sides.get((Object)Sides.WEST), PortSide.WEST);
        this.placeNonLoopPorts(this.slNode, PortSide.WEST, nonLoopWest);
        this.placeNonLoopPorts(this.slNode, PortSide.EAST, nonLoopEast);
        this.stackCornerComponents(this.slNode, sides.get((Object)Sides.NORTH_WEST_CORNER), PortSide.WEST, PortSide.NORTH);
        this.stackCornerComponents(this.slNode, sides.get((Object)Sides.NORTH_EAST_CORNER), PortSide.NORTH, PortSide.EAST);
        this.stackCornerComponents(this.slNode, sides.get((Object)Sides.SOUTH_EAST_CORNER), PortSide.EAST, PortSide.SOUTH);
        this.stackCornerComponents(this.slNode, sides.get((Object)Sides.SOUTH_WEST_CORNER), PortSide.SOUTH, PortSide.WEST);
    }

    private void distributeComponentsEqually(List<SelfLoopComponent> components, Multimap<Sides, SelfLoopComponent> sides) {
        Sides[] availableSides = Sides.values();
        int currSideIndex = 0;
        for (SelfLoopComponent component : components) {
            sides.put((Object)availableSides[currSideIndex], (Object)component);
            currSideIndex = (currSideIndex + 1) % availableSides.length;
        }
    }

    private void distributeNonLoops(LNode node, List<SelfLoopComponent> components, List<SelfLoopComponent> nonLoopWest, List<SelfLoopComponent> nonLoopEast) {
        List nonLoopComponents = components.stream().filter(comp -> comp.getPorts().size() == 1).collect(Collectors.toList());
        Layer currentLayer = node.getLayer();
        int currentLayerIndex = currentLayer.getIndex();
        for (SelfLoopComponent component : nonLoopComponents) {
            SelfLoopPort port = component.getPorts().get(0);
            port.setPortSide(PortSide.UNDEFINED);
            LPort lport = port.getLPort();
            for (LEdge edge : lport.getConnectedEdges()) {
                LPort relevantPort = edge.getTarget() == lport ? edge.getSource() : edge.getTarget();
                Layer layer = relevantPort.getNode().getLayer();
                if (currentLayerIndex <= layer.getIndex()) continue;
                port.setPortSide(PortSide.WEST);
                nonLoopWest.add(component);
                break;
            }
            if (port.getPortSide() != PortSide.UNDEFINED) continue;
            port.setPortSide(PortSide.EAST);
            nonLoopEast.add(component);
        }
        components.removeAll(nonLoopComponents);
    }

    private static enum Sides {
        NORTH,
        SOUTH,
        EAST,
        WEST,
        NORTH_WEST_CORNER,
        NORTH_EAST_CORNER,
        SOUTH_WEST_CORNER,
        SOUTH_EAST_CORNER;

    }
}

