/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.IGraphLayoutEngine;
import org.eclipse.elk.core.UnsupportedConfigurationException;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutAlgorithmResolver;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.core.testing.TestController;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.GraphFeature;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class RecursiveGraphLayoutEngine
implements IGraphLayoutEngine {
    @Override
    public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        this.layout(layoutGraph, null, progressMonitor);
    }

    public void layout(ElkNode layoutGraph, TestController testController, IElkProgressMonitor progressMonitor) {
        int nodeCount = this.countNodesRecursively(layoutGraph, true);
        progressMonitor.begin("Recursive Graph Layout", nodeCount);
        if (!layoutGraph.hasProperty(CoreOptions.RESOLVED_ALGORITHM)) {
            ElkUtil.applyVisitors(layoutGraph, new LayoutAlgorithmResolver());
        }
        this.layoutRecursively(layoutGraph, testController, progressMonitor);
        progressMonitor.done();
    }

    protected List<ElkEdge> layoutRecursively(ElkNode layoutNode, TestController testController, IElkProgressMonitor progressMonitor) {
        boolean hasInsideSelfLoops;
        if (progressMonitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (((Boolean)layoutNode.getProperty(CoreOptions.NO_LAYOUT)).booleanValue()) {
            return Collections.emptyList();
        }
        boolean hasChildren = !layoutNode.getChildren().isEmpty();
        List<ElkEdge> insideSelfLoops = this.gatherInsideSelfLoops(layoutNode);
        boolean bl = hasInsideSelfLoops = !insideSelfLoops.isEmpty();
        if (hasChildren || hasInsideSelfLoops) {
            int nodeCount;
            LayoutAlgorithmData algorithmData = (LayoutAlgorithmData)layoutNode.getProperty(CoreOptions.RESOLVED_ALGORITHM);
            if (algorithmData == null) {
                throw new UnsupportedConfigurationException("Resolved algorithm is not set; apply a LayoutAlgorithmResolver before computing layout.");
            }
            boolean supportsInsideSelfLoops = algorithmData.supportsFeature(GraphFeature.INSIDE_SELF_LOOPS);
            this.evaluateHierarchyHandlingInheritance(layoutNode);
            if (!hasChildren && hasInsideSelfLoops && !supportsInsideSelfLoops) {
                return Collections.emptyList();
            }
            ArrayList childrenInsideSelfLoops = Lists.newArrayList();
            if (layoutNode.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN && (algorithmData.supportsFeature(GraphFeature.COMPOUND) || algorithmData.supportsFeature(GraphFeature.CLUSTERS))) {
                nodeCount = this.countNodesWithHierarchy(layoutNode);
                LinkedList nodeQueue = Lists.newLinkedList();
                nodeQueue.addAll(layoutNode.getChildren());
                while (!nodeQueue.isEmpty()) {
                    boolean stopHierarchy;
                    ElkNode node = (ElkNode)nodeQueue.poll();
                    this.evaluateHierarchyHandlingInheritance(node);
                    boolean bl2 = stopHierarchy = node.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.SEPARATE_CHILDREN;
                    if (stopHierarchy || node.hasProperty(CoreOptions.ALGORITHM) && !algorithmData.equals(node.getProperty(CoreOptions.RESOLVED_ALGORITHM))) {
                        List<ElkEdge> childLayoutSelfLoops = this.layoutRecursively(node, testController, progressMonitor);
                        childrenInsideSelfLoops.addAll(childLayoutSelfLoops);
                        node.setProperty(CoreOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.SEPARATE_CHILDREN);
                        ElkUtil.applyConfiguredNodeScaling(node);
                        continue;
                    }
                    nodeQueue.addAll(node.getChildren());
                }
            } else {
                nodeCount = layoutNode.getChildren().size();
                for (ElkNode child : layoutNode.getChildren()) {
                    List<ElkEdge> childLayoutSelfLoops = this.layoutRecursively(child, testController, progressMonitor);
                    childrenInsideSelfLoops.addAll(childLayoutSelfLoops);
                    ElkUtil.applyConfiguredNodeScaling(child);
                }
            }
            if (progressMonitor.isCanceled()) {
                return Collections.emptyList();
            }
            for (ElkEdge selfLoop : childrenInsideSelfLoops) {
                selfLoop.setProperty(CoreOptions.NO_LAYOUT, (Object)true);
            }
            this.executeAlgorithm(layoutNode, algorithmData, testController, progressMonitor.subTask(nodeCount));
            this.postProcessInsideSelfLoops(childrenInsideSelfLoops);
            if (hasInsideSelfLoops && supportsInsideSelfLoops) {
                return insideSelfLoops;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    protected void executeAlgorithm(ElkNode layoutNode, LayoutAlgorithmData algorithmData, TestController testController, IElkProgressMonitor progressMonitor) {
        AbstractLayoutProvider layoutProvider = algorithmData.getInstancePool().fetch();
        if (testController != null && testController.targets(algorithmData)) {
            testController.install(layoutProvider);
        }
        try {
            layoutProvider.layout(layoutNode, progressMonitor);
            algorithmData.getInstancePool().release(layoutProvider);
        }
        catch (Exception exception) {
            layoutProvider.dispose();
            throw exception;
        }
    }

    protected int countNodesRecursively(ElkNode layoutNode, boolean countAncestors) {
        int count = layoutNode.getChildren().size();
        for (ElkNode childNode : layoutNode.getChildren()) {
            if (childNode.getChildren().isEmpty()) continue;
            count += this.countNodesRecursively(childNode, false);
        }
        if (countAncestors) {
            ElkNode parent = layoutNode.getParent();
            while (parent != null) {
                count += parent.getChildren().size();
                parent = parent.getParent();
            }
        }
        return count;
    }

    private void evaluateHierarchyHandlingInheritance(ElkNode layoutNode) {
        if (layoutNode.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.INHERIT) {
            if (layoutNode.getParent() == null) {
                layoutNode.setProperty(CoreOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.SEPARATE_CHILDREN);
            } else {
                HierarchyHandling parentHandling = (HierarchyHandling)((Object)layoutNode.getParent().getProperty(CoreOptions.HIERARCHY_HANDLING));
                layoutNode.setProperty(CoreOptions.HIERARCHY_HANDLING, (Object)parentHandling);
            }
        }
    }

    private int countNodesWithHierarchy(ElkNode parentNode) {
        int count = parentNode.getChildren().size();
        for (ElkNode childNode : parentNode.getChildren()) {
            LayoutAlgorithmData childData;
            LayoutAlgorithmData parentData;
            if (childNode.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.SEPARATE_CHILDREN || (parentData = (LayoutAlgorithmData)parentNode.getProperty(CoreOptions.RESOLVED_ALGORITHM)) != (childData = (LayoutAlgorithmData)childNode.getProperty(CoreOptions.RESOLVED_ALGORITHM)) && (parentData == null || !parentData.equals(childData)) || childNode.getChildren().isEmpty()) continue;
            count += this.countNodesWithHierarchy(childNode);
        }
        return count;
    }

    protected List<ElkEdge> gatherInsideSelfLoops(ElkNode node) {
        if (((Boolean)node.getProperty(CoreOptions.INSIDE_SELF_LOOPS_ACTIVATE)).booleanValue()) {
            ArrayList insideSelfLoops = Lists.newArrayList();
            for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges((ElkNode)node)) {
                if (!edge.isSelfloop() || !((Boolean)edge.getProperty(CoreOptions.INSIDE_SELF_LOOPS_YO)).booleanValue()) continue;
                insideSelfLoops.add(edge);
            }
            return insideSelfLoops;
        }
        return Collections.emptyList();
    }

    protected void postProcessInsideSelfLoops(List<ElkEdge> insideSelfLoops) {
        for (ElkEdge selfLoop : insideSelfLoops) {
            ElkNode node = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)selfLoop.getSources().get(0)));
            double xOffset = node.getX();
            double yOffset = node.getY();
            ElkEdgeSection section = (ElkEdgeSection)selfLoop.getSections().get(0);
            section.setStartLocation(section.getStartX() + xOffset, section.getStartY() + yOffset);
            section.setEndLocation(section.getEndX() + xOffset, section.getEndY() + yOffset);
            for (ElkBendPoint bend : section.getBendPoints()) {
                bend.set(bend.getX() + xOffset, bend.getY() + yOffset);
            }
            ((KVectorChain)selfLoop.getProperty(CoreOptions.JUNCTION_POINTS)).offset(xOffset, yOffset);
        }
    }
}

