/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.rendering;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.EdgeType;
import org.eclipse.elk.core.ui.rendering.GraphRenderingConfigurator;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;

public class GraphRenderer {
    private static final double ARROW_LENGTH = 8.0;
    private static final double ARROW_WIDTH = 7.0;
    private static final int MIN_FONT_HEIGHT = 3;
    private final Map<Object, PaintRectangle> boundsMap = new LinkedHashMap<Object, PaintRectangle>();
    private GraphRenderingConfigurator configurator;
    private double scale = 1.0;
    private KVector baseOffset = new KVector();
    private ElkNode mostRecentlyDrawnGraph = null;

    public GraphRenderer(GraphRenderingConfigurator configurator) {
        this.configurator = configurator;
    }

    public void dispose() {
        this.flushCache();
        this.mostRecentlyDrawnGraph = null;
        this.configurator.dispose();
    }

    public KVector getBaseOffset() {
        return this.baseOffset;
    }

    public void setBaseOffset(KVector baseOffset) {
        this.baseOffset = baseOffset == null ? new KVector() : baseOffset;
        this.flushCache();
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.configurator.setScale(scale);
        this.flushCache();
    }

    private int scale(double value) {
        return (int)Math.round(this.scale * value);
    }

    public void markDirty(Rectangle area) {
        for (PaintRectangle rectangle : this.boundsMap.values()) {
            if (area != null && !rectangle.intersects(area)) continue;
            rectangle.painted = false;
        }
    }

    private void flushCache() {
        this.boundsMap.clear();
    }

    public void render(ElkNode parentNode, GC graphics, Rectangle area) {
        if (this.mostRecentlyDrawnGraph != parentNode) {
            this.flushCache();
            this.mostRecentlyDrawnGraph = parentNode;
        }
        graphics.setInterpolation(2);
        int maxDepth = Math.max(this.maxDepth(parentNode), 1);
        int nodeAlpha = 200 / maxDepth + 55;
        graphics.setBackground(this.configurator.getOutOfBoundsColor());
        graphics.fillRectangle(area.x, area.y, area.width, area.height);
        graphics.setBackground(this.configurator.getRootNodeColor());
        graphics.fillRectangle((int)this.baseOffset.x, (int)this.baseOffset.y, this.scale(parentNode.getWidth() + 1.0), this.scale(parentNode.getHeight() + 1.0));
        this.renderNodeChildren(parentNode, graphics, area, this.baseOffset, nodeAlpha);
        if (parentNode.getWidth() == 0.0 && parentNode.getHeight() == 0.0 && (this.baseOffset.x > 0.0 || this.baseOffset.y > 0.0)) {
            this.renderOriginCoordinatesOfGraph(graphics);
        }
    }

    private void renderNodeChildren(ElkNode parent, GC graphics, Rectangle area, KVector offset, int nodeAlpha) {
        for (ElkNode childNode : parent.getChildren()) {
            PaintRectangle rect = this.boundsMap.get(childNode);
            if (rect == null) {
                rect = new PaintRectangle((ElkShape)childNode, offset, this.scale);
                this.boundsMap.put(childNode, rect);
            }
            KVector childOffset = new KVector((double)rect.x, (double)rect.y);
            if (!rect.painted && rect.intersects(area)) {
                graphics.setAlpha(nodeAlpha);
                if (this.configurator.getNodeFillColor() != null) {
                    graphics.setBackground(this.configurator.getNodeFillColor());
                    graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
                }
                if (this.configurator.getNodeBorderColor() != null) {
                    graphics.setForeground(this.configurator.getNodeBorderColor());
                    graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
                }
                rect.painted = true;
                this.renderNodeChildren(childNode, graphics, area, childOffset, nodeAlpha);
            }
            if (this.configurator.getNodeLabelFont() != null) {
                graphics.setFont(this.configurator.getNodeLabelFont());
                for (ElkLabel label : childNode.getLabels()) {
                    this.renderLabel(label, graphics, area, childOffset, nodeAlpha);
                }
            }
            for (ElkPort port : childNode.getPorts()) {
                this.renderPort(port, graphics, area, childOffset, nodeAlpha);
            }
        }
        for (ElkEdge childEdge : parent.getContainedEdges()) {
            this.renderEdge(childEdge, graphics, area, offset, nodeAlpha);
        }
    }

    private void renderLabel(ElkLabel label, GC graphics, Rectangle area, KVector offset, int labelAlpha) {
        if (graphics.getFont().getFontData()[0].getHeight() >= 3) {
            PaintRectangle rect = this.boundsMap.get(label);
            if (rect == null) {
                rect = new PaintRectangle((ElkShape)label, offset, this.scale);
                this.boundsMap.put(label, rect);
            }
            if (!rect.painted && rect.intersects(area)) {
                String text;
                graphics.setAlpha(labelAlpha);
                if (this.configurator.getLabelFillColor() != null) {
                    graphics.setBackground(this.configurator.getLabelFillColor());
                    graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
                }
                if (this.configurator.getLabelBorderColor() != null) {
                    graphics.setForeground(this.configurator.getLabelBorderColor());
                    graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
                }
                if ((text = label.getText()) != null && text.length() > 0) {
                    graphics.setAlpha(255);
                    graphics.setForeground(this.configurator.getLabelTextColor());
                    Rectangle oldClip = graphics.isClipped() ? graphics.getClipping() : null;
                    graphics.setClipping(rect.x, rect.y, rect.width, rect.height);
                    graphics.drawString(text, rect.x, rect.y, true);
                    graphics.setClipping(oldClip);
                }
                rect.painted = true;
            }
        }
    }

    private void renderPort(ElkPort port, GC graphics, Rectangle area, KVector offset, int labelAlpha) {
        PaintRectangle rect = this.boundsMap.get(port);
        if (rect == null) {
            rect = new PaintRectangle((ElkShape)port, offset, this.scale);
            this.boundsMap.put(port, rect);
        }
        if (!rect.painted && rect.intersects(area)) {
            graphics.setAlpha(255);
            if (this.configurator.getPortFillColor() != null) {
                graphics.setBackground(this.configurator.getPortFillColor());
                graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
            }
            if (this.configurator.getPortBorderColor() != null) {
                graphics.setForeground(this.configurator.getPortBorderColor());
                graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
            }
            rect.painted = true;
        }
        if (this.configurator.getPortLabelFont() != null) {
            graphics.setFont(this.configurator.getPortLabelFont());
            KVector portOffset = new KVector((double)rect.x, (double)rect.y);
            for (ElkLabel label : port.getLabels()) {
                this.renderLabel(label, graphics, area, portOffset, labelAlpha);
            }
        }
    }

    private void renderEdge(ElkEdge edge, GC graphics, Rectangle area, KVector offset, int labelAlpha) {
        KVectorChain vc;
        if (this.configurator.getEdgeColor() == null) {
            return;
        }
        if (this.isEdgeFullyContainedInGraphToDraw(edge)) {
            PaintRectangle rect = this.boundsMap.get(edge);
            if (rect == null) {
                rect = new PaintRectangle(edge, offset, this.scale);
                this.boundsMap.put(edge, rect);
            }
            if (!rect.painted && rect.intersects(area)) {
                boolean splineEdge = edge.getProperty(CoreOptions.EDGE_ROUTING) == EdgeRouting.SPLINES;
                boolean directedEdge = edge.getProperty(CoreOptions.EDGE_TYPE) != EdgeType.UNDIRECTED;
                graphics.setAlpha(255);
                graphics.setForeground(this.configurator.getEdgeColor());
                graphics.setBackground(this.configurator.getEdgeColor());
                for (ElkEdgeSection edgeSection : edge.getSections()) {
                    KVector referencePoint;
                    KVectorChain bendPoints = ElkUtil.createVectorChain((ElkEdgeSection)edgeSection);
                    bendPoints.scale(this.scale).offset(offset);
                    Path path = new Path(graphics.getDevice());
                    Iterator pointIter = bendPoints.iterator();
                    KVector startPoint = (KVector)pointIter.next();
                    path.moveTo((float)startPoint.x, (float)startPoint.y);
                    KVector point1 = null;
                    KVector point2 = null;
                    while (pointIter.hasNext()) {
                        if (splineEdge) {
                            if (point1 == null) {
                                point1 = (KVector)pointIter.next();
                                continue;
                            }
                            if (point2 == null) {
                                point2 = (KVector)pointIter.next();
                                continue;
                            }
                            KVector endPoint = (KVector)pointIter.next();
                            path.cubicTo((float)point1.x, (float)point1.y, (float)point2.x, (float)point2.y, (float)endPoint.x, (float)endPoint.y);
                            point1 = null;
                            point2 = null;
                            continue;
                        }
                        KVector nextPoint = (KVector)pointIter.next();
                        path.lineTo((float)nextPoint.x, (float)nextPoint.y);
                    }
                    if (splineEdge && point2 != null) {
                        path.quadTo((float)point1.x, (float)point1.y, (float)point2.x, (float)point2.y);
                    } else if (splineEdge && point1 != null) {
                        path.lineTo((float)point1.x, (float)point1.y);
                    }
                    graphics.drawPath(path);
                    if (!directedEdge) continue;
                    if (splineEdge && (bendPoints.size() - 1) % 3 != 1) {
                        int beginIndex = (bendPoints.size() - 1) % 3 == 2 ? bendPoints.size() - 2 : bendPoints.size() - 3;
                        referencePoint = ElkMath.getPointOnBezierSegment((double)0.5, (KVector[])bendPoints.toArray(beginIndex));
                    } else {
                        referencePoint = (KVector)bendPoints.get(bendPoints.size() - 2);
                    }
                    int[] arrowPoly = this.makeArrow(referencePoint, (KVector)bendPoints.getLast());
                    if (arrowPoly == null) continue;
                    graphics.fillPolygon(arrowPoly);
                }
                rect.painted = true;
            }
        }
        if ((vc = (KVectorChain)edge.getProperty(CoreOptions.JUNCTION_POINTS)) != null) {
            for (KVector v : vc) {
                KVector center = v.clone().scale(this.scale).add(offset).sub(2.0, 2.0);
                graphics.fillOval((int)center.x, (int)center.y, 6, 6);
            }
        }
        if (this.configurator.getEdgeLabelFont() != null) {
            graphics.setFont(this.configurator.getEdgeLabelFont());
            for (ElkLabel label : edge.getLabels()) {
                this.renderLabel(label, graphics, area, offset, labelAlpha);
            }
        }
    }

    private int[] makeArrow(KVector point1, KVector point2) {
        if ((point1.x != point2.x || point1.y != point2.y) && 7.0 * this.scale >= 2.0) {
            int[] arrow = new int[6];
            arrow[0] = (int)Math.round(point2.x);
            arrow[1] = (int)Math.round(point2.y);
            double vectX = point1.x - point2.x;
            double vectY = point1.y - point2.y;
            double length = Math.sqrt(vectX * vectX + vectY * vectY);
            double normX = vectX / length;
            double normY = vectY / length;
            double neckX = point2.x + 8.0 * normX * this.scale;
            double neckY = point2.y + 8.0 * normY * this.scale;
            double orthX = normY * 7.0 / 2.0 * this.scale;
            double orthY = -normX * 7.0 / 2.0 * this.scale;
            arrow[2] = (int)Math.round(neckX + orthX);
            arrow[3] = (int)Math.round(neckY + orthY);
            arrow[4] = (int)Math.round(neckX - orthX);
            arrow[5] = (int)Math.round(neckY - orthY);
            return arrow;
        }
        return null;
    }

    private void renderOriginCoordinatesOfGraph(GC graphics) {
        Path pathX = new Path(graphics.getDevice());
        Path pathY = new Path(graphics.getDevice());
        float x = (float)this.baseOffset.x;
        float y = (float)this.baseOffset.y;
        pathX.moveTo(x, y);
        pathY.moveTo(x, y);
        pathX.lineTo(x + 5.0f, y);
        pathY.lineTo(x, y + 5.0f);
        graphics.drawPath(pathX);
        graphics.drawPath(pathY);
    }

    private int maxDepth(ElkNode parent) {
        int maxDepth = 0;
        for (ElkNode child : parent.getChildren()) {
            int depth = this.maxDepth(child) + 1;
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth;
    }

    private boolean isEdgeFullyContainedInGraphToDraw(ElkEdge childEdge) {
        return this.areDescendantsOf((List<ElkConnectableShape>)childEdge.getSources()) && this.areDescendantsOf((List<ElkConnectableShape>)childEdge.getTargets());
    }

    private boolean areDescendantsOf(List<ElkConnectableShape> shapes) {
        for (ElkConnectableShape child : shapes) {
            if (ElkGraphUtil.isDescendant((ElkNode)ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)child), (ElkNode)this.mostRecentlyDrawnGraph)) continue;
            return false;
        }
        return true;
    }

    public void calculateBaseOffsetFromTopLevelGraph(ElkNode parent) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        for (ElkNode childNode : parent.getChildren()) {
            minX = Math.min(minX, childNode.getX());
            minY = Math.min(minY, childNode.getY());
            for (ElkLabel childNodeLabel : childNode.getLabels()) {
                minX = Math.min(minX, childNode.getX() + childNodeLabel.getX());
                minY = Math.min(minY, childNode.getY() + childNodeLabel.getY());
            }
        }
        for (ElkEdge edge : parent.getContainedEdges()) {
            PaintRectangle edgeRect = new PaintRectangle(edge, new KVector(), this.scale);
            minX = Math.min(minX, (double)edgeRect.x);
            minY = Math.min(minY, (double)edgeRect.y);
            for (ElkLabel edgeLabel : edge.getLabels()) {
                minX = Math.min(minX, edgeLabel.getX());
                minY = Math.min(minY, edgeLabel.getY());
            }
        }
        this.baseOffset.x = -Math.min(0.0, minX);
        this.baseOffset.y = -Math.min(0.0, minY);
    }

    private static class PaintRectangle {
        private int x;
        private int y;
        private int width;
        private int height;
        private boolean painted = false;

        PaintRectangle(ElkShape shape, KVector offset, double scale) {
            this.x = (int)Math.round(shape.getX() * scale + offset.x);
            this.y = (int)Math.round(shape.getY() * scale + offset.y);
            this.width = Math.max((int)Math.round(shape.getWidth() * scale), 1);
            this.height = Math.max((int)Math.round(shape.getHeight() * scale), 1);
        }

        PaintRectangle(ElkEdge edge, KVector offset, double scale) {
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double minY = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            for (ElkEdgeSection edgeSection : edge.getSections()) {
                minX = Math.min(minX, edgeSection.getStartX());
                minY = Math.min(minY, edgeSection.getStartY());
                maxX = Math.max(maxX, edgeSection.getStartX());
                maxY = Math.max(maxY, edgeSection.getStartY());
                minX = Math.min(minX, edgeSection.getEndX());
                minY = Math.min(minY, edgeSection.getEndY());
                maxX = Math.max(maxX, edgeSection.getEndX());
                maxY = Math.max(maxY, edgeSection.getEndY());
                for (ElkBendPoint bendPoint : edgeSection.getBendPoints()) {
                    minX = Math.min(minX, bendPoint.getX());
                    minY = Math.min(minY, bendPoint.getY());
                    maxX = Math.max(maxX, bendPoint.getX());
                    maxY = Math.max(maxY, bendPoint.getY());
                }
            }
            this.x = (int)Math.round(minX * scale + offset.x);
            this.y = (int)Math.round(minY * scale + offset.y);
            this.width = (int)Math.round((maxX - minX) * scale);
            this.height = (int)Math.round((maxY - minY) * scale);
        }

        public boolean intersects(Rectangle other) {
            return other.x < this.x + this.width && other.y < this.y + this.height && other.x + other.width > this.x && other.y + other.height > this.y;
        }
    }
}

