/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.options;

import java.util.EnumSet;
import org.eclipse.elk.alg.rectpacking.options.OptimizationGoal;
import org.eclipse.elk.alg.rectpacking.options.RectPackingOptions;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class RectPackingMetaDataProvider
implements ILayoutMetaDataProvider {
    private static final OptimizationGoal OPTIMIZATION_GOAL_DEFAULT = OptimizationGoal.MAX_SCALE_DRIVEN;
    public static final IProperty<OptimizationGoal> OPTIMIZATION_GOAL = new Property("org.eclipse.elk.rectpacking.optimizationGoal", (Object)OPTIMIZATION_GOAL_DEFAULT, null, null);
    private static final boolean LAST_PLACE_SHIFT_DEFAULT = true;
    public static final IProperty<Boolean> LAST_PLACE_SHIFT = new Property("org.eclipse.elk.rectpacking.lastPlaceShift", (Object)true, null, null);
    private static final int CURRENT_POSITION_DEFAULT = -1;
    private static final Comparable<? super Integer> CURRENT_POSITION_LOWER_BOUND = -1;
    public static final IProperty<Integer> CURRENT_POSITION = new Property("org.eclipse.elk.rectpacking.currentPosition", (Object)-1, CURRENT_POSITION_LOWER_BOUND, null);
    private static final int DESIRED_POSITION_DEFAULT = -1;
    private static final Comparable<? super Integer> DESIRED_POSITION_LOWER_BOUND = -1;
    public static final IProperty<Integer> DESIRED_POSITION = new Property("org.eclipse.elk.rectpacking.desiredPosition", (Object)-1, DESIRED_POSITION_LOWER_BOUND, null);
    private static final boolean ONLY_FIRST_ITERATION_DEFAULT = false;
    public static final IProperty<Boolean> ONLY_FIRST_ITERATION = new Property("org.eclipse.elk.rectpacking.onlyFirstIteration", (Object)false, null, null);
    private static final boolean ROW_COMPACTION_DEFAULT = true;
    public static final IProperty<Boolean> ROW_COMPACTION = new Property("org.eclipse.elk.rectpacking.rowCompaction", (Object)true, null, null);
    private static final boolean EXPAND_TO_ASPECT_RATIO_DEFAULT = false;
    public static final IProperty<Boolean> EXPAND_TO_ASPECT_RATIO = new Property("org.eclipse.elk.rectpacking.expandToAspectRatio", (Object)false, null, null);
    private static final double TARGET_WIDTH_DEFAULT = -1.0;
    public static final IProperty<Double> TARGET_WIDTH = new Property("org.eclipse.elk.rectpacking.targetWidth", (Object)-1.0, null, null);

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.optimizationGoal").group("").name("Optimization Goal").description("Optimization goal for approximation of the bounding box given by the first iteration. Determines whether layout is sorted by the maximum scaling, aspect ratio, or area. Depending on the strategy the aspect ratio might be nearly ignored.").defaultValue((Object)OPTIMIZATION_GOAL_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(OptimizationGoal.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.lastPlaceShift").group("").name("Shift Last Placed.").description("When placing a rectangle behind or below the last placed rectangle in the first iteration, it is sometimes possible to shift the rectangle further to the left or right, resulting in less whitespace. True (default) enables the shift and false disables it. Disabling the shift produces a greater approximated area by the first iteration and a layout, when using ONLY the first iteration (default not the case), where it is sometimes impossible to implement a size transformation of rectangles that will fill the bounding box and eliminate empty spaces.").defaultValue((Object)true).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.HIDDEN).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.currentPosition").group("").name("Current position of a node in the order of nodes").description("The rectangles are ordered. Normally according to their definition the the model. This option specifies the current position of a node.").defaultValue((Object)-1).lowerBound(CURRENT_POSITION_LOWER_BOUND).type(LayoutOptionData.Type.INT).optionClass(Integer.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.HIDDEN).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.desiredPosition").group("").name("Desired index of node").description("The rectangles are ordered. Normally according to their definition the the model. This option allows to specify a desired position that has preference over the original position.").defaultValue((Object)-1).lowerBound(DESIRED_POSITION_LOWER_BOUND).type(LayoutOptionData.Type.INT).optionClass(Integer.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.onlyFirstIteration").group("").name("Only Area Approximation").description("If enabled only the width approximation step is executed and the nodes are placed accordingly. The nodes are layouted according to the packingStrategy. If set to true not expansion of nodes is taking place.").defaultValue((Object)false).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.HIDDEN).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.rowCompaction").group("").name("Compact Rows").description("Enables compaction. Compacts blocks if they do not use the full height of the row. This option allows to have a smaller drawing. If this option is disabled all nodes are placed next to each other in rows.").defaultValue((Object)true).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.HIDDEN).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.expandToAspectRatio").group("").name("Fit Aspect Ratio").description("Expands nodes if expandNodes is true to fit the aspect ratio instead of only in their bounds. The option is only useful if the used packingStrategy is ASPECT_RATIO_DRIVEN, otherwise this may result in unreasonable ndoe expansion.").defaultValue((Object)false).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        registry.addDependency("org.eclipse.elk.rectpacking.expandToAspectRatio", "org.eclipse.elk.expandNodes", null);
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.rectpacking.targetWidth").group("").name("Target Width").description("Option to place the rectangles in the given target width instead of approximating the width using the desired aspect ratio.").defaultValue((Object)-1.0).type(LayoutOptionData.Type.DOUBLE).optionClass(Double.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        new RectPackingOptions().apply(registry);
    }
}

